/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.core.input.action;

import java.nio.LongBuffer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.phoenixra.atumvr.api.enums.ControllerType;
import me.phoenixra.atumvr.core.OpenXRProvider;
import me.phoenixra.atumvr.core.enums.XRInputActionType;
import me.phoenixra.atumvr.core.enums.XRInteractionProfile;
import me.phoenixra.atumvr.core.input.OpenXRInputHandler;
import me.phoenixra.atumvr.core.input.action.OpenXRAction;
import me.phoenixra.atumvr.core.input.action.OpenXRActionSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XR10;
import org.lwjgl.openxr.XrAction;
import org.lwjgl.openxr.XrActionCreateInfo;
import org.lwjgl.openxr.XrActionStateGetInfo;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public abstract class OpenXRMultiAction<T>
extends OpenXRAction {
    protected static final XrActionStateGetInfo getInfo = XrActionStateGetInfo.calloc().type(58);
    protected final List<? extends SubAction<T>> subActions;

    public OpenXRMultiAction(OpenXRProvider provider, OpenXRActionSet actionSet, String id, String localizedName, XRInputActionType actionType, List<? extends SubAction<T>> subActions) {
        super(provider, actionSet, id, localizedName, actionType);
        this.subActions = Collections.unmodifiableList(subActions);
    }

    protected abstract void onInit(OpenXRActionSet var1, MemoryStack var2);

    @Override
    public void init(OpenXRActionSet actionSet) {
        OpenXRInputHandler inputHandler = this.provider.getInputHandler();
        try (MemoryStack stack = MemoryStack.stackPush();){
            LongBuffer subactionPaths = stack.callocLong(this.subActions.size());
            int i = 0;
            for (SubAction<T> entry : this.subActions) {
                entry.setPathHandle(inputHandler.getPath(entry.pathName));
                subactionPaths.put(i, entry.pathHandle);
                ++i;
            }
            XrActionCreateInfo actionCreateInfo = XrActionCreateInfo.calloc(stack).set(29, 0L, MemoryUtil.memUTF8((CharSequence)this.id), this.actionType.getId(), this.subActions.size(), subactionPaths, MemoryUtil.memUTF8((CharSequence)this.localizedName));
            PointerBuffer pp = MemoryStack.stackCallocPointer((int)1);
            this.provider.checkXRError(XR10.xrCreateAction(actionSet.getHandle(), actionCreateInfo, pp), "xrCreateAction", new String[0]);
            this.handle = new XrAction(pp.get(), actionSet.getHandle());
            this.onInit(actionSet, stack);
        }
    }

    public SubAction<T> getHandSubaction(ControllerType type) {
        return this.subActions.get(type.ordinal());
    }

    public List<? extends SubAction<T>> getSubActions() {
        return this.subActions;
    }

    public static class SubAction<T> {
        protected Map<XRInteractionProfile, String> defaultBindings = new LinkedHashMap<XRInteractionProfile, String>();
        private final String id;
        protected String pathName;
        protected long pathHandle;
        protected T currentState;
        protected long lastChangeTime = 0L;
        protected boolean changed = false;
        protected boolean active = false;

        public SubAction(String id, String path, T initialState) {
            this.id = id;
            this.pathName = path;
            this.currentState = initialState;
        }

        public void update(T state, long lastChangeTime, boolean changedSinceLastSync, boolean isActive) {
            this.currentState = state;
            this.lastChangeTime = lastChangeTime;
            this.changed = changedSinceLastSync;
            this.active = isActive;
        }

        public SubAction<T> putDefaultBindings(@NotNull XRInteractionProfile profile, @Nullable String source) {
            this.defaultBindings.put(profile, this.pathName + "/" + source);
            return this;
        }

        public SubAction<T> putDefaultBindings(@NotNull List<XRInteractionProfile> profiles, @Nullable String source) {
            for (XRInteractionProfile profile : profiles) {
                this.defaultBindings.put(profile, this.pathName + "/" + source);
            }
            return this;
        }

        @Nullable
        public String getDefaultBindings(XRInteractionProfile profile) {
            return this.defaultBindings.get((Object)profile);
        }

        public Map<XRInteractionProfile, String> getDefaultBindings() {
            return this.defaultBindings;
        }

        public String getPathName() {
            return this.pathName;
        }

        public long getPathHandle() {
            return this.pathHandle;
        }

        public T getCurrentState() {
            return this.currentState;
        }

        public long getLastChangeTime() {
            return this.lastChangeTime;
        }

        public boolean isChanged() {
            return this.changed;
        }

        public boolean isActive() {
            return this.active;
        }

        public String getId() {
            return this.id;
        }

        public void setPathHandle(long pathHandle) {
            this.pathHandle = pathHandle;
        }
    }
}

