/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.core.input.action;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.phoenixra.atumvr.core.OpenXRProvider;
import me.phoenixra.atumvr.core.enums.XRInputActionType;
import me.phoenixra.atumvr.core.enums.XRInteractionProfile;
import me.phoenixra.atumvr.core.input.action.OpenXRAction;
import me.phoenixra.atumvr.core.input.action.OpenXRActionSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XR10;
import org.lwjgl.openxr.XrAction;
import org.lwjgl.openxr.XrActionCreateInfo;
import org.lwjgl.openxr.XrActionStateGetInfo;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public abstract class OpenXRSingleAction<T>
extends OpenXRAction {
    protected static final XrActionStateGetInfo getInfo = XrActionStateGetInfo.calloc().type(58);
    protected Map<XRInteractionProfile, String> defaultBindings = new LinkedHashMap<XRInteractionProfile, String>();
    protected T currentState;
    protected long lastChangeTime;
    protected boolean changed;
    protected boolean active;

    public OpenXRSingleAction(OpenXRProvider provider, OpenXRActionSet actionSet, String id, String localizedName, XRInputActionType actionType) {
        super(provider, actionSet, id, localizedName, actionType);
    }

    protected abstract void onInit(OpenXRActionSet var1, MemoryStack var2);

    @Override
    public void init(OpenXRActionSet actionSet) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            XrActionCreateInfo actionCreateInfo = XrActionCreateInfo.calloc(stack).set(29, 0L, MemoryUtil.memUTF8((CharSequence)this.id), this.actionType.getId(), 0, null, MemoryUtil.memUTF8((CharSequence)this.localizedName));
            PointerBuffer pp = MemoryStack.stackCallocPointer((int)1);
            this.provider.checkXRError(XR10.xrCreateAction(actionSet.getHandle(), actionCreateInfo, pp), "xrCreateAction", new String[0]);
            this.handle = new XrAction(pp.get(), actionSet.getHandle());
            this.onInit(actionSet, stack);
        }
    }

    public OpenXRSingleAction<T> putDefaultBindings(@NotNull XRInteractionProfile profile, @Nullable String source) {
        this.defaultBindings.put(profile, source);
        return this;
    }

    public OpenXRSingleAction<T> putDefaultBindings(@NotNull List<XRInteractionProfile> profiles, @Nullable String source) {
        for (XRInteractionProfile profile : profiles) {
            this.defaultBindings.put(profile, source);
        }
        return this;
    }

    @Nullable
    public String getDefaultBindings(XRInteractionProfile profile) {
        return this.defaultBindings.get((Object)profile);
    }

    public Map<XRInteractionProfile, String> getDefaultBindings() {
        return this.defaultBindings;
    }

    public T getCurrentState() {
        return this.currentState;
    }

    public long getLastChangeTime() {
        return this.lastChangeTime;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean isActive() {
        return this.active;
    }
}

