/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.core.input.action.profileset.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.phoenixra.atumvr.api.input.action.VRActionDataButton;
import me.phoenixra.atumvr.api.input.action.VRActionDataVec2;
import me.phoenixra.atumvr.core.OpenXRProvider;
import me.phoenixra.atumvr.core.enums.XRInteractionProfile;
import me.phoenixra.atumvr.core.input.action.OpenXRAction;
import me.phoenixra.atumvr.core.input.action.OpenXRActionSet;
import me.phoenixra.atumvr.core.input.action.profileset.OpenXRProfileSet;
import me.phoenixra.atumvr.core.input.action.types.multi.BoolButtonMultiAction;
import me.phoenixra.atumvr.core.input.action.types.multi.FloatButtonMultiAction;
import me.phoenixra.atumvr.core.input.action.types.multi.Vec2MultiAction;
import me.phoenixra.atumvr.core.input.action.types.single.BoolButtonAction;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2f;

public class OculusTouchSet
extends OpenXRProfileSet {
    private static final XRInteractionProfile PROFILE = XRInteractionProfile.OCULUS_TOUCH;
    public static final String BUTTON_MENU = "button.menu";
    public static final String BUTTON_SYSTEM = "button.system";
    public static final String BUTTON_X = "button.x";
    public static final String BUTTON_A = "button.a";
    public static final String BUTTON_X_TOUCH = "button.x.touch";
    public static final String BUTTON_A_TOUCH = "button.a.touch";
    public static final String BUTTON_Y = "button.y";
    public static final String BUTTON_B = "button.b";
    public static final String BUTTON_Y_TOUCH = "button.y.touch";
    public static final String BUTTON_B_TOUCH = "button.b.touch";
    public static final String BUTTON_GRIP_LEFT = "button.grip.left";
    public static final String BUTTON_GRIP_RIGHT = "button.grip.right";
    public static final String BUTTON_TRIGGER_LEFT = "button.trigger.left";
    public static final String BUTTON_TRIGGER_RIGHT = "button.trigger.right";
    public static final String BUTTON_TRIGGER_TOUCH_LEFT = "button.trigger.touch.left";
    public static final String BUTTON_TRIGGER_TOUCH_RIGHT = "button.trigger.touch.right";
    public static final String BUTTON_THUMBSTICK_LEFT = "button.thumbstick.left";
    public static final String BUTTON_THUMBSTICK_RIGHT = "button.thumbstick.right";
    public static final String BUTTON_THUMBSTICK_TOUCH_LEFT = "button.thumbstick.touch.left";
    public static final String BUTTON_THUMBSTICK_TOUCH_RIGHT = "button.thumbstick.touch.right";
    public static final String BUTTON_THUMBREST_TOUCH_LEFT = "button.thumbrest.touch.left";
    public static final String BUTTON_THUMBREST_TOUCH_RIGHT = "button.thumbrest.touch.right";
    public static final String VEC2_THUMBSTICK_LEFT = "vec2.thumbstick.left";
    public static final String VEC2_THUMBSTICK_RIGHT = "vec2.thumbstick.right";
    private BoolButtonAction menuButton;
    private BoolButtonAction systemButton;
    private BoolButtonMultiAction primaryButton;
    private BoolButtonMultiAction primaryButtonTouch;
    private BoolButtonMultiAction secondaryButton;
    private BoolButtonMultiAction secondaryButtonTouch;
    private FloatButtonMultiAction gripValue;
    private FloatButtonMultiAction triggerValue;
    private BoolButtonMultiAction triggerTouch;
    private Vec2MultiAction thumbStick;
    private BoolButtonMultiAction thumbStickButton;
    private BoolButtonMultiAction thumbStickTouch;
    private BoolButtonMultiAction thumbRestTouch;
    private Map<String, VRActionDataButton> buttonMap;
    private Map<String, VRActionDataVec2> vec2Map;

    public OculusTouchSet(OpenXRProvider provider) {
        super(provider, "oculus_touch", "Oculus Touch Controller", 0);
    }

    @Override
    protected List<OpenXRAction> loadActions(OpenXRProvider provider) {
        this.menuButton = new BoolButtonAction(provider, this, BUTTON_MENU, "Menu Button").putDefaultBindings(PROFILE, "/user/hand/left/input/menu/click");
        this.systemButton = new BoolButtonAction(provider, this, BUTTON_SYSTEM, "System Button").putDefaultBindings(PROFILE, "/user/hand/right/input/system/click");
        this.primaryButton = new BoolButtonMultiAction(provider, (OpenXRActionSet)this, "button.primary", "Primary Button", List.of(new BoolButtonMultiAction.SubActionBoolButton(BUTTON_X, "/user/hand/left", false).putDefaultBindings(PROFILE, "input/x/click"), new BoolButtonMultiAction.SubActionBoolButton(BUTTON_A, "/user/hand/right", false).putDefaultBindings(PROFILE, "input/a/click")));
        this.primaryButtonTouch = new BoolButtonMultiAction(provider, (OpenXRActionSet)this, "button.primary.touch", "Primary Button Touch", List.of(new BoolButtonMultiAction.SubActionBoolButton(BUTTON_X_TOUCH, "/user/hand/left", false).putDefaultBindings(PROFILE, "input/x/touch"), new BoolButtonMultiAction.SubActionBoolButton(BUTTON_A_TOUCH, "/user/hand/right", false).putDefaultBindings(PROFILE, "input/a/touch")));
        this.secondaryButton = new BoolButtonMultiAction(provider, (OpenXRActionSet)this, "button.secondary", "Secondary Button", List.of(new BoolButtonMultiAction.SubActionBoolButton(BUTTON_Y, "/user/hand/left", false).putDefaultBindings(PROFILE, "input/y/click"), new BoolButtonMultiAction.SubActionBoolButton(BUTTON_B, "/user/hand/right", false).putDefaultBindings(PROFILE, "input/b/click")));
        this.secondaryButtonTouch = new BoolButtonMultiAction(provider, (OpenXRActionSet)this, "button.secondary.touch", "Secondary Button Touch", List.of(new BoolButtonMultiAction.SubActionBoolButton(BUTTON_Y_TOUCH, "/user/hand/left", false).putDefaultBindings(PROFILE, "input/y/touch"), new BoolButtonMultiAction.SubActionBoolButton(BUTTON_B_TOUCH, "/user/hand/right", false).putDefaultBindings(PROFILE, "input/b/touch")));
        this.gripValue = new FloatButtonMultiAction(provider, this, "button.grip", "Grip Value", 0.9f, 0.85f, List.of(new FloatButtonMultiAction.SubActionFloatButton(BUTTON_GRIP_LEFT, "/user/hand/left", Float.valueOf(0.0f)).putDefaultBindings(PROFILE, "input/squeeze/value"), new FloatButtonMultiAction.SubActionFloatButton(BUTTON_GRIP_RIGHT, "/user/hand/right", Float.valueOf(0.0f)).putDefaultBindings(PROFILE, "input/squeeze/value")));
        this.triggerValue = new FloatButtonMultiAction(provider, this, "button.trigger", "Trigger Value", 0.7f, 0.65f, List.of(new FloatButtonMultiAction.SubActionFloatButton(BUTTON_TRIGGER_LEFT, "/user/hand/left", Float.valueOf(0.0f)).putDefaultBindings(PROFILE, "input/trigger/value"), new FloatButtonMultiAction.SubActionFloatButton(BUTTON_TRIGGER_RIGHT, "/user/hand/right", Float.valueOf(0.0f)).putDefaultBindings(PROFILE, "input/trigger/value")));
        this.triggerTouch = new BoolButtonMultiAction(provider, (OpenXRActionSet)this, "button.trigger.touch", "Trigger Touch", List.of(new BoolButtonMultiAction.SubActionBoolButton(BUTTON_TRIGGER_TOUCH_LEFT, "/user/hand/left", false).putDefaultBindings(PROFILE, "input/trigger/touch"), new BoolButtonMultiAction.SubActionBoolButton(BUTTON_TRIGGER_TOUCH_RIGHT, "/user/hand/right", false).putDefaultBindings(PROFILE, "input/trigger/touch")));
        this.thumbStick = new Vec2MultiAction(provider, (OpenXRActionSet)this, "vec2.thumbstick", "Thumbstick", List.of(new Vec2MultiAction.SubActionVec2(VEC2_THUMBSTICK_LEFT, "/user/hand/left", new Vector2f(0.0f, 0.0f)).putDefaultBindings(PROFILE, "input/thumbstick"), new Vec2MultiAction.SubActionVec2(VEC2_THUMBSTICK_RIGHT, "/user/hand/right", new Vector2f(0.0f, 0.0f)).putDefaultBindings(PROFILE, "input/thumbstick")));
        this.thumbStickButton = new BoolButtonMultiAction(provider, (OpenXRActionSet)this, "button.thumbstick", "Thumbstick Button", List.of(new BoolButtonMultiAction.SubActionBoolButton(BUTTON_THUMBSTICK_LEFT, "/user/hand/left", false).putDefaultBindings(PROFILE, "input/thumbstick/click"), new BoolButtonMultiAction.SubActionBoolButton(BUTTON_THUMBSTICK_RIGHT, "/user/hand/right", false).putDefaultBindings(PROFILE, "input/thumbstick/click")));
        this.thumbStickTouch = new BoolButtonMultiAction(provider, (OpenXRActionSet)this, "button.thumbstick.touch", "Thumbstick Touch", List.of(new BoolButtonMultiAction.SubActionBoolButton(BUTTON_THUMBSTICK_TOUCH_LEFT, "/user/hand/left", false).putDefaultBindings(PROFILE, "input/thumbstick/touch"), new BoolButtonMultiAction.SubActionBoolButton(BUTTON_THUMBSTICK_TOUCH_RIGHT, "/user/hand/right", false).putDefaultBindings(PROFILE, "input/thumbstick/touch")));
        this.thumbRestTouch = new BoolButtonMultiAction(provider, (OpenXRActionSet)this, "button.thumbrest.touch", "Thumbrest Touch", List.of(new BoolButtonMultiAction.SubActionBoolButton(BUTTON_THUMBREST_TOUCH_LEFT, "/user/hand/left", false).putDefaultBindings(PROFILE, "input/thumbrest/touch"), new BoolButtonMultiAction.SubActionBoolButton(BUTTON_THUMBREST_TOUCH_RIGHT, "/user/hand/right", false).putDefaultBindings(PROFILE, "input/thumbrest/touch")));
        ArrayList<VRActionDataButton> listButton = new ArrayList<VRActionDataButton>();
        listButton.add(this.menuButton);
        listButton.add(this.systemButton);
        listButton.addAll(this.primaryButton.getSubActionsAsButton());
        listButton.addAll(this.primaryButtonTouch.getSubActionsAsButton());
        listButton.addAll(this.secondaryButton.getSubActionsAsButton());
        listButton.addAll(this.secondaryButtonTouch.getSubActionsAsButton());
        listButton.addAll(this.gripValue.getSubActionsAsButton());
        listButton.addAll(this.triggerValue.getSubActionsAsButton());
        listButton.addAll(this.triggerTouch.getSubActionsAsButton());
        listButton.addAll(this.thumbStickButton.getSubActionsAsButton());
        listButton.addAll(this.thumbStickTouch.getSubActionsAsButton());
        listButton.addAll(this.thumbRestTouch.getSubActionsAsButton());
        this.buttonMap = new LinkedHashMap<String, VRActionDataButton>();
        for (VRActionDataButton entry : listButton) {
            this.buttonMap.put(entry.getId(), entry);
        }
        ArrayList<Vec2MultiAction.SubActionVec2> listVec2 = new ArrayList<Vec2MultiAction.SubActionVec2>(this.thumbStick.getSubActionsAsVec2());
        this.vec2Map = new LinkedHashMap<String, VRActionDataVec2>();
        for (VRActionDataVec2 vRActionDataVec2 : listVec2) {
            this.vec2Map.put(vRActionDataVec2.getId(), vRActionDataVec2);
        }
        return List.of(this.menuButton, this.systemButton, this.primaryButton, this.primaryButtonTouch, this.secondaryButton, this.secondaryButtonTouch, this.gripValue, this.triggerValue, this.triggerTouch, this.thumbStick, this.thumbStickButton, this.thumbStickTouch, this.thumbRestTouch);
    }

    @Override
    public Collection<String> getButtonIds() {
        return Collections.unmodifiableCollection(this.buttonMap.keySet());
    }

    @Override
    public VRActionDataButton getButton(@NotNull String id) {
        return this.buttonMap.get(id);
    }

    @Override
    public Collection<String> getVec2Ids() {
        return Collections.unmodifiableCollection(this.vec2Map.keySet());
    }

    @Override
    public VRActionDataVec2 getVec2(@NotNull String id) {
        return this.vec2Map.get(id);
    }

    @Override
    @NotNull
    public XRInteractionProfile getType() {
        return PROFILE;
    }

    public BoolButtonAction getMenuButton() {
        return this.menuButton;
    }

    public BoolButtonAction getSystemButton() {
        return this.systemButton;
    }

    public BoolButtonMultiAction getPrimaryButton() {
        return this.primaryButton;
    }

    public BoolButtonMultiAction getPrimaryButtonTouch() {
        return this.primaryButtonTouch;
    }

    public BoolButtonMultiAction getSecondaryButton() {
        return this.secondaryButton;
    }

    public BoolButtonMultiAction getSecondaryButtonTouch() {
        return this.secondaryButtonTouch;
    }

    public FloatButtonMultiAction getGripValue() {
        return this.gripValue;
    }

    @Override
    public FloatButtonMultiAction getTriggerValue() {
        return this.triggerValue;
    }

    public BoolButtonMultiAction getTriggerTouch() {
        return this.triggerTouch;
    }

    public Vec2MultiAction getThumbStick() {
        return this.thumbStick;
    }

    public BoolButtonMultiAction getThumbStickButton() {
        return this.thumbStickButton;
    }

    public BoolButtonMultiAction getThumbStickTouch() {
        return this.thumbStickTouch;
    }

    public BoolButtonMultiAction getThumbRestTouch() {
        return this.thumbRestTouch;
    }

    public Map<String, VRActionDataButton> getButtonMap() {
        return this.buttonMap;
    }

    public Map<String, VRActionDataVec2> getVec2Map() {
        return this.vec2Map;
    }
}

