/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.core.input.action.profileset.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.phoenixra.atumvr.api.input.action.VRActionDataButton;
import me.phoenixra.atumvr.api.input.action.VRActionDataVec2;
import me.phoenixra.atumvr.core.OpenXRProvider;
import me.phoenixra.atumvr.core.enums.XRInteractionProfile;
import me.phoenixra.atumvr.core.input.action.OpenXRAction;
import me.phoenixra.atumvr.core.input.action.OpenXRActionSet;
import me.phoenixra.atumvr.core.input.action.OpenXRMultiAction;
import me.phoenixra.atumvr.core.input.action.profileset.OpenXRProfileSet;
import me.phoenixra.atumvr.core.input.action.types.multi.BoolButtonMultiAction;
import me.phoenixra.atumvr.core.input.action.types.multi.FloatButtonMultiAction;
import me.phoenixra.atumvr.core.input.action.types.multi.Vec2MultiAction;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2f;

public class WindowsMotionSet
extends OpenXRProfileSet {
    private static final XRInteractionProfile PROFILE = XRInteractionProfile.WINDOWS_MOTION;
    public static final String BUTTON_MENU_LEFT = "button.menu.left";
    public static final String BUTTON_MENU_RIGHT = "button.menu.right";
    public static final String BUTTON_GRIP_LEFT = "button.grip.left";
    public static final String BUTTON_GRIP_RIGHT = "button.grip.right";
    public static final String BUTTON_TRIGGER_LEFT = "button.trigger.left";
    public static final String BUTTON_TRIGGER_RIGHT = "button.trigger.right";
    public static final String BUTTON_THUMBSTICK_LEFT = "button.thumbstick.left";
    public static final String BUTTON_THUMBSTICK_RIGHT = "button.thumbstick.right";
    public static final String BUTTON_TRACKPAD_LEFT = "button.trackpad.touch.left";
    public static final String BUTTON_TRACKPAD_RIGHT = "button.trackpad.touch.right";
    public static final String BUTTON_TRACKPAD_TOUCH_LEFT = "button.trackpad.touch.left";
    public static final String BUTTON_TRACKPAD_TOUCH_RIGHT = "button.trackpad.touch.right";
    public static final String VEC2_THUMBSTICK_LEFT = "vec2.thumbstick.left";
    public static final String VEC2_THUMBSTICK_RIGHT = "vec2.thumbstick.right";
    public static final String VEC2_TRACKPAD_LEFT = "vec2.trackpad.left";
    public static final String VEC2_TRACKPAD_RIGHT = "vec2.trackpad.right";
    private BoolButtonMultiAction menuButton;
    private BoolButtonMultiAction gripButton;
    private FloatButtonMultiAction triggerValue;
    private Vec2MultiAction thumbStick;
    private BoolButtonMultiAction thumbStickButton;
    private Vec2MultiAction trackpad;
    private BoolButtonMultiAction trackpadTouch;
    private BoolButtonMultiAction trackpadButton;
    private Map<String, VRActionDataButton> buttonMap;
    private Map<String, VRActionDataVec2> vec2Map;

    public WindowsMotionSet(OpenXRProvider provider) {
        super(provider, "windows_motion", "Windows Motion Controller", 0);
    }

    @Override
    protected List<OpenXRAction> loadActions(OpenXRProvider provider) {
        this.menuButton = new BoolButtonMultiAction(provider, (OpenXRActionSet)this, "button.menu", "Menu Button", List.of(new BoolButtonMultiAction.SubActionBoolButton(BUTTON_MENU_LEFT, "/user/hand/left", false).putDefaultBindings(PROFILE, "input/menu/click"), new BoolButtonMultiAction.SubActionBoolButton(BUTTON_MENU_RIGHT, "/user/hand/right", false).putDefaultBindings(PROFILE, "input/menu/click")));
        this.gripButton = new BoolButtonMultiAction(provider, (OpenXRActionSet)this, "button.grip", "Grip Button", List.of(new BoolButtonMultiAction.SubActionBoolButton(BUTTON_GRIP_LEFT, "/user/hand/left", false).putDefaultBindings(PROFILE, "input/squeeze/click"), new BoolButtonMultiAction.SubActionBoolButton(BUTTON_GRIP_RIGHT, "/user/hand/right", false).putDefaultBindings(PROFILE, "input/squeeze/click")));
        this.triggerValue = new FloatButtonMultiAction(provider, this, "button.trigger", "Trigger Value", 0.7f, 0.65f, List.of(new FloatButtonMultiAction.SubActionFloatButton(BUTTON_TRIGGER_LEFT, "/user/hand/left", Float.valueOf(0.0f)).putDefaultBindings(PROFILE, "input/trigger/value"), new FloatButtonMultiAction.SubActionFloatButton(BUTTON_TRIGGER_RIGHT, "/user/hand/right", Float.valueOf(0.0f)).putDefaultBindings(PROFILE, "input/trigger/value")));
        this.thumbStick = new Vec2MultiAction(provider, (OpenXRActionSet)this, "vec2.thumbstick", "Thumbstick", List.of(new Vec2MultiAction.SubActionVec2(VEC2_THUMBSTICK_LEFT, "/user/hand/left", new Vector2f(0.0f, 0.0f)).putDefaultBindings(PROFILE, "input/thumbstick"), new Vec2MultiAction.SubActionVec2(VEC2_THUMBSTICK_RIGHT, "/user/hand/right", new Vector2f(0.0f, 0.0f)).putDefaultBindings(PROFILE, "input/thumbstick")));
        this.thumbStickButton = new BoolButtonMultiAction(provider, (OpenXRActionSet)this, "button.thumbstick", "Thumbstick Button", List.of(new BoolButtonMultiAction.SubActionBoolButton(BUTTON_THUMBSTICK_LEFT, "/user/hand/left", false).putDefaultBindings(PROFILE, "input/thumbstick/click"), new BoolButtonMultiAction.SubActionBoolButton(BUTTON_THUMBSTICK_RIGHT, "/user/hand/right", false).putDefaultBindings(PROFILE, "input/thumbstick/click")));
        this.trackpad = new Vec2MultiAction(provider, (OpenXRActionSet)this, "vec2.trackpad", "Trackpad", List.of(new Vec2MultiAction.SubActionVec2(VEC2_TRACKPAD_LEFT, "/user/hand/left", new Vector2f(0.0f, 0.0f)).putDefaultBindings(PROFILE, "input/trackpad"), new Vec2MultiAction.SubActionVec2(VEC2_TRACKPAD_RIGHT, "/user/hand/right", new Vector2f(0.0f, 0.0f)).putDefaultBindings(PROFILE, "input/trackpad")));
        this.trackpadTouch = new BoolButtonMultiAction(provider, (OpenXRActionSet)this, "button.trackpad.touch", "Trackpad Touch", List.of(new BoolButtonMultiAction.SubActionBoolButton("button.trackpad.touch.left", "/user/hand/left", false).putDefaultBindings(PROFILE, "input/trackpad/touch"), new BoolButtonMultiAction.SubActionBoolButton("button.trackpad.touch.right", "/user/hand/right", false).putDefaultBindings(PROFILE, "input/trackpad/touch")));
        this.trackpadButton = new BoolButtonMultiAction(provider, (OpenXRActionSet)this, "button.trackpad", "Trackpad Button", List.of(new BoolButtonMultiAction.SubActionBoolButton("button.trackpad.touch.left", "/user/hand/left", false).putDefaultBindings(PROFILE, "input/trackpad/click"), new BoolButtonMultiAction.SubActionBoolButton("button.trackpad.touch.right", "/user/hand/right", false).putDefaultBindings(PROFILE, "input/trackpad/click")));
        ArrayList<OpenXRMultiAction.SubAction> listButton = new ArrayList<OpenXRMultiAction.SubAction>();
        listButton.addAll(this.menuButton.getSubActionsAsButton());
        listButton.addAll(this.gripButton.getSubActionsAsButton());
        listButton.addAll(this.triggerValue.getSubActionsAsButton());
        listButton.addAll(this.thumbStickButton.getSubActionsAsButton());
        listButton.addAll(this.trackpadButton.getSubActionsAsButton());
        listButton.addAll(this.trackpadTouch.getSubActionsAsButton());
        this.buttonMap = new LinkedHashMap<String, VRActionDataButton>();
        for (VRActionDataButton vRActionDataButton : listButton) {
            this.buttonMap.put(vRActionDataButton.getId(), vRActionDataButton);
        }
        ArrayList<Vec2MultiAction.SubActionVec2> listVec2 = new ArrayList<Vec2MultiAction.SubActionVec2>();
        listVec2.addAll(this.trackpad.getSubActionsAsVec2());
        listVec2.addAll(this.thumbStick.getSubActionsAsVec2());
        this.vec2Map = new LinkedHashMap<String, VRActionDataVec2>();
        for (VRActionDataVec2 vRActionDataVec2 : listVec2) {
            this.vec2Map.put(vRActionDataVec2.getId(), vRActionDataVec2);
        }
        return List.of(this.menuButton, this.gripButton, this.triggerValue, this.thumbStick, this.thumbStickButton, this.trackpad, this.trackpadTouch, this.trackpadButton);
    }

    @Override
    public Collection<String> getButtonIds() {
        return Collections.unmodifiableCollection(this.buttonMap.keySet());
    }

    @Override
    public VRActionDataButton getButton(@NotNull String id) {
        return this.buttonMap.get(id);
    }

    @Override
    public Collection<String> getVec2Ids() {
        return Collections.unmodifiableCollection(this.vec2Map.keySet());
    }

    @Override
    public VRActionDataVec2 getVec2(@NotNull String id) {
        return this.vec2Map.get(id);
    }

    @Override
    @NotNull
    public XRInteractionProfile getType() {
        return PROFILE;
    }

    public BoolButtonMultiAction getMenuButton() {
        return this.menuButton;
    }

    public BoolButtonMultiAction getGripButton() {
        return this.gripButton;
    }

    @Override
    public FloatButtonMultiAction getTriggerValue() {
        return this.triggerValue;
    }

    public Vec2MultiAction getThumbStick() {
        return this.thumbStick;
    }

    public BoolButtonMultiAction getThumbStickButton() {
        return this.thumbStickButton;
    }

    public Vec2MultiAction getTrackpad() {
        return this.trackpad;
    }

    public BoolButtonMultiAction getTrackpadTouch() {
        return this.trackpadTouch;
    }

    public BoolButtonMultiAction getTrackpadButton() {
        return this.trackpadButton;
    }

    public Map<String, VRActionDataButton> getButtonMap() {
        return this.buttonMap;
    }

    public Map<String, VRActionDataVec2> getVec2Map() {
        return this.vec2Map;
    }
}

