/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.core.input.action.types;

import java.lang.invoke.CallSite;
import java.nio.LongBuffer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import me.phoenixra.atumconfig.api.tuples.PairRecord;
import me.phoenixra.atumvr.api.enums.ControllerType;
import me.phoenixra.atumvr.api.exceptions.VRException;
import me.phoenixra.atumvr.core.OpenXRProvider;
import me.phoenixra.atumvr.core.enums.XRInputActionType;
import me.phoenixra.atumvr.core.enums.XRInteractionProfile;
import me.phoenixra.atumvr.core.input.OpenXRInputHandler;
import me.phoenixra.atumvr.core.input.action.OpenXRAction;
import me.phoenixra.atumvr.core.input.action.OpenXRActionSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XR10;
import org.lwjgl.openxr.XrAction;
import org.lwjgl.openxr.XrActionCreateInfo;
import org.lwjgl.openxr.XrHapticActionInfo;
import org.lwjgl.openxr.XrHapticBaseHeader;
import org.lwjgl.openxr.XrHapticVibration;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.system.MemoryStack;

public class HapticPulseAction
extends OpenXRAction {
    protected Map<XRInteractionProfile, PairRecord<String, String>> defaultBindings = new LinkedHashMap<XRInteractionProfile, PairRecord<String, String>>();

    public HapticPulseAction(OpenXRProvider provider, OpenXRActionSet actionSet, String name, String localizedName) {
        super(provider, actionSet, name, localizedName, XRInputActionType.HAPTIC);
    }

    @Override
    public void init(OpenXRActionSet actionSet) {
        OpenXRInputHandler inputHandler = this.provider.getInputHandler();
        try (MemoryStack stack = MemoryStack.stackPush();){
            LongBuffer paths = stack.callocLong(2);
            paths.put(0, inputHandler.getPath("/user/hand/left"));
            paths.put(1, inputHandler.getPath("/user/hand/right"));
            XrActionCreateInfo actionCreateInfo = XrActionCreateInfo.calloc(stack).type(29).next(0L).actionType(this.actionType.getId()).actionName(stack.UTF8((CharSequence)this.id)).localizedActionName(stack.UTF8((CharSequence)this.localizedName)).countSubactionPaths(2).subactionPaths(paths);
            PointerBuffer pAction = stack.callocPointer(1);
            XR10.xrCreateAction(actionSet.getHandle(), actionCreateInfo, pAction);
            this.handle = new XrAction(pAction.get(0), actionSet.getHandle());
        }
    }

    @Override
    public void update(@Nullable Consumer<String> listener) {
    }

    public void triggerHapticPulse(ControllerType controllerType, float frequency, float amplitude, float durationSeconds) {
        this.triggerHapticPulse(controllerType, frequency, amplitude, (long)(durationSeconds * 1.0E9f));
    }

    public void triggerHapticPulse(ControllerType controllerType, float frequency, float amplitude, long durationNanoSec) {
        if (this.handle == null) {
            throw new VRException("Tried to apply haptic pulse before action initialized");
        }
        XrSession session = this.provider.getState().getVrSession().getHandle();
        OpenXRInputHandler inputHandler = this.provider.getInputHandler();
        try (MemoryStack stack = MemoryStack.stackPush();){
            long subPath = inputHandler.getPath(controllerType == ControllerType.LEFT ? "/user/hand/left" : "/user/hand/right");
            XrHapticActionInfo info = XrHapticActionInfo.calloc(stack).next(0L).type(59).action(this.handle).subactionPath(subPath);
            XrHapticVibration vib = XrHapticVibration.calloc(stack).next(0L).type(13).duration(durationNanoSec).frequency(frequency).amplitude(amplitude);
            XR10.xrApplyHapticFeedback(session, info, XrHapticBaseHeader.create(vib.address()));
        }
    }

    public HapticPulseAction putDefaultBindings(@NotNull XRInteractionProfile profile, @Nullable String source) {
        this.defaultBindings.put(profile, new PairRecord<CallSite, CallSite>((CallSite)((Object)("/user/hand/left/" + source)), (CallSite)((Object)("/user/hand/right/" + source))));
        return this;
    }

    public HapticPulseAction putDefaultBindings(@NotNull List<XRInteractionProfile> profiles, @Nullable String source) {
        for (XRInteractionProfile profile : profiles) {
            this.defaultBindings.put(profile, new PairRecord<CallSite, CallSite>((CallSite)((Object)("/user/hand/left/" + source)), (CallSite)((Object)("/user/hand/right/" + source))));
        }
        return this;
    }

    @Nullable
    public PairRecord<String, String> getDefaultBindings(XRInteractionProfile profile) {
        return this.defaultBindings.get((Object)profile);
    }
}

