/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.core.input.action.types.multi;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import me.phoenixra.atumvr.api.enums.ControllerType;
import me.phoenixra.atumvr.api.input.action.VRActionDataButton;
import me.phoenixra.atumvr.core.OpenXRProvider;
import me.phoenixra.atumvr.core.enums.XRInputActionType;
import me.phoenixra.atumvr.core.enums.XRInteractionProfile;
import me.phoenixra.atumvr.core.input.action.OpenXRActionSet;
import me.phoenixra.atumvr.core.input.action.OpenXRMultiAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.openxr.XR10;
import org.lwjgl.openxr.XrActionStateBoolean;
import org.lwjgl.system.MemoryStack;

public class BoolButtonMultiAction
extends OpenXRMultiAction<Boolean> {
    private final List<SubActionBoolButton> subActionsAsButton;

    public BoolButtonMultiAction(OpenXRProvider provider, OpenXRActionSet actionSet, String id, String localizedName, List<SubActionBoolButton> subActions) {
        super(provider, actionSet, id, localizedName, XRInputActionType.BOOLEAN, subActions);
        this.subActionsAsButton = Collections.unmodifiableList(subActions);
    }

    @Override
    protected void onInit(OpenXRActionSet actionSet, MemoryStack stack) {
    }

    @Override
    public void update(@Nullable Consumer<String> listener) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            for (OpenXRMultiAction.SubAction entry : this.subActions) {
                XrActionStateBoolean state = XrActionStateBoolean.calloc(stack).type(this.actionType.getStateId());
                getInfo.subactionPath(entry.getPathHandle());
                getInfo.action(this.handle);
                this.provider.checkXRError(XR10.xrGetActionStateBoolean(this.provider.getState().getVrSession().getHandle(), getInfo, state), "xrGetActionStateFloat", new String[0]);
                entry.update(state.currentState(), state.lastChangeTime(), state.changedSinceLastSync(), state.isActive());
                if (listener == null || !state.changedSinceLastSync()) continue;
                listener.accept(entry.getId());
            }
        }
    }

    public SubActionBoolButton getHandSubaction(ControllerType type) {
        return (SubActionBoolButton)super.getHandSubaction(type);
    }

    public List<SubActionBoolButton> getSubActionsAsButton() {
        return this.subActionsAsButton;
    }

    public static class SubActionBoolButton
    extends OpenXRMultiAction.SubAction<Boolean>
    implements VRActionDataButton {
        public SubActionBoolButton(String id, String path, Boolean initialState) {
            super(id, path, initialState);
        }

        public SubActionBoolButton putDefaultBindings(@NotNull List<XRInteractionProfile> profiles, @Nullable String source) {
            return (SubActionBoolButton)super.putDefaultBindings(profiles, source);
        }

        public SubActionBoolButton putDefaultBindings(@NotNull XRInteractionProfile profile, @Nullable String source) {
            return (SubActionBoolButton)super.putDefaultBindings(profile, source);
        }

        @Override
        public boolean isPressed() {
            return (Boolean)this.currentState;
        }

        @Override
        public boolean isButtonChanged() {
            return this.changed;
        }

        @Override
        public long getButtonLastChangeTime() {
            return this.lastChangeTime;
        }
    }
}

