/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.core.input.action.types.multi;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import me.phoenixra.atumvr.api.enums.ControllerType;
import me.phoenixra.atumvr.api.input.action.VRActionDataButton;
import me.phoenixra.atumvr.core.OpenXRProvider;
import me.phoenixra.atumvr.core.enums.XRInputActionType;
import me.phoenixra.atumvr.core.enums.XRInteractionProfile;
import me.phoenixra.atumvr.core.input.action.OpenXRActionSet;
import me.phoenixra.atumvr.core.input.action.OpenXRMultiAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.openxr.XR10;
import org.lwjgl.openxr.XrActionStateFloat;
import org.lwjgl.system.MemoryStack;

public class FloatButtonMultiAction
extends OpenXRMultiAction<Float> {
    private final float pressThreshold;
    private final float releaseThreshold;
    private final List<SubActionFloatButton> subActionsAsButton;

    public FloatButtonMultiAction(OpenXRProvider provider, OpenXRActionSet actionSet, String id, String localizedName, float pressThreshold, float releaseThreshold, List<SubActionFloatButton> subActions) {
        super(provider, actionSet, id, localizedName, XRInputActionType.FLOAT, subActions);
        this.pressThreshold = pressThreshold;
        this.releaseThreshold = releaseThreshold;
        this.subActionsAsButton = Collections.unmodifiableList(subActions);
    }

    @Override
    protected void onInit(OpenXRActionSet actionSet, MemoryStack stack) {
    }

    @Override
    public void update(@Nullable Consumer<String> listener) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            for (SubActionFloatButton entry : this.subActionsAsButton) {
                XrActionStateFloat state = XrActionStateFloat.calloc(stack).type(this.actionType.getStateId());
                getInfo.subactionPath(entry.getPathHandle());
                getInfo.action(this.handle);
                this.provider.checkXRError(XR10.xrGetActionStateFloat(this.provider.getState().getVrSession().getHandle(), getInfo, state), "xrGetActionStateFloat", new String[0]);
                float v = state.currentState();
                boolean newButtonState = entry.isPressed() ? v >= this.releaseThreshold : v >= this.pressThreshold;
                boolean buttonChanged = newButtonState != entry.isPressed();
                long buttonLastChangeTime = entry.getButtonLastChangeTime();
                if (buttonChanged) {
                    buttonLastChangeTime = System.currentTimeMillis();
                }
                entry.pressed = newButtonState;
                entry.buttonChanged = buttonChanged;
                entry.buttonLastChangeTime = buttonLastChangeTime;
                entry.update(Float.valueOf(state.currentState()), state.lastChangeTime(), state.changedSinceLastSync(), state.isActive());
                if (listener == null || !entry.buttonChanged) continue;
                listener.accept(entry.getId());
            }
        }
    }

    public SubActionFloatButton getHandSubaction(ControllerType type) {
        return (SubActionFloatButton)super.getHandSubaction(type);
    }

    public float getPressThreshold() {
        return this.pressThreshold;
    }

    public float getReleaseThreshold() {
        return this.releaseThreshold;
    }

    public List<SubActionFloatButton> getSubActionsAsButton() {
        return this.subActionsAsButton;
    }

    public static class SubActionFloatButton
    extends OpenXRMultiAction.SubAction<Float>
    implements VRActionDataButton {
        protected boolean pressed;
        protected boolean buttonChanged;
        protected long buttonLastChangeTime;

        public SubActionFloatButton(String id, String path, Float initialState) {
            super(id, path, initialState);
        }

        public SubActionFloatButton putDefaultBindings(@NotNull List<XRInteractionProfile> profiles, @Nullable String source) {
            return (SubActionFloatButton)super.putDefaultBindings(profiles, source);
        }

        public SubActionFloatButton putDefaultBindings(@NotNull XRInteractionProfile profile, @Nullable String source) {
            return (SubActionFloatButton)super.putDefaultBindings(profile, source);
        }

        @Override
        public boolean isPressed() {
            return this.pressed;
        }

        @Override
        public boolean isButtonChanged() {
            return this.buttonChanged;
        }

        @Override
        public long getButtonLastChangeTime() {
            return this.buttonLastChangeTime;
        }
    }
}

