/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.core.input.action.types.single;

import java.util.function.Consumer;
import me.phoenixra.atumvr.api.input.action.VRActionDataButton;
import me.phoenixra.atumvr.core.OpenXRProvider;
import me.phoenixra.atumvr.core.enums.XRInputActionType;
import me.phoenixra.atumvr.core.input.action.OpenXRActionSet;
import me.phoenixra.atumvr.core.input.action.OpenXRSingleAction;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.openxr.XR10;
import org.lwjgl.openxr.XrActionStateFloat;
import org.lwjgl.system.MemoryStack;

public class FloatButtonAction
extends OpenXRSingleAction<Float>
implements VRActionDataButton {
    private boolean pressed;
    private boolean buttonChanged;
    private long buttonLastChangeTime;
    private final float pressThreshold;
    private final float releaseThreshold;

    public FloatButtonAction(OpenXRProvider provider, OpenXRActionSet actionSet, String id, String localizedName, float pressThreshold, float releaseThreshold) {
        super(provider, actionSet, id, localizedName, XRInputActionType.FLOAT);
        this.currentState = Float.valueOf(0.0f);
        this.pressThreshold = pressThreshold;
        this.releaseThreshold = releaseThreshold;
    }

    @Override
    protected void onInit(OpenXRActionSet actionSet, MemoryStack stack) {
    }

    @Override
    public void update(@Nullable Consumer<String> listener) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            XrActionStateFloat state = XrActionStateFloat.calloc(stack).type(this.actionType.getStateId());
            getInfo.action(this.handle);
            this.provider.checkXRError(XR10.xrGetActionStateFloat(this.provider.getState().getVrSession().getHandle(), getInfo, state), "xrGetActionStateFloat", new String[0]);
            float v = state.currentState();
            boolean newState = this.pressed ? v >= this.releaseThreshold : v >= this.pressThreshold;
            this.buttonChanged = newState != this.pressed;
            this.pressed = newState;
            if (this.buttonChanged) {
                this.buttonLastChangeTime = System.currentTimeMillis();
            }
            this.currentState = Float.valueOf(state.currentState());
            this.changed = state.changedSinceLastSync();
            this.lastChangeTime = state.lastChangeTime();
            this.active = state.isActive();
            if (listener != null && this.buttonChanged) {
                listener.accept(this.id);
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isPressed() {
        return this.pressed;
    }

    @Override
    public boolean isButtonChanged() {
        return this.buttonChanged;
    }

    @Override
    public long getButtonLastChangeTime() {
        return this.buttonLastChangeTime;
    }

    public float getPressThreshold() {
        return this.pressThreshold;
    }

    public float getReleaseThreshold() {
        return this.releaseThreshold;
    }
}

