/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.core.rendering;

import me.phoenixra.atumvr.api.enums.EyeType;
import me.phoenixra.atumvr.api.rendering.VREyeCamera;
import me.phoenixra.atumvr.core.OpenXRProvider;
import me.phoenixra.atumvr.core.input.device.OpenXRDeviceHMD;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.lwjgl.openxr.XrFovf;
import org.lwjgl.openxr.XrPosef;

public class OpenXREyeCamera
implements VREyeCamera {
    private final OpenXRProvider vrProvider;
    protected Matrix4f viewMatrix = new Matrix4f();
    protected Matrix4f projectionMatrix = new Matrix4f();

    public OpenXREyeCamera(OpenXRProvider vrProvider) {
        this.vrProvider = vrProvider;
    }

    public void updateViewMatrix(EyeType eyeType) {
        XrPosef p = this.vrProvider.getInputHandler().getDevice("hmd", OpenXRDeviceHMD.class).getXrView(eyeType).pose();
        Quaternionf q = new Quaternionf(p.orientation().x(), p.orientation().y(), p.orientation().z(), p.orientation().w()).conjugate();
        Vector3f pos = new Vector3f(p.position$().x(), p.position$().y(), p.position$().z());
        this.viewMatrix.identity().rotate((Quaternionfc)q).translate(-pos.x, -pos.y, -pos.z);
    }

    public void updateProjectionMatrix(EyeType eyeType, float nearClip, float farClip) {
        XrFovf fov = this.vrProvider.getInputHandler().getDevice("hmd", OpenXRDeviceHMD.class).getXrView(eyeType).fov();
        this.projectionMatrix = new Matrix4f().setPerspectiveOffCenterFov(fov.angleLeft(), fov.angleRight(), fov.angleDown(), fov.angleUp(), nearClip, farClip);
    }

    @Override
    public Matrix4f getViewMatrix() {
        return this.viewMatrix;
    }

    @Override
    public Matrix4f getProjectionMatrix() {
        return this.projectionMatrix;
    }
}

