/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.core.rendering;

import java.io.PrintStream;
import java.nio.IntBuffer;
import java.util.HashMap;
import me.phoenixra.atumvr.api.enums.EyeType;
import me.phoenixra.atumvr.api.rendering.IRenderContext;
import me.phoenixra.atumvr.api.rendering.VRRenderer;
import me.phoenixra.atumvr.api.rendering.VRTexture;
import me.phoenixra.atumvr.api.utils.GLUtils;
import me.phoenixra.atumvr.core.OpenXRProvider;
import me.phoenixra.atumvr.core.input.device.OpenXRDeviceHMD;
import me.phoenixra.atumvr.core.rendering.OpenXRTexture;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL30;
import org.lwjgl.openxr.KHRVisibilityMask;
import org.lwjgl.openxr.XR10;
import org.lwjgl.openxr.XrCompositionLayerProjection;
import org.lwjgl.openxr.XrCompositionLayerProjectionView;
import org.lwjgl.openxr.XrFrameBeginInfo;
import org.lwjgl.openxr.XrFrameEndInfo;
import org.lwjgl.openxr.XrFrameState;
import org.lwjgl.openxr.XrFrameWaitInfo;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.openxr.XrSwapchain;
import org.lwjgl.openxr.XrSwapchainImageAcquireInfo;
import org.lwjgl.openxr.XrSwapchainImageBaseHeader;
import org.lwjgl.openxr.XrSwapchainImageOpenGLKHR;
import org.lwjgl.openxr.XrSwapchainImageReleaseInfo;
import org.lwjgl.openxr.XrSwapchainImageWaitInfo;
import org.lwjgl.openxr.XrSwapchainSubImage;
import org.lwjgl.openxr.XrVector2f;
import org.lwjgl.openxr.XrView;
import org.lwjgl.openxr.XrViewLocateInfo;
import org.lwjgl.openxr.XrViewState;
import org.lwjgl.openxr.XrVisibilityMaskKHR;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.Pointer;

public abstract class OpenXRRenderer
implements VRRenderer {
    protected OpenXRProvider vrProvider;
    protected int resolutionWidth;
    protected int resolutionHeight;
    protected long windowHandle;
    protected final HashMap<EyeType, float[]> hiddenArea = new HashMap();
    protected int swapIndex;
    protected OpenXRTexture[] leftFramebuffers;
    protected OpenXRTexture[] rightFramebuffers;
    protected XrCompositionLayerProjectionView.Buffer projectionLayerViews;
    private boolean createdGLContext;

    public OpenXRRenderer(OpenXRProvider vrProvider) {
        this.vrProvider = vrProvider;
    }

    public abstract void onInit() throws Throwable;

    protected abstract OpenXRTexture createTexture(int var1, int var2, int var3, int var4);

    @Override
    public void init() throws Throwable {
        this.setupResolution();
        this.setupEyes();
        this.setupHiddenArea();
        this.onInit();
    }

    @Override
    public void preRender(@NotNull IRenderContext context) {
        this.prepareXrFrame();
    }

    @Override
    public void renderFrame(@NotNull IRenderContext context) {
        if (this.createdGLContext) {
            GL30.glViewport((int)0, (int)0, (int)this.resolutionWidth, (int)this.resolutionHeight);
            GL30.glEnable((int)2929);
        }
        this.getCurrentScene().render(context);
        this.finishXrFrame();
        if (this.createdGLContext) {
            GL30.glFlush();
            GL30.glFinish();
        }
    }

    protected void prepareXrFrame() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            XrFrameState frameState = XrFrameState.calloc(stack).type(44);
            this.vrProvider.checkXRError(XR10.xrWaitFrame(this.vrProvider.getState().getVrSession().getHandle(), XrFrameWaitInfo.calloc(stack).type(33), frameState), "xrWaitFrame", "");
            this.vrProvider.setXrDisplayTime(frameState.predictedDisplayTime());
            this.vrProvider.checkXRError(XR10.xrBeginFrame(this.vrProvider.getState().getVrSession().getHandle(), XrFrameBeginInfo.calloc(stack).type(46)), "xrBeginFrame", "");
            XrViewState viewState = XrViewState.calloc(stack).type(11);
            IntBuffer intBuf = stack.callocInt(1);
            XrViewLocateInfo viewLocateInfo = XrViewLocateInfo.calloc(stack);
            viewLocateInfo.set(6, 0L, 2, frameState.predictedDisplayTime(), this.vrProvider.getState().getVrSession().getXrAppSpace());
            this.vrProvider.checkXRError(XR10.xrLocateViews(this.vrProvider.getState().getVrSession().getHandle(), viewLocateInfo, viewState, intBuf, this.vrProvider.getState().getVrSwapChain().getXrViewBuffer()), "xrLocateViews", "");
        }
        XrSwapchain xrSwapchain = this.vrProvider.getState().getVrSwapChain().getHandle();
        this.projectionLayerViews = XrCompositionLayerProjectionView.calloc(2);
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer intBuf2 = stack.callocInt(1);
            this.vrProvider.checkXRError(XR10.xrAcquireSwapchainImage(xrSwapchain, XrSwapchainImageAcquireInfo.calloc(stack).type(55), intBuf2), "xrAcquireSwapchainImage", "");
            this.vrProvider.checkXRError(XR10.xrWaitSwapchainImage(xrSwapchain, XrSwapchainImageWaitInfo.calloc(stack).type(56).timeout(Long.MAX_VALUE)), "xrWaitSwapchainImage", "");
            this.swapIndex = intBuf2.get(0);
            for (EyeType eyeType : EyeType.values()) {
                int index = eyeType.getIndex();
                XrView xrView = this.vrProvider.getInputHandler().getDevice("hmd", OpenXRDeviceHMD.class).getXrView(eyeType);
                XrSwapchainSubImage subImage = ((XrCompositionLayerProjectionView)this.projectionLayerViews.get(index)).type(48).pose(xrView.pose()).fov(xrView.fov()).subImage();
                subImage.swapchain(xrSwapchain);
                subImage.imageRect().offset().set(0, 0);
                subImage.imageRect().extent().set(this.resolutionWidth, this.resolutionHeight);
                subImage.imageArrayIndex(index);
            }
        }
    }

    protected void finishXrFrame() {
        XrSwapchain xrSwapchain = this.vrProvider.getState().getVrSwapChain().getHandle();
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer layers = stack.callocPointer(1);
            int error = XR10.xrReleaseSwapchainImage(xrSwapchain, XrSwapchainImageReleaseInfo.calloc(stack).type(57));
            this.vrProvider.checkXRError(error, "xrReleaseSwapchainImage", "");
            XrCompositionLayerProjection compositionLayerProjection = XrCompositionLayerProjection.calloc(stack).type(35).space(this.vrProvider.getState().getVrSession().getXrAppSpace()).views(this.projectionLayerViews);
            layers.put((Pointer)compositionLayerProjection);
            layers.flip();
            error = XR10.xrEndFrame(this.vrProvider.getState().getVrSession().getHandle(), XrFrameEndInfo.calloc(stack).type(12).displayTime(this.vrProvider.getXrDisplayTime()).environmentBlendMode(1).layers(layers));
            this.vrProvider.checkXRError(error, "xrEndFrame", "");
            this.projectionLayerViews.close();
        }
    }

    public void setupGLContext() {
        this.createdGLContext = true;
        GLFWErrorCallback.createPrint((PrintStream)System.out).set();
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Unable to initialize GLFW");
        }
        GLFW.glfwWindowHint((int)131076, (int)0);
        GLFW.glfwWindowHint((int)135173, (int)24);
        GLFW.glfwWindowHint((int)135174, (int)8);
        this.windowHandle = GLFW.glfwCreateWindow((int)640, (int)480, (CharSequence)this.vrProvider.getAppName(), (long)0L, (long)0L);
        if (this.windowHandle == 0L) {
            throw new RuntimeException("Failed to create the GLFW window");
        }
        GLFW.glfwMakeContextCurrent((long)this.windowHandle);
        GLFW.glfwSwapInterval((int)1);
        GL.createCapabilities();
        GL30.glEnable((int)2929);
        GL30.glEnable((int)2884);
        GL30.glCullFace((int)1029);
    }

    protected void setupResolution() {
        this.resolutionWidth = this.vrProvider.getState().getEyeTexWidth();
        this.resolutionHeight = this.vrProvider.getState().getEyeTexHeight();
    }

    protected void setupEyes() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer intBuffer = stack.ints(0);
            int error = XR10.xrEnumerateSwapchainImages(this.vrProvider.getState().getVrSwapChain().getHandle(), intBuffer, null);
            this.vrProvider.checkXRError(error, "xrEnumerateSwapchainImages", "get count");
            int imageCount = intBuffer.get(0);
            XrSwapchainImageOpenGLKHR.Buffer swapchainImageBuffer = this.vrProvider.getState().getVrSwapChain().createImageBuffers(imageCount, stack);
            error = XR10.xrEnumerateSwapchainImages(this.vrProvider.getState().getVrSwapChain().getHandle(), intBuffer, XrSwapchainImageBaseHeader.create(swapchainImageBuffer.address(), swapchainImageBuffer.capacity()));
            this.vrProvider.checkXRError(error, "xrEnumerateSwapchainImages", "get images");
            this.leftFramebuffers = new OpenXRTexture[imageCount];
            this.rightFramebuffers = new OpenXRTexture[imageCount];
            for (int i = 0; i < imageCount; ++i) {
                XrSwapchainImageOpenGLKHR openxrImage = (XrSwapchainImageOpenGLKHR)swapchainImageBuffer.get(i);
                this.leftFramebuffers[i] = this.createTexture(this.resolutionWidth, this.resolutionHeight, openxrImage.image(), 0).init();
                GLUtils.checkGLError("Left Eye " + i + " framebuffer setup");
                this.rightFramebuffers[i] = this.createTexture(this.resolutionWidth, this.resolutionHeight, openxrImage.image(), 1).init();
                GLUtils.checkGLError("Right Eye " + i + " framebuffer setup");
            }
        }
    }

    protected void setupHiddenArea() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            XrSession xrSession = this.getVrProvider().getState().getVrSession().getHandle();
            for (int eye = 0; eye < 2; ++eye) {
                XrVisibilityMaskKHR mask = XrVisibilityMaskKHR.calloc(stack).type(1000031000).next(0L);
                this.getVrProvider().checkXRError(KHRVisibilityMask.xrGetVisibilityMaskKHR(xrSession, 2, eye, 1, mask), "xrGetVisibilityMaskKHR", "query counts");
                int vertCount = mask.vertexCountOutput();
                int indexCount = mask.indexCountOutput();
                if (indexCount <= 0) {
                    this.getVrProvider().getLogger().logInfo("No hidden-area mesh found for eye " + eye);
                    continue;
                }
                XrVector2f.Buffer verts = XrVector2f.calloc(vertCount, stack);
                IntBuffer idxBuf = stack.mallocInt(indexCount);
                mask.vertexCapacityInput(vertCount).indexCapacityInput(indexCount).vertices(verts).indices(idxBuf);
                this.getVrProvider().checkXRError(KHRVisibilityMask.xrGetVisibilityMaskKHR(xrSession, 2, eye, 1, mask), "xrGetVisibilityMaskKHR", "retrieve mesh");
                float[] area = new float[indexCount * 2];
                for (int i = 0; i < indexCount; ++i) {
                    XrVector2f v = (XrVector2f)verts.get(idxBuf.get(i));
                    float ux = v.x() * 0.5f + 0.5f;
                    float uy = v.y() * 0.5f + 0.5f;
                    area[i * 2] = ux * (float)this.getResolutionWidth();
                    area[i * 2 + 1] = uy * (float)this.getResolutionHeight();
                }
                this.hiddenArea.put(EyeType.asIndex(eye), area);
                System.out.println("Hidden-area mesh loaded for eye " + eye);
            }
        }
    }

    @Override
    public VRTexture getTextureLeftEye() {
        if (this.leftFramebuffers == null) {
            return null;
        }
        return this.leftFramebuffers[this.swapIndex];
    }

    @Override
    public VRTexture getTextureRightEye() {
        if (this.rightFramebuffers == null) {
            return null;
        }
        return this.rightFramebuffers[this.swapIndex];
    }

    @Override
    public float[] getHiddenAreaVertices(EyeType eyeType) {
        return this.hiddenArea.get((Object)eyeType);
    }

    public void reinitBuffers() {
    }

    @Override
    public void destroy() {
        this.getCurrentScene().destroy();
        if (this.createdGLContext) {
            Callbacks.glfwFreeCallbacks((long)this.windowHandle);
            GLFW.glfwDestroyWindow((long)this.windowHandle);
            GLFW.glfwTerminate();
        }
    }

    @Override
    public OpenXRProvider getVrProvider() {
        return this.vrProvider;
    }

    @Override
    public int getResolutionWidth() {
        return this.resolutionWidth;
    }

    @Override
    public int getResolutionHeight() {
        return this.resolutionHeight;
    }

    @Override
    public long getWindowHandle() {
        return this.windowHandle;
    }
}

