/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.core.rendering;

import me.phoenixra.atumvr.api.rendering.VRTexture;
import org.lwjgl.opengl.GL30;

public class OpenXRTexture
implements VRTexture {
    protected final int textureId;
    protected int textureIndex;
    protected int frameBufferId;
    protected final int width;
    protected final int height;

    public OpenXRTexture(int width, int height, int textureId, int index) {
        this.width = width;
        this.height = height;
        this.textureId = textureId;
        this.textureIndex = index;
    }

    public OpenXRTexture init() {
        this.frameBufferId = GL30.glGenFramebuffers();
        GL30.glBindFramebuffer((int)36160, (int)this.frameBufferId);
        GL30.glFramebufferTextureLayer((int)36160, (int)36064, (int)this.textureId, (int)0, (int)this.textureIndex);
        this.checkStatus();
        GL30.glBindFramebuffer((int)36160, (int)0);
        GL30.glBindTexture((int)3553, (int)0);
        return this;
    }

    private void checkStatus() {
        int i = GL30.glCheckFramebufferStatus((int)36160);
        if (i != 36053) {
            if (i == 36054) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT");
            }
            if (i == 36055) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT");
            }
            if (i == 36059) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER");
            }
            if (i == 36060) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER");
            }
            if (i == 36061) {
                throw new RuntimeException("GL_FRAMEBUFFER_UNSUPPORTED");
            }
            if (i == 1285) {
                throw new RuntimeException("GL_OUT_OF_MEMORY");
            }
            throw new RuntimeException("glCheckFramebufferStatus returned unknown status:" + i);
        }
    }

    @Override
    public void destroy() {
        GL30.glDeleteTextures((int)this.textureId);
        GL30.glDeleteFramebuffers((int)this.frameBufferId);
    }

    @Override
    public int getTextureId() {
        return this.textureId;
    }

    public int getTextureIndex() {
        return this.textureIndex;
    }

    @Override
    public int getFrameBufferId() {
        return this.frameBufferId;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

