/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.libs.redempt.crunch.functional;

import java.util.Locale;
import java.util.function.DoubleSupplier;
import java.util.function.ToDoubleFunction;
import me.phoenixra.libs.redempt.crunch.Variable;
import me.phoenixra.libs.redempt.crunch.data.CharTree;
import me.phoenixra.libs.redempt.crunch.functional.Function;
import me.phoenixra.libs.redempt.crunch.token.BinaryOperator;
import me.phoenixra.libs.redempt.crunch.token.Constant;
import me.phoenixra.libs.redempt.crunch.token.LazyVariable;
import me.phoenixra.libs.redempt.crunch.token.Token;
import me.phoenixra.libs.redempt.crunch.token.UnaryOperator;
import me.phoenixra.libs.redempt.crunch.token.Value;

public class ExpressionEnv {
    private final CharTree<BinaryOperator> binaryOperators = new CharTree();
    private final CharTree<Token> leadingOperators = new CharTree();
    private final CharTree<Value> values = new CharTree();
    private int varCount = 0;

    public ExpressionEnv() {
        for (BinaryOperator binaryOperator : BinaryOperator.values()) {
            this.binaryOperators.set(binaryOperator.getSymbol(), binaryOperator);
        }
        for (Enum enum_ : UnaryOperator.values()) {
            this.leadingOperators.set(((UnaryOperator)enum_).getSymbol(), (Token)((Object)enum_));
        }
        for (Enum enum_ : Constant.values()) {
            this.values.set(((Constant)enum_).toString().toLowerCase(Locale.ROOT), (Value)((Object)enum_));
        }
    }

    private void checkName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Identifier cannot be empty or null");
        }
        if (!Character.isAlphabetic(name.charAt(0))) {
            throw new IllegalArgumentException("Identifier must begin with an alphabetic character");
        }
    }

    public ExpressionEnv addFunction(Function function) {
        if (function == null) {
            throw new IllegalArgumentException("Function cannot be null");
        }
        String name = function.getName();
        this.checkName(name);
        this.leadingOperators.set(name, function);
        return this;
    }

    public ExpressionEnv addFunctions(Function ... functions) {
        if (functions == null) {
            throw new IllegalArgumentException("Functions cannot be null");
        }
        for (Function function : functions) {
            this.addFunction(function);
        }
        return this;
    }

    public ExpressionEnv addLazyVariable(String name, DoubleSupplier supply) {
        if (supply == null) {
            throw new IllegalArgumentException("Supply cannot be null");
        }
        this.checkName(name);
        this.values.set(name, new LazyVariable(name, supply));
        return this;
    }

    public ExpressionEnv setVariableNames(String ... names) {
        if (names == null) {
            throw new IllegalArgumentException("Names cannot be null");
        }
        this.varCount = names.length;
        for (int i = 0; i < names.length; ++i) {
            this.checkName(names[i]);
            this.values.set(names[i], new Variable(i));
        }
        return this;
    }

    public ExpressionEnv addFunction(String name, int argCount, ToDoubleFunction<double[]> func) {
        this.addFunction(new Function(name, argCount, func));
        return this;
    }

    public CharTree<Token> getLeadingOperators() {
        return this.leadingOperators;
    }

    public CharTree<BinaryOperator> getBinaryOperators() {
        return this.binaryOperators;
    }

    public CharTree<Value> getValues() {
        return this.values;
    }

    public int getVariableCount() {
        return this.varCount;
    }
}

