/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class GuiTexture {
    @NotNull
    private final ResourceLocation resourceLocation;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final int textureWidth;
    private final int textureHeight;
    @NotNull
    private final DrawMode drawMode;

    public GuiTexture(@NotNull ResourceLocation resourceLocation) {
        this.resourceLocation = resourceLocation;
        this.x = 0;
        this.y = 0;
        this.width = 1;
        this.height = 1;
        this.textureWidth = 1;
        this.textureHeight = 1;
        this.drawMode = DrawMode.STRETCH;
    }

    public GuiTexture(@NotNull ResourceLocation resourceLocation, int x, int y, int width, int height) {
        this.resourceLocation = resourceLocation;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.textureWidth = width;
        this.textureHeight = height;
        this.drawMode = DrawMode.TILE;
    }

    public GuiTexture(@NotNull ResourceLocation resourceLocation, int x, int y, int width, int height, int textureWidth, int textureHeight) {
        this.resourceLocation = resourceLocation;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.drawMode = DrawMode.STRETCH;
    }

    public void blit(GuiGraphics gui, int xPos, int yPos, int targetWidth, int targetHeight) {
        if (this.drawMode == DrawMode.STRETCH) {
            gui.m_280411_(this.resourceLocation, xPos, yPos, targetWidth, targetHeight, (float)this.x, (float)this.y, this.width, this.height, this.textureWidth, this.textureHeight);
        } else {
            gui.m_280163_(this.resourceLocation, xPos, yPos, (float)this.x, (float)this.y, targetWidth, targetHeight, this.width, this.height);
        }
    }

    public static GuiTexture of(@NotNull ResourceLocation location) {
        return new GuiTexture(location);
    }

    @NotNull
    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTextureWidth() {
        return this.textureWidth;
    }

    public int getTextureHeight() {
        return this.textureHeight;
    }

    @NotNull
    public DrawMode getDrawMode() {
        return this.drawMode;
    }

    public static enum DrawMode {
        STRETCH,
        TILE;

    }
}

