/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.overlays;

import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.client.data.PoseData;
import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.gui.overlays.VROverlay;
import me.phoenixra.visor.api.common.utils.VRMathUtils;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VROverlayPose {
    public static final float QUAD_SCALE = 1.5f;
    private final VROverlay owner;
    private Vector3fc position = new Vector3f(0.0f, 0.0f, 0.0f);
    private Matrix4fc rotation = new Matrix4f();
    private float scale;
    private final Vector3f rightDir = new Vector3f();
    private final Vector3f upDir = new Vector3f();
    private float halfWidth;
    private float halfHeight;

    public VROverlayPose(@NotNull VROverlay owner, float overlayScale) {
        this.owner = owner;
        this.scale = overlayScale;
    }

    public void update(@NotNull Vector3fc position, @NotNull Matrix4fc rotation, float overlayScale) {
        this.position = position;
        this.rotation = rotation;
        this.scale = overlayScale;
        PoseData renderPose = VisorAPI.client().getPlayer().getPoseData(PoseDataType.RENDER);
        float worldScale = renderPose.getWorldScale();
        float effectiveScale = 1.5f * this.scale * worldScale;
        float aspect = this.owner.getAspectRatio();
        this.halfWidth = effectiveScale * 0.5f;
        this.halfHeight = effectiveScale * aspect * 0.5f;
        this.rightDir.set((Vector3fc)VRMathUtils.extractRightDir(rotation, true));
        this.upDir.set((Vector3fc)VRMathUtils.extractUpDir(rotation, true));
    }

    public void updateOnlyPosAndRotation(@NotNull Vector3fc position, @NotNull Matrix4fc rotation) {
        this.update(position, rotation, this.scale);
    }

    public void updateOnlyPosition(@NotNull Vector3fc position) {
        this.update(position, this.rotation, this.scale);
    }

    public void updateOnlyRotation(@NotNull Matrix4fc rotation) {
        this.update(this.position, rotation, this.scale);
    }

    public void updateOnlyScale(float overlayScale) {
        this.update(this.position, this.rotation, overlayScale);
    }

    public Vector3f getPositionAt(float xNorm, float yNorm, boolean useCursorBounds, @NotNull PoseDataType returnType) {
        if (useCursorBounds) {
            int w = this.owner.getWidth();
            int h = this.owner.getHeight();
            int edgeX = this.owner.getCursorBoundsX();
            int edgeY = this.owner.getCursorBoundsY();
            int edgeW = this.owner.getCursorBoundsWidth();
            int edgeH = this.owner.getCursorBoundsHeight();
            if (w > 0 && h > 0 && edgeX >= 0 && edgeY >= 0 && edgeW > 0 && edgeH > 0) {
                float localX = (xNorm + 1.0f) * 0.5f;
                float localY = (yNorm + 1.0f) * 0.5f;
                float pixelX = (float)edgeX + localX * (float)edgeW;
                float pixelY = (float)edgeY + (1.0f - localY) * (float)edgeH;
                xNorm = pixelX / (float)w * 2.0f - 1.0f;
                yNorm = 1.0f - pixelY / (float)h * 2.0f;
            }
        }
        Vector3f pointInRender = new Vector3f(this.position).add((Vector3fc)new Vector3f((Vector3fc)this.rightDir).mul(this.halfWidth * xNorm, new Vector3f())).add((Vector3fc)new Vector3f((Vector3fc)this.upDir).mul(this.halfHeight * yNorm, new Vector3f()));
        PoseData targetPose = VisorAPI.client().getPlayer().getPoseData(returnType);
        return targetPose.convertPositionFrom(PoseDataType.RENDER, (Vector3fc)pointInRender);
    }

    public Vector3f getPositionAt(float xNorm, float yNorm, int[] customBounds, @NotNull PoseDataType returnType) {
        if (customBounds != null) {
            int w = this.owner.getWidth();
            int h = this.owner.getHeight();
            int edgeX = customBounds[0];
            int edgeY = customBounds[1];
            int edgeW = customBounds[2];
            int edgeH = customBounds[3];
            if (w > 0 && h > 0 && edgeX >= 0 && edgeY >= 0 && edgeW > 0 && edgeH > 0) {
                float localX = (xNorm + 1.0f) * 0.5f;
                float localY = (yNorm + 1.0f) * 0.5f;
                float pixelX = (float)edgeX + localX * (float)edgeW;
                float pixelY = (float)edgeY + (1.0f - localY) * (float)edgeH;
                xNorm = pixelX / (float)w * 2.0f - 1.0f;
                yNorm = 1.0f - pixelY / (float)h * 2.0f;
            }
        }
        Vector3f pointInRender = new Vector3f(this.position).add((Vector3fc)new Vector3f((Vector3fc)this.rightDir).mul(this.halfWidth * xNorm, new Vector3f())).add((Vector3fc)new Vector3f((Vector3fc)this.upDir).mul(this.halfHeight * yNorm, new Vector3f()));
        PoseData targetPose = VisorAPI.client().getPlayer().getPoseData(returnType);
        return targetPose.convertPositionFrom(PoseDataType.RENDER, (Vector3fc)pointInRender);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VROverlayPose)) {
            return false;
        }
        VROverlayPose other = (VROverlayPose)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getScale(), other.getScale()) != 0) {
            return false;
        }
        if (Float.compare(this.getHalfWidth(), other.getHalfWidth()) != 0) {
            return false;
        }
        if (Float.compare(this.getHalfHeight(), other.getHalfHeight()) != 0) {
            return false;
        }
        VROverlay this$owner = this.getOwner();
        VROverlay other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        Vector3fc this$position = this.getPosition();
        Vector3fc other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        Matrix4fc this$rotation = this.getRotation();
        Matrix4fc other$rotation = other.getRotation();
        if (this$rotation == null ? other$rotation != null : !this$rotation.equals(other$rotation)) {
            return false;
        }
        Vector3f this$rightDir = this.rightDir;
        Vector3f other$rightDir = other.rightDir;
        if (this$rightDir == null ? other$rightDir != null : !this$rightDir.equals(other$rightDir)) {
            return false;
        }
        Vector3f this$upDir = this.upDir;
        Vector3f other$upDir = other.upDir;
        return !(this$upDir == null ? other$upDir != null : !this$upDir.equals(other$upDir));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VROverlayPose;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getScale());
        result = result * 59 + Float.floatToIntBits(this.getHalfWidth());
        result = result * 59 + Float.floatToIntBits(this.getHalfHeight());
        VROverlay $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        Vector3fc $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        Matrix4fc $rotation = this.getRotation();
        result = result * 59 + ($rotation == null ? 43 : $rotation.hashCode());
        Vector3f $rightDir = this.rightDir;
        result = result * 59 + ($rightDir == null ? 43 : $rightDir.hashCode());
        Vector3f $upDir = this.upDir;
        result = result * 59 + ($upDir == null ? 43 : $upDir.hashCode());
        return result;
    }

    public String toString() {
        return "VROverlayPose(owner=" + String.valueOf(this.getOwner()) + ", position=" + String.valueOf(this.getPosition()) + ", rotation=" + String.valueOf(this.getRotation()) + ", scale=" + this.getScale() + ", rightDir=" + String.valueOf(this.rightDir) + ", upDir=" + String.valueOf(this.upDir) + ", halfWidth=" + this.getHalfWidth() + ", halfHeight=" + this.getHalfHeight() + ")";
    }

    public VROverlay getOwner() {
        return this.owner;
    }

    public Vector3fc getPosition() {
        return this.position;
    }

    public Matrix4fc getRotation() {
        return this.rotation;
    }

    public float getScale() {
        return this.scale;
    }

    public float getHalfWidth() {
        return this.halfWidth;
    }

    public float getHalfHeight() {
        return this.halfHeight;
    }
}

