/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.overlays.framework;

import com.mojang.blaze3d.pipeline.RenderTarget;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.phoenixra.atumconfig.api.config.ConfigFile;
import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.client.data.PoseAnchor;
import me.phoenixra.visor.api.client.gui.overlays.VROverlay;
import me.phoenixra.visor.api.client.gui.overlays.VROverlayCursorData;
import me.phoenixra.visor.api.client.gui.overlays.VROverlayHelper;
import me.phoenixra.visor.api.client.gui.overlays.VROverlayPose;
import me.phoenixra.visor.api.client.gui.overlays.options.OverlayOptionGroup;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.addon.element.ElementPriority;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class VROverlayFrameBuffer
implements VROverlay {
    @NotNull
    private final String id;
    @NotNull
    private final VisorAddon owner;
    private final ElementPriority priority;
    private final VROverlayPose pose;
    @Nullable
    private PoseAnchor forcedAnchor;
    protected RenderTarget renderTarget;
    protected final Map<String, OverlayOptionGroup<?>> optionsMap;
    @NotNull
    private final Collection<OverlayOptionGroup<?>> options;
    protected final ConfigFile optionsConfig;
    protected final VROverlayCursorData activeCursorData = new VROverlayCursorData();
    protected final VROverlayCursorData inactiveCursorData = new VROverlayCursorData();
    private boolean enabled = false;
    private boolean visible = false;

    public VROverlayFrameBuffer(@NotNull VisorAddon owner, @NotNull String id) {
        this(owner, id, ElementPriority.NORMAL, null, 1.0f);
    }

    public VROverlayFrameBuffer(@NotNull VisorAddon owner, @NotNull String id, @NotNull ElementPriority priority, @Nullable RenderTarget renderTarget, float overlayScale) {
        Objects.requireNonNull(owner);
        Objects.requireNonNull(id);
        Objects.requireNonNull(priority);
        if (overlayScale <= 0.0f) {
            throw new RuntimeException("overlayScale cannot be less or equal '0'");
        }
        this.owner = owner;
        this.id = id;
        this.renderTarget = renderTarget;
        this.priority = priority;
        this.pose = new VROverlayPose(this, overlayScale);
        this.optionsMap = new LinkedHashMap();
        List<OverlayOptionGroup<?>> preOptions = this.createOptions();
        preOptions.forEach(it -> this.optionsMap.put(it.getId(), (OverlayOptionGroup<?>)it));
        this.options = Collections.unmodifiableCollection(this.optionsMap.values());
        if (!this.optionsMap.isEmpty()) {
            try {
                this.optionsConfig = VisorAPI.client().getGuiManager().getOverlayManager().getOverlayConfigAccessor().getConfigOrCreate(this);
                this.initOptions();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.optionsConfig = null;
        }
    }

    protected void onPreTick() {
    }

    protected void onTick() {
    }

    protected void onPreRender(float partialTicks) {
    }

    protected void onRender(float partialTicks) {
    }

    protected abstract void onUpdatePose(float var1);

    protected abstract boolean updateVisibility();

    protected void onEnable() {
    }

    protected void onDisable() {
    }

    @NotNull
    protected List<OverlayOptionGroup<?>> createOptions() {
        return List.of();
    }

    protected void initOptions() {
        for (OverlayOptionGroup<?> option : this.options) {
            option.init();
        }
    }

    @Override
    public final void m_86600_() {
        this.onPreTick();
        this.visible = this.enabled && this.updateVisibility() && this.renderTarget != null;
        this.onTick();
    }

    public void render(float partialTick) {
        if (this.supportsVisibilityUpdateOnRender()) {
            boolean bl = this.visible = this.enabled && this.updateVisibility() && this.renderTarget != null;
            if (!this.visible) {
                return;
            }
        }
        this.onPreRender(partialTick);
        this.onRender(partialTick);
    }

    @Override
    public final void updatePose(float partialTicks) {
        if (this.forcedAnchor != null) {
            VROverlayHelper.applyPose(this, this.forcedAnchor, this.forcedAnchor, this.getPose().getScale(), false, (Vector3fc)new Vector3f(0.0f, 0.0f, -0.3f), (Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f));
            return;
        }
        this.onUpdatePose(partialTicks);
    }

    @Override
    public void setEnabled(boolean flag) {
        if (flag == this.enabled) {
            return;
        }
        this.enabled = flag;
        if (this.enabled) {
            this.onEnable();
        } else {
            this.visible = false;
            this.onDisable();
        }
    }

    @Override
    @Nullable
    public OverlayOptionGroup<?> getOption(@NotNull String id) {
        return this.optionsMap.get(id);
    }

    @Override
    public boolean supportsCursor() {
        return false;
    }

    @Override
    public int getWidth() {
        return this.renderTarget != null ? this.renderTarget.f_83915_ : 1;
    }

    @Override
    public int getHeight() {
        return this.renderTarget != null ? this.renderTarget.f_83916_ : 1;
    }

    @Override
    public void updateCursorData(boolean activeCursor, float rawX, float rawY) {
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int buttonType) {
        return false;
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int buttonType) {
        return false;
    }

    @Override
    public void m_94757_(double mouseX, double mouseY) {
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int buttonType, double deltaX, double deltaY) {
        return false;
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        return false;
    }

    @Override
    public boolean m_7920_(int keyCode, int keyScan, int modifiers) {
        return false;
    }

    @Override
    public boolean m_5534_(char chr, int modifiers) {
        return false;
    }

    @Override
    public boolean m_7933_(int keyCode, int keyScan, int modifiers) {
        return false;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public VisorAddon getOwner() {
        return this.owner;
    }

    @Override
    public ElementPriority getPriority() {
        return this.priority;
    }

    @Override
    public VROverlayPose getPose() {
        return this.pose;
    }

    @Override
    @Nullable
    public PoseAnchor getForcedAnchor() {
        return this.forcedAnchor;
    }

    @Override
    public void setForcedAnchor(@Nullable PoseAnchor forcedAnchor) {
        this.forcedAnchor = forcedAnchor;
    }

    @Override
    public RenderTarget getRenderTarget() {
        return this.renderTarget;
    }

    @Override
    @NotNull
    public Collection<OverlayOptionGroup<?>> getOptions() {
        return this.options;
    }

    @Override
    public ConfigFile getOptionsConfig() {
        return this.optionsConfig;
    }

    @Override
    public VROverlayCursorData getActiveCursorData() {
        return this.activeCursorData;
    }

    @Override
    public VROverlayCursorData getInactiveCursorData() {
        return this.inactiveCursorData;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }
}

