/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.overlays.framework.screen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.gui.overlays.framework.VROverlayScreen;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.addon.element.ElementPriority;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2f;

public abstract class VROverlayRadialSelector
extends VROverlayScreen {
    protected final int radialMenuSize;
    protected ControllerHand usedHand;
    protected HashMap<Integer, SelectionBox> selectionBoxes;
    protected List<Integer> disabledBoxes;
    private int selectedSlice = -1;

    protected VROverlayRadialSelector(@NotNull VisorAddon owner, @NotNull ControllerHand hand, @NotNull String id, @NotNull ElementPriority priority, int radialMenuSize, SelectionBox ... selectionBoxes) {
        super(owner, id, priority, 1.0f);
        this.usedHand = hand;
        this.radialMenuSize = radialMenuSize;
        this.selectionBoxes = new HashMap();
        for (SelectionBox box : selectionBoxes) {
            this.selectionBoxes.put(box.id, box);
        }
        this.disabledBoxes = new ArrayList<Integer>();
    }

    protected abstract void renderRadialImage(GuiGraphics var1, float var2, int var3, int var4, int var5, int var6);

    @Override
    public void onPreRender(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
        int specialMouseY;
        int specialMouseX;
        int selectedSliceNew;
        boolean cursorValid;
        Vector2f cursor = VisorAPI.client().getGuiManager().getCursorHandler().findCursorPosition2D(VisorAPI.client().getPlayer().getPoseData(PoseDataType.RENDER).getController(this.usedHand), this.getPose().getPosition(), this.getPose().getRotation(), this.getPose().getScale(), this.getAspectRatio());
        if (cursor.x == -1.0f && cursor.y == -1.0f) {
            cursorValid = false;
        } else {
            cursorValid = true;
            this.updateCursorData(true, cursor.x, cursor.y);
        }
        if (cursorValid && (selectedSliceNew = this.getSliceFromPos(new Vector2f((float)(specialMouseX = (int)(((double)this.getRawMouseX() - 0.5) * (double)this.f_96543_)), (float)(specialMouseY = (int)(((double)this.getRawMouseY() - 0.5) * (double)this.f_96544_))))) != -1 && selectedSliceNew != this.selectedSlice) {
            VisorAPI.client().getInputManager().triggerHapticPulse(this.usedHand, 0.0015f);
            this.selectedSlice = selectedSliceNew;
        }
    }

    @Override
    public void onRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float pPartialTicks) {
        int startX = guiGraphics.m_280182_() / 2 - this.radialMenuSize / 2;
        int startY = guiGraphics.m_280206_() / 2 - this.radialMenuSize / 2;
        this.renderRadialImage(guiGraphics, pPartialTicks, this.selectedSlice, startX, startY, this.radialMenuSize);
    }

    private int getSliceFromPos(Vector2f mousePosition) {
        for (SelectionBox selectionBox : this.selectionBoxes.values()) {
            if (!selectionBox.isInBox((int)mousePosition.x, (int)mousePosition.y)) continue;
            if (this.disabledBoxes.contains(selectionBox.id)) {
                return -1;
            }
            return selectionBox.getId();
        }
        return -1;
    }

    @Override
    public boolean supportsCursor() {
        return false;
    }

    public ControllerHand getUsedHand() {
        return this.usedHand;
    }

    public List<Integer> getDisabledBoxes() {
        return this.disabledBoxes;
    }

    public int getSelectedSlice() {
        return this.selectedSlice;
    }

    public void setSelectedSlice(int selectedSlice) {
        this.selectedSlice = selectedSlice;
    }

    public static abstract class SelectionBox {
        private final int id;

        public SelectionBox(int id) {
            this.id = id;
        }

        public abstract boolean isInBox(int var1, int var2);

        public int getId() {
            return this.id;
        }
    }
}

