/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.overlays.framework.template;

import com.mojang.blaze3d.pipeline.RenderTarget;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.phoenixra.visor.api.client.gui.GuiTexture;
import me.phoenixra.visor.api.client.gui.overlays.RegisterVROverlayTemplate;
import me.phoenixra.visor.api.client.gui.overlays.VROverlay;
import me.phoenixra.visor.api.client.gui.overlays.VROverlayHelper;
import me.phoenixra.visor.api.client.gui.overlays.VROverlayTemplate;
import me.phoenixra.visor.api.client.gui.overlays.framework.VROverlayFrameBuffer;
import me.phoenixra.visor.api.client.gui.overlays.options.OverlayOptionGroup;
import me.phoenixra.visor.api.client.gui.overlays.options.types.OverlayOptionsIdentity;
import me.phoenixra.visor.api.client.gui.overlays.options.types.OverlayOptionsMisc;
import me.phoenixra.visor.api.client.gui.overlays.options.types.OverlayOptionsPose;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.addon.element.ElementPriority;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3fc;

public abstract class VROverlayTemplateFrameBuffer
extends VROverlayFrameBuffer
implements VROverlayTemplate {
    private final String templateId;
    private final Component templateName;
    private final Component templateDescription;
    private Component name;
    private Component description;
    private GuiTexture icon;
    protected final OverlayOptionsIdentity optionsIdentity;
    protected final OverlayOptionsMisc optionsMisc;
    protected final OverlayOptionsPose optionsPose;
    protected boolean initializedPose;

    public VROverlayTemplateFrameBuffer(@NotNull VisorAddon owner, @NotNull String id) {
        this(owner, id, ElementPriority.NORMAL, null, 1.0f);
    }

    public VROverlayTemplateFrameBuffer(@NotNull VisorAddon owner, @NotNull String id, @NotNull ElementPriority priority, @Nullable RenderTarget renderTarget, float overlayScale) {
        super(owner, id, priority, renderTarget, overlayScale);
        RegisterVROverlayTemplate annotation = this.getClass().getAnnotation(RegisterVROverlayTemplate.class);
        this.templateId = annotation.id();
        this.templateName = Component.m_237115_((String)annotation.name());
        this.templateDescription = Component.m_237115_((String)annotation.description());
        if (this.getOptions().isEmpty()) {
            throw new IllegalArgumentException("Tried to instantiate an overlay template '%s' with NO OPTIONS".formatted(this.templateId));
        }
        this.optionsIdentity = this.getOption("identity", OverlayOptionsIdentity.class);
        this.optionsMisc = this.getOption("misc", OverlayOptionsMisc.class);
        this.optionsPose = this.getOption("pose", OverlayOptionsPose.class);
        Objects.requireNonNull(this.optionsIdentity);
        this.updateIdentity();
    }

    @NotNull
    protected abstract List<OverlayOptionGroup<?>> createTemplateOptions();

    @Override
    @NotNull
    protected final List<OverlayOptionGroup<?>> createOptions() {
        ArrayList options = new ArrayList();
        options.add(new OverlayOptionsIdentity((VROverlay)this, it -> {
            ResourceLocation defIcon = VisorAddon.MISSING_ICON.getResourceLocation();
            it.setName(this.getId());
            it.setDescription("No description");
            it.setIcon(defIcon.m_135827_() + ":" + defIcon.m_135815_());
        }));
        options.addAll(this.createTemplateOptions());
        return options;
    }

    @Override
    protected final void initOptions() {
        RegisterVROverlayTemplate annotation = this.getClass().getAnnotation(RegisterVROverlayTemplate.class);
        this.optionsConfig.set("template", annotation.id());
        super.initOptions();
    }

    @Override
    protected void onPreTick() {
        if (this.optionsMisc != null && this.optionsMisc.getOptionsUpdaterType() == OverlayOptionsMisc.OptionsUpdaterType.TICK) {
            this.optionsMap.forEach((key, value) -> value.update(false));
        }
        if (this.optionsPose != null && this.optionsPose.isTickPose()) {
            this.updatePose(1.0f);
        }
    }

    @Override
    protected void onPreRender(float partialTicks) {
        if (this.optionsMisc != null && this.optionsMisc.getOptionsUpdaterType() == OverlayOptionsMisc.OptionsUpdaterType.FRAME) {
            this.optionsMap.forEach((key, value) -> value.update(false));
        }
    }

    @Override
    public void onUpdatePose(float partialTicks) {
        if (this.optionsPose == null) {
            return;
        }
        if (!this.initializedPose || this.optionsPose.isTickPose()) {
            VROverlayHelper.applyPose(this, this.optionsPose.getPositionAnchor(), this.optionsPose.getRotationAnchor(), this.optionsPose.getScale(), this.optionsPose.isAimedRotation(), (Vector3fc)this.optionsPose.getPositionOffset(), (Vector3fc)this.optionsPose.getRotationOffset());
            this.initializedPose = true;
        }
    }

    @Override
    public void updateIdentity() {
        if (this.optionsIdentity == null) {
            return;
        }
        this.name = this.optionsIdentity.getName();
        this.description = this.optionsIdentity.getDescription();
        this.icon = this.optionsIdentity.getIcon();
    }

    @Override
    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        if (!flag) {
            this.initializedPose = false;
        }
    }

    @Override
    public final String getTemplateId() {
        return this.templateId;
    }

    @Override
    public final Component getTemplateName() {
        return this.templateName;
    }

    @Override
    public final Component getTemplateDescription() {
        return this.templateDescription;
    }

    @Override
    public final Component getName() {
        return this.name;
    }

    public final void setName(Component name) {
        this.name = name;
    }

    @Override
    public final Component getDescription() {
        return this.description;
    }

    public final void setDescription(Component description) {
        this.description = description;
    }

    @Override
    public final GuiTexture getIcon() {
        return this.icon;
    }

    public final void setIcon(GuiTexture icon) {
        this.icon = icon;
    }
}

