/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.overlays.options;

import me.phoenixra.visor.api.client.gui.GuiTexture;
import me.phoenixra.visor.api.client.gui.overlays.options.OptionTextures;
import me.phoenixra.visor.api.client.gui.overlays.options.OverlayOptionGroup;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public abstract class OptionsScreen<T extends OverlayOptionGroup<?>>
extends Screen {
    protected final T optionsGroup;
    protected Background background;
    protected int cursorBoundsX = -1;
    protected int cursorBoundsY = -1;
    protected int cursorBoundsWidth = -1;
    protected int cursorBoundsHeight = -1;

    protected OptionsScreen(@NotNull T optionsGroup, @NotNull Background background) {
        super((Component)Component.m_237119_());
        this.optionsGroup = optionsGroup;
        this.background = background;
    }

    protected abstract void onInit();

    protected abstract void onRender(GuiGraphics var1, int var2, int var3, float var4);

    protected void m_7856_() {
        if (this.background != Background.EMPTY) {
            this.cursorBoundsX = (this.f_96543_ - this.background.texture.getWidth()) / 2;
            this.cursorBoundsY = (this.f_96544_ - this.background.texture.getHeight()) / 2;
            this.cursorBoundsWidth = this.background.texture.getWidth();
            this.cursorBoundsHeight = this.background.texture.getHeight();
        }
        this.m_169413_();
        this.onInit();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.background != Background.EMPTY) {
            this.background.render(guiGraphics, this.cursorBoundsX, this.cursorBoundsY);
        }
        this.onRender(guiGraphics, mouseX, mouseY, partialTick);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public T getOptionsGroup() {
        return this.optionsGroup;
    }

    public Background getBackground() {
        return this.background;
    }

    public int getCursorBoundsX() {
        return this.cursorBoundsX;
    }

    public int getCursorBoundsY() {
        return this.cursorBoundsY;
    }

    public int getCursorBoundsWidth() {
        return this.cursorBoundsWidth;
    }

    public int getCursorBoundsHeight() {
        return this.cursorBoundsHeight;
    }

    protected static enum Background {
        FULL(OptionTextures.BACKGROUND_256x256),
        HORIZONTAL(OptionTextures.BACKGROUND_256x128),
        VERTICAL(OptionTextures.BACKGROUND_128x256),
        VERTICAL_WIDER(OptionTextures.BACKGROUND_175x256),
        EMPTY(null);

        private final GuiTexture texture;

        private Background(GuiTexture texture) {
            this.texture = texture;
        }

        public void render(GuiGraphics guiGraphics, int x, int y) {
            if (this.texture == null) {
                return;
            }
            this.texture.blit(guiGraphics, x, y, this.texture.getWidth(), this.texture.getHeight());
        }

        public GuiTexture getTexture() {
            return this.texture;
        }
    }
}

