/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.overlays.options.types;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.phoenixra.atumconfig.api.config.Config;
import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.client.gui.overlays.VROverlay;
import me.phoenixra.visor.api.client.gui.overlays.options.OptionsScreen;
import me.phoenixra.visor.api.client.gui.overlays.options.OverlayOptionGroup;
import me.phoenixra.visor.api.client.gui.overlays.options.types.properties.Property;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverlayOptionsGeneral
extends OverlayOptionGroup<OverlayOptionsGeneral> {
    public static final String ID = "general";
    private static final Component NAME = Component.m_237115_((String)"visor.overlay.options.general");
    private final Map<String, Property<?>> propertyMap = new LinkedHashMap();
    private final Collection<Property<?>> propertyList;

    public OverlayOptionsGeneral(@NotNull VROverlay owner, @NotNull List<Property<?>> properties) {
        super(owner, (T it) -> it.propertyMap.forEach((key, property) -> property.loadDefault()));
        Runnable responder = () -> {
            this.changesNotSaved = true;
        };
        for (Property<?> property : properties) {
            this.propertyMap.put(property.getKey(), property);
            property.setResponder(responder);
        }
        this.propertyList = Collections.unmodifiableCollection(this.propertyMap.values());
    }

    @Override
    public void update(boolean reset) {
        for (Map.Entry<String, Property<?>> entry : this.propertyMap.entrySet()) {
            entry.getValue().update();
        }
    }

    @Override
    protected void onLoad(@NotNull Config config) {
        for (Map.Entry<String, Property<?>> entry : this.propertyMap.entrySet()) {
            entry.getValue().onLoad(config);
        }
    }

    @Override
    public void onSave(@NotNull Config config) {
        for (Map.Entry<String, Property<?>> entry : this.propertyMap.entrySet()) {
            entry.getValue().onSave(config);
        }
    }

    @Override
    public boolean supportsCopying() {
        return false;
    }

    @Nullable
    public <T extends Property<?>> T getProperty(String id, Class<T> type) {
        Property<?> p = this.propertyMap.get(id);
        if (p == null) {
            return null;
        }
        if (!type.isInstance(p)) {
            throw new IllegalArgumentException("Property '" + id + "' is " + p.getClass().getSimpleName() + " but " + type.getSimpleName() + " was requested");
        }
        return (T)((Property)type.cast(p));
    }

    @Override
    @NotNull
    public OptionsScreen<?> getScreen() {
        return VisorAPI.client().getGuiManager().getOverlayManager().getOptionsScreenFor(this);
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return NAME;
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    public Collection<Property<?>> getPropertyList() {
        return this.propertyList;
    }
}

