/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.overlays.options.types;

import java.util.Optional;
import java.util.function.Consumer;
import me.phoenixra.atumconfig.api.config.Config;
import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.client.gui.GuiTexture;
import me.phoenixra.visor.api.client.gui.overlays.VROverlay;
import me.phoenixra.visor.api.client.gui.overlays.VROverlayTemplate;
import me.phoenixra.visor.api.client.gui.overlays.options.OptionsScreen;
import me.phoenixra.visor.api.client.gui.overlays.options.OverlayOptionGroup;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverlayOptionsIdentity
extends OverlayOptionGroup<OverlayOptionsIdentity> {
    public static final String ID = "identity";
    private static final Component NAME = Component.m_237115_((String)"visor.overlay.options.identity");
    private Component name;
    private Component description;
    private GuiTexture icon;
    private String rawName;
    private String rawDescription;
    private String rawIcon;

    public OverlayOptionsIdentity(@NotNull VROverlay owner, @NotNull Consumer<OverlayOptionsIdentity> defaultSettings) {
        super(owner, defaultSettings);
    }

    @Override
    public void update(boolean force) {
    }

    @Override
    protected void onLoad(@NotNull Config config) {
        this.rawName = config.getStringOrNull("name");
        this.rawDescription = config.getStringOrNull("description");
        this.rawIcon = config.getStringOrNull("icon");
        this.setName(this.rawName);
        this.setDescription(this.rawDescription);
        this.setIcon(this.rawIcon);
        this.onChanged();
    }

    @Override
    protected void onSave(@NotNull Config config) {
        config.set("name", this.rawName);
        config.set("description", this.rawDescription);
        config.set("icon", this.rawIcon);
    }

    public void setName(@Nullable String rawValue) {
        String oldValue = this.rawName;
        this.rawName = rawValue;
        MutableComponent mutableComponent = this.name = rawValue != null ? Component.m_237115_((String)rawValue) : Component.m_237113_((String)this.owner.getId());
        if (oldValue == null && rawValue != null || oldValue != null && !oldValue.equals(rawValue)) {
            this.onChanged();
        }
    }

    public void setDescription(@Nullable String rawValue) {
        String oldValue = this.rawDescription;
        this.rawDescription = rawValue;
        MutableComponent mutableComponent = this.description = rawValue != null ? Component.m_237115_((String)rawValue) : Component.m_237113_((String)"No description");
        if (oldValue == null && rawValue != null || oldValue != null && !oldValue.equals(rawValue)) {
            this.onChanged();
        }
    }

    public void setIcon(@Nullable String rawValue) {
        String oldValue = this.rawIcon;
        this.rawIcon = rawValue;
        try {
            if (this.rawIcon == null || this.rawIcon.isBlank()) {
                this.rawIcon = null;
            }
            if (this.rawIcon != null) {
                if (!this.rawIcon.endsWith(".png")) {
                    this.rawIcon = null;
                } else {
                    ResourceLocation resourceLoc;
                    ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
                    Optional resource = resourceManager.m_213713_(resourceLoc = new ResourceLocation(this.rawIcon));
                    if (resource.isEmpty()) {
                        this.rawIcon = null;
                    }
                }
            }
        }
        catch (Exception e) {
            this.rawIcon = null;
        }
        GuiTexture guiTexture = this.icon = this.rawIcon != null ? new GuiTexture(new ResourceLocation(this.rawIcon)) : VisorAddon.MISSING_ICON;
        if (oldValue == null && rawValue != null || oldValue != null && !oldValue.equals(rawValue)) {
            this.onChanged();
        }
    }

    private void onChanged() {
        VROverlay vROverlay = this.owner;
        if (vROverlay instanceof VROverlayTemplate) {
            VROverlayTemplate template = (VROverlayTemplate)vROverlay;
            template.updateIdentity();
        }
        this.changesNotSaved = true;
    }

    @Override
    public void loadDefaults() {
        if (!this.isInitialized()) {
            super.loadDefaults();
        }
    }

    @Override
    public boolean supportsCopying() {
        return false;
    }

    @Override
    @NotNull
    public OptionsScreen<?> getScreen() {
        return VisorAPI.client().getGuiManager().getOverlayManager().getOptionsScreenFor(this);
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return NAME;
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    public Component getName() {
        return this.name;
    }

    public Component getDescription() {
        return this.description;
    }

    public GuiTexture getIcon() {
        return this.icon;
    }

    public String getRawName() {
        return this.rawName;
    }

    public String getRawDescription() {
        return this.rawDescription;
    }

    public String getRawIcon() {
        return this.rawIcon;
    }
}

