/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.overlays.options.types;

import com.mojang.blaze3d.pipeline.RenderTarget;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.phoenixra.atumconfig.api.config.Config;
import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.client.gui.overlays.VROverlay;
import me.phoenixra.visor.api.client.gui.overlays.options.OptionsScreen;
import me.phoenixra.visor.api.client.gui.overlays.options.OverlayOptionGroup;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class OverlayOptionsScreenRegion
extends OverlayOptionGroup<OverlayOptionsScreenRegion> {
    public static final String ID = "screen_region";
    private static final Component NAME = Component.m_237115_((String)"visor.overlay.options.screen_region");
    private final Supplier<RenderTarget> targetSupplier;
    private final int screenWidth;
    private final int screenHeight;
    private int regionX;
    private int regionY;
    private int regionWidth;
    private int regionHeight;

    public OverlayOptionsScreenRegion(@NotNull VROverlay owner, int screenWidth, int screenHeight, @NotNull Supplier<RenderTarget> targetSupplier, @NotNull Consumer<OverlayOptionsScreenRegion> defaultSettings) {
        super(owner, defaultSettings);
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.targetSupplier = targetSupplier;
    }

    @Override
    public void update(boolean force) {
    }

    @Override
    protected void onLoad(@NotNull Config config) {
        this.setRegionX(config.getIntOrDefault("region_x", 0));
        this.setRegionY(config.getIntOrDefault("region_y", 0));
        this.setRegionWidth(config.getIntOrDefault("region_width", this.screenWidth));
        this.setRegionHeight(config.getIntOrDefault("region_height", this.screenHeight));
        this.changesNotSaved = false;
    }

    @Override
    public void onSave(@NotNull Config config) {
        config.set("region_x", this.regionX);
        config.set("region_y", this.regionY);
        config.set("region_width", this.regionWidth);
        config.set("region_height", this.regionHeight);
    }

    public void setRegionX(int value) {
        int oldValue = this.regionX;
        this.regionX = Mth.m_14045_((int)value, (int)0, (int)this.screenWidth);
        if (oldValue != this.regionX) {
            this.regionWidth = Mth.m_14045_((int)this.regionWidth, (int)1, (int)(this.screenWidth - this.regionX));
            this.changesNotSaved = true;
        }
    }

    public void setRegionY(int value) {
        int oldValue = this.regionY;
        this.regionY = Mth.m_14045_((int)value, (int)0, (int)this.screenHeight);
        if (oldValue != this.regionY) {
            this.regionHeight = Mth.m_14045_((int)this.regionHeight, (int)1, (int)(this.screenHeight - this.regionY));
            this.changesNotSaved = true;
        }
    }

    public void setRegionWidth(int value) {
        int oldValue = this.regionWidth;
        this.regionWidth = Mth.m_14045_((int)value, (int)1, (int)(this.screenWidth - this.regionX));
        if (oldValue != this.regionWidth) {
            this.changesNotSaved = true;
        }
    }

    public void setRegionHeight(int value) {
        int oldValue = this.regionHeight;
        this.regionHeight = Mth.m_14045_((int)value, (int)1, (int)(this.screenHeight - this.regionY));
        if (oldValue != this.regionHeight) {
            this.changesNotSaved = true;
        }
    }

    @Override
    public boolean supportsCopying() {
        return true;
    }

    @Override
    @NotNull
    public OptionsScreen<?> getScreen() {
        return VisorAPI.client().getGuiManager().getOverlayManager().getOptionsScreenFor(this);
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return NAME;
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    public Supplier<RenderTarget> getTargetSupplier() {
        return this.targetSupplier;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    public int getRegionX() {
        return this.regionX;
    }

    public int getRegionY() {
        return this.regionY;
    }

    public int getRegionWidth() {
        return this.regionWidth;
    }

    public int getRegionHeight() {
        return this.regionHeight;
    }
}

