/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.overlays.options.types.properties;

import me.phoenixra.atumconfig.api.config.Config;
import net.minecraft.client.gui.components.AbstractWidget;
import org.jetbrains.annotations.NotNull;

public abstract class Property<T> {
    protected final String key;
    protected final T defaultValue;
    private Runnable responder;
    private T value;

    public Property(@NotNull String key, @NotNull T defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.value = defaultValue;
    }

    protected final void onValueChanged() {
        if (this.responder != null) {
            this.responder.run();
        }
    }

    public void update() {
    }

    public void loadDefault() {
        this.value = this.defaultValue;
    }

    public abstract void onLoad(@NotNull Config var1);

    public abstract void onSave(@NotNull Config var1);

    public abstract AbstractWidget createWidget();

    public String getKey() {
        return this.key;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public Runnable getResponder() {
        return this.responder;
    }

    public T getValue() {
        return this.value;
    }

    public void setResponder(Runnable responder) {
        this.responder = responder;
    }

    public void setValue(T value) {
        this.value = value;
    }
}

