/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.overlays.options.types.properties;

import me.phoenixra.atumconfig.api.config.Config;
import me.phoenixra.visor.api.client.gui.overlays.options.types.properties.Property;
import me.phoenixra.visor.api.client.gui.widgets.EditBoxImage;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoEditBox;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class PropertyInt
extends Property<Integer> {
    protected final int minValue;
    protected final int maxValue;
    protected final WidgetInfoEditBox widgetInfo;

    public PropertyInt(@NotNull String key, int defaultValue, int minValue, int maxValue, @NotNull WidgetInfoEditBox widgetInfo) {
        super(key, defaultValue);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.widgetInfo = widgetInfo;
    }

    @Override
    public void onLoad(@NotNull Config config) {
        this.setValue(config.getIntOrDefault(this.key, (Integer)this.defaultValue));
    }

    @Override
    public void onSave(@NotNull Config config) {
        config.set(this.key, this.getValue());
    }

    @Override
    public void setValue(Integer value) {
        super.setValue(Mth.m_14045_((int)value, (int)this.minValue, (int)this.maxValue));
    }

    public EditBoxImage createWidget() {
        WidgetInfoEditBox widgetInfo = new WidgetInfoEditBox(this.widgetInfo);
        EditBoxImage widget = new EditBoxImage(widgetInfo);
        widget.m_94144_(Integer.toString((Integer)this.getValue()));
        widget.m_94153_(s -> {
            if (s.isEmpty() || s.equals("-")) {
                return true;
            }
            try {
                int v = Integer.parseInt(s);
                return v >= this.minValue && v <= this.maxValue;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
        widget.m_94151_(s -> {
            if (s.isEmpty() || s.equals("-")) {
                return;
            }
            try {
                this.setValue(Integer.parseInt(s));
                this.onValueChanged();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        int maxDigits = Math.max(Integer.toString(Math.abs(this.minValue)).length(), Integer.toString(Math.abs(this.maxValue)).length()) + (this.minValue < 0 ? 1 : 0);
        widget.m_94199_(maxDigits);
        widget.m_94198_();
        return widget;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public WidgetInfoEditBox getWidgetInfo() {
        return this.widgetInfo;
    }
}

