/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.overlays.options.types.properties;

import java.util.regex.Pattern;
import me.phoenixra.atumconfig.api.config.Config;
import me.phoenixra.visor.api.client.gui.overlays.options.types.properties.Property;
import me.phoenixra.visor.api.client.gui.widgets.EditBoxImage;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoEditBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyString
extends Property<String> {
    protected final int maxLength;
    @Nullable
    protected final Pattern validator;
    protected final WidgetInfoEditBox widgetInfo;

    public PropertyString(@NotNull String key, @NotNull String defaultValue, int maxLength, @Nullable Pattern validator, @NotNull WidgetInfoEditBox widgetInfo) {
        super(key, defaultValue);
        if (maxLength < 1) {
            throw new IllegalArgumentException("maxLength must be >= 1");
        }
        this.maxLength = maxLength;
        this.validator = validator;
        this.widgetInfo = widgetInfo;
    }

    @Override
    public void onLoad(@NotNull Config config) {
        this.setValue(config.getStringOrDefault(this.key, (String)this.defaultValue));
    }

    @Override
    public void onSave(@NotNull Config config) {
        config.set(this.key, this.getValue());
    }

    @Override
    public void setValue(String value) {
        super.setValue(this.sanitizeForState(value));
    }

    public EditBoxImage createWidget() {
        WidgetInfoEditBox widgetInfo = new WidgetInfoEditBox(this.widgetInfo);
        EditBoxImage widget = new EditBoxImage(widgetInfo);
        widget.m_94144_((String)this.getValue());
        widget.m_94199_(this.maxLength);
        widget.m_94153_(s -> s.length() <= this.maxLength);
        widget.m_94151_(s -> {
            if (this.isValid((String)s)) {
                this.setValue((String)s);
                this.onValueChanged();
            }
        });
        widget.m_94198_();
        return widget;
    }

    private boolean isValid(String s) {
        if (s == null) {
            return false;
        }
        int len = s.length();
        if (len > this.maxLength) {
            return false;
        }
        return this.validator == null || this.validator.matcher(s).matches();
    }

    private static boolean fits(String s, int min, int max, @Nullable Pattern re, boolean trim) {
        if (s == null) {
            return false;
        }
        String t = trim ? s.strip() : s;
        int len = t.length();
        if (len < min || len > max) {
            return false;
        }
        return re == null || re.matcher(t).matches();
    }

    private String sanitizeForState(String s) {
        if (s == null) {
            s = "";
        }
        if (s.length() > this.maxLength) {
            s = s.substring(0, this.maxLength);
        }
        if (this.validator != null && !this.validator.matcher(s).matches()) {
            String d = (String)this.defaultValue;
            return d.length() > this.maxLength ? d.substring(0, this.maxLength) : d;
        }
        return s;
    }
}

