/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.widgets;

import java.util.Objects;
import java.util.function.Consumer;
import me.phoenixra.visor.api.client.gui.GuiTexture;
import me.phoenixra.visor.api.client.gui.helpers.GuiHelper;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoButtonImaged;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;

public class ButtonImaged
extends AbstractButton {
    private final WidgetInfoButtonImaged widgetInfo;
    private final Consumer<ButtonImaged> onPress;
    private boolean selected;

    public ButtonImaged(WidgetInfoButtonImaged widgetInfo, Consumer<ButtonImaged> onPress) {
        super(widgetInfo.getX(), widgetInfo.getY(), widgetInfo.getWidth(), widgetInfo.getHeight(), widgetInfo.getText());
        this.widgetInfo = widgetInfo;
        this.onPress = onPress;
        this.m_257544_(widgetInfo.getTooltip());
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.f_93623_ = !this.widgetInfo.isInactiveOnSelected() || !selected;
    }

    public void m_5691_() {
        if (this.onPress != null) {
            this.onPress.accept(this);
        }
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        GuiTexture texture;
        if (!this.f_93623_) {
            texture = this.selected ? this.widgetInfo.getTextureSelected() : this.widgetInfo.getTextureInactive();
        } else if (this.selected) {
            texture = this.widgetInfo.getTextureHoveredSelected();
            if (!this.f_93622_ || texture == null) {
                texture = this.widgetInfo.getTextureSelected();
            }
        } else {
            texture = this.f_93622_ ? this.widgetInfo.getTextureHovered() : this.widgetInfo.getTexture();
        }
        if (texture == null) {
            texture = this.widgetInfo.getTexture();
        }
        this.widgetInfo.pos(this.m_252754_(), this.m_252907_()).size(this.m_5711_(), this.m_93694_());
        texture.blit(guiGraphics, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_);
        this.widgetInfo.drawHighlight(guiGraphics, this.f_93623_, this.f_93622_, this.selected);
        String text = this.m_6035_().getString();
        int textX = this.m_252754_() + this.widgetInfo.getTextPosOffset().x;
        int textY = this.m_252907_() + this.widgetInfo.getTextPosOffset().y;
        int textW = this.m_5711_() + this.widgetInfo.getTextSizeOffset().x;
        int textH = this.m_93694_() + this.widgetInfo.getTextSizeOffset().y;
        if (!text.isEmpty()) {
            Font font = Minecraft.m_91087_().f_91062_;
            int color = this.widgetInfo.getTextColor().toInt();
            if (this.widgetInfo.isScaleText()) {
                GuiHelper.renderScalableText(guiGraphics, font, text, color, textX, textY, textW, textH, true);
                return;
            }
            int textWidth = font.m_92895_(text);
            Objects.requireNonNull(font);
            int textHeight = 9;
            int x = textX + (textW - textWidth) / 2;
            int y = textY + (textH - textHeight) / 2;
            if (textWidth <= textW) {
                guiGraphics.m_280056_(font, text, x, y, color, false);
            } else {
                int overflow = textWidth - textW;
                double cycleSecs = 4.0;
                double t = (double)(System.currentTimeMillis() % (long)(cycleSecs * 1000.0)) / (cycleSecs * 1000.0);
                double phase = (Math.sin(Math.PI * 2 * t) + 1.0) * 0.5;
                int offset = (int)(phase * (double)overflow);
                guiGraphics.m_280588_(textX, textY, textX + textW, textY + textH);
                guiGraphics.m_280056_(font, text, x - offset, y, color, false);
                guiGraphics.m_280618_();
            }
        }
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        this.m_168802_(narrationElementOutput);
    }

    public WidgetInfoButtonImaged getWidgetInfo() {
        return this.widgetInfo;
    }

    public boolean isSelected() {
        return this.selected;
    }
}

