/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.widgets;

import java.util.List;
import java.util.function.Consumer;
import me.phoenixra.atumconfig.api.tuples.PairRecord;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class DiscreteSliderWidget<T>
extends AbstractSliderButton {
    private final List<T> entries;
    private final Consumer<PairRecord<DiscreteSliderWidget<T>, T>> onChange;
    private Component message;
    private int index;

    public DiscreteSliderWidget(int x, int y, int width, int height, List<T> entries, int initialIndex, Consumer<PairRecord<DiscreteSliderWidget<T>, T>> onChange) {
        super(x, y, width, height, (Component)Component.m_237119_(), DiscreteSliderWidget.normalizeIndex(Math.max(0, Math.min(entries.size() - 1, initialIndex)), entries.size()));
        this.entries = List.copyOf(entries);
        this.onChange = onChange != null ? onChange : t -> {};
        this.index = this.clampIndex(initialIndex);
        this.snapToIndex();
        this.m_5695_();
    }

    protected void m_5695_() {
        this.m_93666_(this.message);
    }

    protected void m_5697_() {
        int newIndex = this.valueToNearestIndex(this.f_93577_);
        if (newIndex != this.index) {
            this.index = newIndex;
            this.onChange.accept(new PairRecord<DiscreteSliderWidget, T>(this, this.entries.get(this.index)));
        }
        this.snapToIndex();
        this.m_5695_();
    }

    public T getSelected() {
        return this.entries.get(this.index);
    }

    public void setIndex(int newIndex) {
        if (this.entries.isEmpty()) {
            return;
        }
        int clamped = this.clampIndex(newIndex);
        if (clamped != this.index) {
            this.index = clamped;
            this.snapToIndex();
            this.m_5695_();
            this.onChange.accept(new PairRecord<DiscreteSliderWidget, T>(this, this.entries.get(this.index)));
        }
    }

    public void setSelected(T value) {
        int idx = this.entries.indexOf(value);
        if (idx >= 0) {
            this.setIndex(idx);
        }
    }

    private int clampIndex(int idx) {
        return Mth.m_14045_((int)idx, (int)0, (int)(this.entries.size() - 1));
    }

    private void snapToIndex() {
        this.f_93577_ = DiscreteSliderWidget.normalizeIndex(this.index, this.entries.size());
    }

    private static double normalizeIndex(int idx, int size) {
        if (size <= 1) {
            return 0.0;
        }
        return (double)idx / (double)(size - 1);
    }

    private int valueToNearestIndex(double v) {
        if (this.entries.size() <= 1) {
            return 0;
        }
        double clamped = Mth.m_14008_((double)v, (double)0.0, (double)1.0);
        int nearest = (int)Math.round(clamped * (double)(this.entries.size() - 1));
        return Mth.m_14045_((int)nearest, (int)0, (int)(this.entries.size() - 1));
    }

    public Component m_6035_() {
        return this.message;
    }

    public void m_93666_(Component message) {
        this.message = message;
    }

    public int getIndex() {
        return this.index;
    }
}

