/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.widgets;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import me.phoenixra.visor.api.client.gui.GuiTexture;
import me.phoenixra.visor.api.client.gui.helpers.GuiHelper;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoSlider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SliderWidget<T>
extends AbstractWidget {
    private final WidgetInfoSlider widgetInfo;
    private final List<T> entries;
    private final Consumer<SliderWidget<T>> responder;
    private int knobX;
    private int knobY;
    private int knobWidth;
    private int knobHeight;
    private Component text;
    private int index = -1;
    private T selected;

    public SliderWidget(@NotNull WidgetInfoSlider widgetInfo, @NotNull List<T> entries, @Nullable Consumer<SliderWidget<T>> responder) {
        super(widgetInfo.getX(), widgetInfo.getY(), widgetInfo.getWidth(), widgetInfo.getHeight(), (Component)Component.m_237119_());
        if (entries.size() <= 1) {
            throw new IllegalArgumentException("entries list of slider widget cannot be empty or size less than 2");
        }
        this.widgetInfo = widgetInfo;
        this.entries = List.copyOf(entries);
        this.responder = responder != null ? responder : it -> {};
        this.knobY = this.m_252907_();
        this.knobWidth = widgetInfo.getKnobWidth();
        this.knobHeight = this.m_93694_();
        this.m_257544_(widgetInfo.getTooltip());
        this.setIndex(0, false);
    }

    private void setIndex(int newIndex, boolean callResponder) {
        int clamped = this.clampIndex(newIndex);
        if (clamped != this.index) {
            this.index = clamped;
            this.selected = this.entries.get(this.index);
            if (callResponder) {
                this.responder.accept(this);
            }
        }
    }

    public void setSelected(@Nullable T value, boolean callResponder) {
        this.setIndex(this.entries.indexOf(value), callResponder);
    }

    protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        boolean knobHovered;
        GuiTexture knob;
        this.widgetInfo.pos(this.m_252754_(), this.m_252907_()).size(this.m_5711_(), this.m_93694_());
        this.repositionKnob();
        GuiTexture bg = this.widgetInfo.getBackgroundTexture();
        if (bg != null) {
            bg.blit(guiGraphics, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_());
        }
        if ((knob = this.resolveKnobTexture(knobHovered = this.f_93623_ && mouseX >= this.knobX && mouseX < this.knobX + this.knobWidth && mouseY >= this.knobY && mouseY < this.knobY + this.knobHeight)) != null) {
            knob.blit(guiGraphics, this.knobX, this.knobY, this.knobWidth, this.knobHeight);
        }
        this.widgetInfo.drawHighlight(guiGraphics, this.knobX, this.knobY, this.knobWidth, this.knobHeight, this.f_93623_, knobHovered);
        String text = this.resolveDisplayText();
        if (!text.isEmpty()) {
            Font font = this.widgetInfo.getTextFont() != null ? this.widgetInfo.getTextFont() : Minecraft.m_91087_().f_91062_;
            int color = this.widgetInfo.getTextColor().toInt();
            int textX = this.m_252754_();
            int textY = this.m_252907_();
            int textW = this.m_5711_();
            int textH = this.m_93694_();
            if (this.widgetInfo.isScaleText()) {
                GuiHelper.renderScalableText(guiGraphics, font, text, color, textX, textY, textW, textH, true);
            } else {
                int strW = font.m_92895_(text);
                Objects.requireNonNull(font);
                int strH = 9;
                int x = textX + (textW - strW) / 2;
                int y = textY + (textH - strH) / 2;
                if (strW <= textW) {
                    guiGraphics.m_280056_(font, text, x, y, color, false);
                } else {
                    int overflow = strW - textW;
                    double cycleSecs = 4.0;
                    double t = (double)(System.currentTimeMillis() % (long)(cycleSecs * 1000.0)) / (cycleSecs * 1000.0);
                    double phase = (Math.sin(Math.PI * 2 * t) + 1.0) * 0.5;
                    int offset = (int)(phase * (double)overflow);
                    guiGraphics.m_280588_(textX, textY, textX + textW, textY + textH);
                    guiGraphics.m_280056_(font, text, x - offset, y, color, false);
                    guiGraphics.m_280618_();
                }
            }
        }
    }

    private GuiTexture resolveKnobTexture(boolean knobHovered) {
        if (!this.f_93623_) {
            return this.widgetInfo.getKnobTextureInactive() != null ? this.widgetInfo.getKnobTextureInactive() : this.widgetInfo.getKnobTexture();
        }
        if (knobHovered && this.widgetInfo.getKnobTextureHovered() != null) {
            return this.widgetInfo.getKnobTextureHovered();
        }
        return this.widgetInfo.getKnobTexture();
    }

    private void repositionKnob() {
        double normalized = (double)this.index / (double)(this.entries.size() - 1);
        int left = this.m_252754_();
        int right = this.m_252754_() + this.m_5711_() - this.knobWidth;
        this.knobX = left + (int)Math.round(normalized * (double)(right - left));
        this.knobY = this.m_252907_();
        this.knobWidth = this.widgetInfo.getKnobWidth();
        this.knobHeight = this.m_93694_();
    }

    private int clampIndex(int idx) {
        return Mth.m_14045_((int)idx, (int)0, (int)Math.max(0, this.entries.size() - 1));
    }

    private String resolveDisplayText() {
        if (this.text != null && !this.text.getString().isEmpty()) {
            return this.text.getString();
        }
        if (this.selected == null) {
            return "";
        }
        String s = String.valueOf(this.selected);
        return s != null ? s : "";
    }

    private void selectFromMouse(double mouseX) {
        double start = (double)this.m_252754_() + (double)this.knobWidth * 0.5;
        double end = (double)(this.m_252754_() + this.m_5711_()) - (double)this.knobWidth * 0.5;
        double span = end - start;
        if (span <= 0.0) {
            this.setIndex(0, true);
            return;
        }
        double t = (mouseX - start) / span;
        t = Mth.m_14008_((double)t, (double)0.0, (double)1.0);
        double scaled = t * (double)(this.entries.size() - 1);
        int nearest = (int)Math.round(scaled);
        this.setIndex(nearest, true);
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.selectFromMouse(mouseX);
    }

    protected void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
        super.m_7212_(mouseX, mouseY, dragX, dragY);
        this.selectFromMouse(mouseX);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.f_93623_) {
            return false;
        }
        if (keyCode == 263) {
            this.setIndex(this.index - 1, true);
            return true;
        }
        if (keyCode == 262) {
            this.setIndex(this.index + 1, true);
            return true;
        }
        if (keyCode == 268) {
            this.setIndex(0, true);
            return true;
        }
        if (keyCode == 269) {
            this.setIndex(this.entries.size() - 1, true);
            return true;
        }
        return false;
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        String text = this.resolveDisplayText();
        MutableComponent title = Component.m_237110_((String)"gui.narrate.slider", (Object[])new Object[]{Component.m_237113_((String)text)});
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)title);
        if (this.f_93623_) {
            if (this.m_93696_()) {
                narrationElementOutput.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.slider.usage.focused"));
            } else {
                narrationElementOutput.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.slider.usage.hovered"));
            }
        }
    }

    public WidgetInfoSlider getWidgetInfo() {
        return this.widgetInfo;
    }

    public Component getText() {
        return this.text;
    }

    public void setText(Component text) {
        this.text = text;
    }

    public int getIndex() {
        return this.index;
    }

    public T getSelected() {
        return this.selected;
    }
}

