/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.widgets.info;

import com.mojang.blaze3d.vertex.PoseStack;
import me.phoenixra.atumvr.api.misc.color.AtumColor;
import me.phoenixra.visor.api.client.gui.GuiTexture;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import org.jetbrains.annotations.NotNull;

public class WidgetInfoSlider
extends WidgetInfo {
    private GuiTexture backgroundTexture;
    private GuiTexture knobTexture;
    private GuiTexture knobTextureHovered;
    private GuiTexture knobTextureInactive;
    private boolean knobHighlightEnabled = false;
    private boolean knobHighlightCorners = true;
    private AtumColor knobHighlightHovered = AtumColor.WHITE;
    private float knobHighlightThickness = 0.65f;
    private int knobWidth = 6;
    private Font textFont;
    private AtumColor textColor;
    private boolean scaleText;
    private Tooltip tooltip;
    private int knobHighlightHoveredInt;
    private int knobHighlightCornerHoveredInt;

    public WidgetInfoSlider(@NotNull WidgetInfoSlider copyFrom) {
        super(copyFrom);
        this.textFont = Minecraft.m_91087_().f_91062_;
        this.textColor = AtumColor.WHITE;
        this.scaleText = false;
        this.knobHighlightHoveredInt = AtumColor.WHITE.toInt();
        this.knobHighlightCornerHoveredInt = AtumColor.WHITE.toInt();
        this.backgroundTexture = copyFrom.backgroundTexture;
        this.knobTexture = copyFrom.knobTexture;
        this.knobTextureHovered = copyFrom.knobTextureHovered;
        this.knobTextureInactive = copyFrom.knobTextureInactive;
        this.knobHighlightEnabled = copyFrom.knobHighlightEnabled;
        this.knobHighlightCorners = copyFrom.knobHighlightCorners;
        this.knobHighlightHovered = copyFrom.knobHighlightHovered;
        this.knobHighlightThickness = copyFrom.knobHighlightThickness;
        this.knobHighlightHoveredInt = copyFrom.knobHighlightHoveredInt;
        this.knobHighlightCornerHoveredInt = copyFrom.knobHighlightCornerHoveredInt;
        this.knobWidth = copyFrom.knobWidth;
        this.textFont = copyFrom.textFont;
        this.textColor = copyFrom.textColor;
        this.scaleText = copyFrom.scaleText;
        this.tooltip = copyFrom.tooltip;
    }

    public WidgetInfoSlider() {
        this.textFont = Minecraft.m_91087_().f_91062_;
        this.textColor = AtumColor.WHITE;
        this.scaleText = false;
        this.knobHighlightHoveredInt = AtumColor.WHITE.toInt();
        this.knobHighlightCornerHoveredInt = AtumColor.WHITE.toInt();
    }

    public WidgetInfoSlider textures(GuiTexture background, GuiTexture knob, GuiTexture knobHovered, GuiTexture knobInactive) {
        return this.setBackgroundTexture(background).setKnobTexture(knob).setKnobTextureHovered(knobHovered).setKnobTextureInactive(knobInactive);
    }

    public WidgetInfoSlider textures(GuiTexture background, GuiTexture knob, GuiTexture knobHovered) {
        return this.setBackgroundTexture(background).setKnobTexture(knob).setKnobTextureHovered(knobHovered).setKnobTextureInactive(knob);
    }

    public WidgetInfoSlider highlight(AtumColor hovered, float thickness) {
        return this.setKnobHighlightEnabled(true).setKnobHighlightHovered(hovered).setKnobHighlightThickness(thickness);
    }

    public WidgetInfoSlider highlight(AtumColor hovered) {
        return this.setKnobHighlightEnabled(true).setKnobHighlightHovered(hovered);
    }

    public WidgetInfoSlider setKnobHighlightHovered(AtumColor color) {
        this.knobHighlightHovered = color;
        this.knobHighlightHoveredInt = color.toInt();
        this.knobHighlightCornerHoveredInt = color.lighten(0.25f).toInt();
        return this;
    }

    @Override
    public WidgetInfoSlider pos(int x, int y) {
        return (WidgetInfoSlider)super.pos(x, y);
    }

    @Override
    public WidgetInfoSlider size(int width, int height) {
        return (WidgetInfoSlider)super.size(width, height);
    }

    public void drawHighlight(GuiGraphics guiGraphics, int x, int y, int width, int height, boolean active, boolean hovered) {
        if (!this.knobHighlightEnabled) {
            return;
        }
        if (!hovered || !active) {
            return;
        }
        int baseColor = this.knobHighlightHoveredInt;
        int cornerColor = this.knobHighlightCornerHoveredInt;
        float s = Math.max(0.0f, this.knobHighlightThickness);
        if (s <= 0.0f) {
            return;
        }
        float x0 = x;
        float y0 = y;
        float x1 = x + width;
        float y1 = y + height;
        float innerW = Math.max(0.0f, x1 - x0);
        float innerH = Math.max(0.0f, y1 - y0);
        if (innerW <= 0.0f || innerH <= 0.0f) {
            return;
        }
        float innerHAvail = Math.max(0.0f, innerH - 2.0f * s);
        PoseStack pose = guiGraphics.m_280168_();
        pose.m_85836_();
        pose.m_252880_(x0, y0, 0.0f);
        pose.m_85841_(innerW, s, 1.0f);
        guiGraphics.m_280509_(0, 0, 1, 1, baseColor);
        pose.m_85849_();
        pose.m_85836_();
        pose.m_252880_(x0, y1 - s, 0.0f);
        pose.m_85841_(innerW, s, 1.0f);
        guiGraphics.m_280509_(0, 0, 1, 1, baseColor);
        pose.m_85849_();
        if (innerHAvail > 0.0f) {
            pose.m_85836_();
            pose.m_252880_(x0, y0 + s, 0.0f);
            pose.m_85841_(s, innerHAvail, 1.0f);
            guiGraphics.m_280509_(0, 0, 1, 1, baseColor);
            pose.m_85849_();
            pose.m_85836_();
            pose.m_252880_(x1 - s, y0 + s, 0.0f);
            pose.m_85841_(s, innerHAvail, 1.0f);
            guiGraphics.m_280509_(0, 0, 1, 1, baseColor);
            pose.m_85849_();
        }
        if (this.knobHighlightCorners) {
            pose.m_85836_();
            pose.m_252880_(x0, y0, 0.0f);
            pose.m_85841_(s, s, 1.0f);
            guiGraphics.m_280509_(0, 0, 1, 1, cornerColor);
            pose.m_85849_();
            pose.m_85836_();
            pose.m_252880_(x1 - s, y0, 0.0f);
            pose.m_85841_(s, s, 1.0f);
            guiGraphics.m_280509_(0, 0, 1, 1, cornerColor);
            pose.m_85849_();
            pose.m_85836_();
            pose.m_252880_(x0, y1 - s, 0.0f);
            pose.m_85841_(s, s, 1.0f);
            guiGraphics.m_280509_(0, 0, 1, 1, cornerColor);
            pose.m_85849_();
            pose.m_85836_();
            pose.m_252880_(x1 - s, y1 - s, 0.0f);
            pose.m_85841_(s, s, 1.0f);
            guiGraphics.m_280509_(0, 0, 1, 1, cornerColor);
            pose.m_85849_();
        }
    }

    public WidgetInfoSlider setBackgroundTexture(GuiTexture backgroundTexture) {
        this.backgroundTexture = backgroundTexture;
        return this;
    }

    public GuiTexture getBackgroundTexture() {
        return this.backgroundTexture;
    }

    public WidgetInfoSlider setKnobTexture(GuiTexture knobTexture) {
        this.knobTexture = knobTexture;
        return this;
    }

    public GuiTexture getKnobTexture() {
        return this.knobTexture;
    }

    public WidgetInfoSlider setKnobTextureHovered(GuiTexture knobTextureHovered) {
        this.knobTextureHovered = knobTextureHovered;
        return this;
    }

    public GuiTexture getKnobTextureHovered() {
        return this.knobTextureHovered;
    }

    public WidgetInfoSlider setKnobTextureInactive(GuiTexture knobTextureInactive) {
        this.knobTextureInactive = knobTextureInactive;
        return this;
    }

    public GuiTexture getKnobTextureInactive() {
        return this.knobTextureInactive;
    }

    public WidgetInfoSlider setKnobHighlightEnabled(boolean knobHighlightEnabled) {
        this.knobHighlightEnabled = knobHighlightEnabled;
        return this;
    }

    public boolean isKnobHighlightEnabled() {
        return this.knobHighlightEnabled;
    }

    public WidgetInfoSlider setKnobHighlightCorners(boolean knobHighlightCorners) {
        this.knobHighlightCorners = knobHighlightCorners;
        return this;
    }

    public boolean isKnobHighlightCorners() {
        return this.knobHighlightCorners;
    }

    public AtumColor getKnobHighlightHovered() {
        return this.knobHighlightHovered;
    }

    public WidgetInfoSlider setKnobHighlightThickness(float knobHighlightThickness) {
        this.knobHighlightThickness = knobHighlightThickness;
        return this;
    }

    public float getKnobHighlightThickness() {
        return this.knobHighlightThickness;
    }

    public WidgetInfoSlider setKnobWidth(int knobWidth) {
        this.knobWidth = knobWidth;
        return this;
    }

    public int getKnobWidth() {
        return this.knobWidth;
    }

    public WidgetInfoSlider setTextFont(Font textFont) {
        this.textFont = textFont;
        return this;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public WidgetInfoSlider setTextColor(AtumColor textColor) {
        this.textColor = textColor;
        return this;
    }

    public AtumColor getTextColor() {
        return this.textColor;
    }

    public WidgetInfoSlider setScaleText(boolean scaleText) {
        this.scaleText = scaleText;
        return this;
    }

    public boolean isScaleText() {
        return this.scaleText;
    }

    public WidgetInfoSlider setTooltip(Tooltip tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public Tooltip getTooltip() {
        return this.tooltip;
    }
}

