/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.widgets.lists;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import me.phoenixra.visor.api.client.gui.GuiTexture;
import me.phoenixra.visor.api.client.gui.helpers.GuiHelper;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoCheckboxList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckboxList
extends AbstractSelectionList<CheckboxEntry> {
    private final int paddingTop;
    private final int paddingLeft;
    private final int paddingCheckbox;
    private final int scrollBarWidth;
    private final WidgetInfoCheckboxList widgetInfo;
    private final Consumer<CheckboxEntry> onChanged;
    private final Map<String, CheckboxEntry> entriesMap = new HashMap<String, CheckboxEntry>();
    private Map<String, String> rawEntries;
    private Map<String, Boolean> rawEntriesState;
    private long lastDragCall = -1L;

    public CheckboxList(@NotNull WidgetInfoCheckboxList widgetInfo, @NotNull Map<String, String> rawEntries, @NotNull List<String> selectedEntries, @Nullable Consumer<CheckboxEntry> onChanged) {
        super(Minecraft.m_91087_(), widgetInfo.getWidth(), widgetInfo.getHeight(), widgetInfo.getY(), widgetInfo.getY() + widgetInfo.getHeight(), widgetInfo.getItemHeight());
        this.widgetInfo = widgetInfo;
        this.paddingTop = widgetInfo.getPaddingTop();
        this.paddingLeft = widgetInfo.getPaddingLeft();
        this.paddingCheckbox = widgetInfo.getPaddingCheckbox();
        this.scrollBarWidth = widgetInfo.getScrollBarWidth();
        this.onChanged = onChanged;
        this.m_93507_(widgetInfo.getX());
        this.m_93496_(false);
        this.m_93488_(false);
        this.m_93471_(false);
        this.resetEntries(rawEntries, selectedEntries);
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        CheckboxEntry checkboxEntry = this.f_168789_ = this.m_5953_(mouseX, mouseY) ? this.getEntryAtPosition(mouseX, mouseY) : null;
        if (this.f_93399_ && this.lastDragCall + 200L < System.currentTimeMillis()) {
            this.f_93399_ = false;
            this.lastDragCall = -1L;
        }
        this.m_280310_(guiGraphics);
        this.m_239227_(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280618_();
        int scrollX = this.m_5756_();
        int maxScroll = this.m_93518_();
        if (maxScroll > 0) {
            int trackTop = this.f_93390_ + this.paddingTop;
            int trackBottom = this.f_93391_ - this.paddingTop;
            int viewH = trackBottom - trackTop;
            int thumbH = (int)((float)viewH * (float)viewH / ((float)viewH + (float)maxScroll));
            thumbH = Mth.m_14045_((int)thumbH, (int)32, (int)(viewH - 8));
            int thumbY = trackTop + (int)(this.m_93517_() * (double)(viewH - thumbH) / (double)maxScroll);
            GuiTexture scrollBarTex = this.f_93399_ ? this.widgetInfo.getTextureScrollBarActive() : this.widgetInfo.getTextureScrollBar();
            scrollBarTex.blit(guiGraphics, scrollX, thumbY, this.scrollBarWidth, thumbH);
        }
        RenderSystem.disableBlend();
    }

    protected void m_239227_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int i = this.m_5747_();
        int j = this.m_5759_();
        int k = this.f_93387_ - this.paddingTop;
        int l = this.m_5773_();
        for (int m = 0; m < l; ++m) {
            int n = this.m_7610_(m);
            int o = this.m_93485_(m);
            if (o < this.f_93390_ || n > this.f_93391_) continue;
            this.m_238964_(guiGraphics, mouseX, mouseY, partialTick, m, i, n, j, k);
        }
    }

    public void filterEntries(@NotNull Function<Map.Entry<String, String>, Boolean> filter) {
        this.m_93516_();
        this.entriesMap.clear();
        this.m_93410_(0.0);
        for (Map.Entry<String, String> entry : this.rawEntries.entrySet()) {
            if (!filter.apply(entry).booleanValue()) continue;
            CheckboxEntry checkboxEntry = new CheckboxEntry(entry.getKey(), (Component)Component.m_237113_((String)entry.getValue()), this.rawEntriesState.get(entry.getKey()));
            this.m_7085_(checkboxEntry);
            this.entriesMap.put(checkboxEntry.id, checkboxEntry);
        }
    }

    public void resetEntries(@NotNull Map<String, String> rawEntries, @NotNull List<String> selectedEntries) {
        this.m_93516_();
        this.entriesMap.clear();
        this.m_93410_(0.0);
        for (Map.Entry<String, String> entry : rawEntries.entrySet()) {
            CheckboxEntry checkboxEntry = new CheckboxEntry(entry.getKey(), (Component)Component.m_237113_((String)entry.getValue()), selectedEntries.contains(entry.getKey()));
            this.m_7085_(checkboxEntry);
            this.entriesMap.put(checkboxEntry.id, checkboxEntry);
        }
        this.rawEntries = rawEntries;
        this.rawEntriesState = new HashMap<String, Boolean>();
        for (String id : rawEntries.keySet()) {
            this.rawEntriesState.put(id, selectedEntries.contains(id));
        }
    }

    public void changeSelectedAll(boolean flag) {
        for (CheckboxEntry entry : this.m_6702_()) {
            entry.setSelected(flag);
        }
    }

    public boolean isAllSelected() {
        for (Map.Entry<String, Boolean> entry : this.rawEntriesState.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            return false;
        }
        return true;
    }

    public boolean isAllNotSelected() {
        for (Map.Entry<String, Boolean> entry : this.rawEntriesState.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public CheckboxEntry getEntry(@NotNull String id) {
        return this.entriesMap.get(id);
    }

    public List<CheckboxEntry> getSelectedEntries() {
        return this.m_6702_().stream().filter(it -> it.selected).toList();
    }

    public List<String> getSelectedEntriesId() {
        return this.m_6702_().stream().filter(it -> it.selected).map(it -> it.id).toList();
    }

    public List<String> getEntriesId() {
        return this.m_6702_().stream().map(it -> it.id).toList();
    }

    public void scrollTo(@NotNull CheckboxEntry entry) {
        int maxScroll = this.m_93518_();
        if (maxScroll <= 0) {
            return;
        }
        int idx = this.m_6702_().indexOf((Object)entry);
        if (idx < 0) {
            return;
        }
        double desired = (double)idx * (double)this.f_93387_;
        this.m_93410_(desired);
    }

    @Nullable
    protected CheckboxEntry getEntryAtPosition(double mouseX, double mouseY) {
        CheckboxEntry entry;
        int i = this.m_5759_() / 2;
        int j = this.f_93393_ + this.f_93388_ / 2;
        int k = j - i;
        int l = j + i;
        int m = Mth.m_14107_((double)(mouseY - (double)this.f_93390_)) - this.f_93395_ + (int)this.m_93517_() - 4;
        int n = m / this.f_93387_;
        CheckboxEntry checkboxEntry = entry = mouseX < (double)this.m_5756_() && mouseX >= (double)k && mouseX <= (double)l && n >= 0 && m >= 0 && n < this.m_5773_() ? (CheckboxEntry)((Object)this.m_6702_().get(n)) : null;
        if (entry == null) {
            return null;
        }
        if (!entry.isCheckboxHovered(mouseX, mouseY)) {
            return null;
        }
        return entry;
    }

    protected void m_93481_(double mouseX, double mouseY, int button) {
        super.m_93481_(mouseX, mouseY, button);
        if (this.f_93399_) {
            this.lastDragCall = System.currentTimeMillis();
        }
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.f_93399_) {
            this.lastDragCall = System.currentTimeMillis();
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.f_93399_ = false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    protected int m_5756_() {
        return this.f_93393_ + this.f_93388_ - (this.scrollBarWidth + 2) - this.paddingCheckbox;
    }

    public int m_5759_() {
        return this.f_93388_ - this.scrollBarWidth - this.paddingLeft * 2;
    }

    public int m_5747_() {
        return this.f_93393_ + this.paddingLeft;
    }

    protected int m_7610_(int index) {
        return this.f_93390_ + this.paddingTop - (int)this.m_93517_() + index * this.f_93387_ + this.f_93395_;
    }

    protected int m_93485_(int index) {
        return super.m_93485_(index) - this.paddingTop;
    }

    public void m_142291_(@NotNull NarrationElementOutput narrationElementOutput) {
    }

    public void setSelected(@Nullable CheckboxEntry entry) {
        if (entry == null) {
            return;
        }
        entry.setSelected(!entry.selected);
    }

    public void setSelected(@NotNull String id) {
        CheckboxEntry entry = this.getEntry(id);
        if (entry == null) {
            return;
        }
        this.setSelected(entry);
    }

    public void playSelectedSound(SoundManager handler) {
        handler.m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    public WidgetInfoCheckboxList getWidgetInfo() {
        return this.widgetInfo;
    }

    @Environment(value=EnvType.CLIENT)
    public class CheckboxEntry
    extends AbstractSelectionList.Entry<CheckboxEntry> {
        private final String id;
        private final Component label;
        private boolean selected;
        private GuiTexture checkboxTex;

        public CheckboxEntry(String id, Component label, boolean selected) {
            this.checkboxTex = CheckboxList.this.widgetInfo.getTextureCheckbox();
            this.id = id;
            this.label = label;
            this.selected = selected;
        }

        public void m_6311_(@NotNull GuiGraphics guiGraphics, int index, int top, int left, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovering, float fractionalTick) {
            if (this.selected) {
                this.checkboxTex = CheckboxList.this.widgetInfo.getTextureCheckboxHoveredSelected();
                if (!hovering || this.checkboxTex == null) {
                    this.checkboxTex = CheckboxList.this.widgetInfo.getTextureCheckboxSelected();
                }
            } else {
                this.checkboxTex = hovering ? CheckboxList.this.widgetInfo.getTextureCheckboxHovered() : CheckboxList.this.widgetInfo.getTextureCheckbox();
            }
            int iconX = CheckboxList.this.m_5747_() + CheckboxList.this.paddingCheckbox;
            int iconY = top + (rowHeight - this.checkboxTex.getHeight()) / 2;
            this.checkboxTex.blit(guiGraphics, iconX, iconY, this.checkboxTex.getWidth(), this.checkboxTex.getHeight());
            Font font = ((CheckboxList)CheckboxList.this).f_93386_.f_91062_;
            String text = this.label.getString();
            int textX = iconX + this.checkboxTex.getWidth() + CheckboxList.this.paddingCheckbox;
            Objects.requireNonNull(font);
            int textY = top + (rowHeight - 9) / 2;
            Objects.requireNonNull(font);
            int textMaxHeight = rowHeight - (rowHeight - 9) / 2;
            int textMaxWidth = rowWidth - (textX - CheckboxList.this.m_5747_()) - CheckboxList.this.paddingCheckbox;
            int color = CheckboxList.this.widgetInfo.getTextColor().toInt();
            CheckboxList.this.widgetInfo.getTextureEntry().blit(guiGraphics, textX, top, textMaxWidth, rowHeight);
            GuiHelper.renderScalableText(guiGraphics, font, text, color, textX + 4, textY, textMaxWidth - 8, textMaxHeight, true);
        }

        public void setSelected(boolean flag) {
            if (this.selected == flag) {
                return;
            }
            this.selected = flag;
            CheckboxList.this.rawEntriesState.put(this.id, this.selected);
            if (CheckboxList.this.onChanged != null) {
                CheckboxList.this.onChanged.accept(this);
            }
        }

        public boolean isCheckboxHovered(double mouseX, double mouseY) {
            int idx = CheckboxList.this.m_6702_().indexOf((Object)this);
            if (idx < 0) {
                return false;
            }
            int rowTop = CheckboxList.this.m_7610_(idx);
            int iconX = CheckboxList.this.m_5747_() + CheckboxList.this.paddingCheckbox;
            int iconY = rowTop + (CheckboxList.this.f_93387_ - this.checkboxTex.getHeight()) / 2;
            int iconW = this.checkboxTex.getWidth();
            int iconH = this.checkboxTex.getHeight();
            return mouseX >= (double)iconX && mouseX <= (double)(iconX + iconW) && mouseY >= (double)iconY && mouseY <= (double)(iconY + iconH);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (button == 0) {
                CheckboxList.this.playSelectedSound(Minecraft.m_91087_().m_91106_());
                return true;
            }
            return false;
        }

        public String getId() {
            return this.id;
        }

        public boolean isSelected() {
            return this.selected;
        }
    }
}

