/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.widgets.lists;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class DropDownListWidget
extends AbstractButton {
    private final int ITEM_HEIGHT = 12;
    private int visibleItems = 5;
    private final List<Component> items;
    private boolean expanded = false;
    private int selectedIndex = -1;
    private int scrollOffset = 0;
    private boolean draggingScrollbar = false;
    private int dragStartY = 0;
    private int initialScrollOffset = 0;
    private long startTextScrolling = -1L;
    private long elementScrollingText = -1L;
    private final Component defaultMessage;
    private final Consumer<Integer> responder;

    public DropDownListWidget(int x, int y, int width, int height, Component message, List<Component> items, int startIndex, Consumer<Integer> responder) {
        super(x, y, width, height, message);
        this.defaultMessage = message;
        this.items = items;
        this.responder = responder;
        this.setSelectedIndex(startIndex, false);
    }

    public DropDownListWidget(int x, int y, int width, int height, Component message, List<Component> items) {
        this(x, y, width, height, message, items, -1, null);
    }

    public void m_5691_() {
        this.expanded = !this.expanded;
    }

    protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_87963_(guiGraphics, mouseX, mouseY, partialTick);
        if (this.expanded) {
            int itemIndex;
            int dropdownX = this.m_252754_();
            int dropdownY = this.m_252907_() + this.m_93694_();
            int dropdownHeight = this.visibleItems * 12;
            guiGraphics.m_280509_(dropdownX, dropdownY, dropdownX + this.m_5711_(), dropdownY + dropdownHeight, -16777216);
            Minecraft mc = Minecraft.m_91087_();
            Font font = mc.f_91062_;
            int padding = 2;
            int availableWidth = this.items.size() > this.visibleItems ? this.m_5711_() - 12 : this.m_5711_() - 4;
            for (int i = 0; i < this.visibleItems && (itemIndex = i + this.scrollOffset) < this.items.size(); ++i) {
                boolean itemHovered;
                int itemY = dropdownY + i * 12;
                Component itemText = this.items.get(itemIndex);
                String text = itemText.getString();
                boolean bl = itemHovered = mouseX >= dropdownX && mouseX < dropdownX + this.m_5711_() && mouseY >= itemY && mouseY < itemY + 12;
                if (itemIndex == this.selectedIndex) {
                    int selectedBackgroundColor = -2144101889;
                    guiGraphics.m_280509_(dropdownX, itemY, dropdownX + this.m_5711_(), itemY + 12, selectedBackgroundColor);
                } else if (itemHovered) {
                    int hoveredBackgroundColor = -1070386381;
                    guiGraphics.m_280509_(dropdownX, itemY, dropdownX + this.m_5711_(), itemY + 12, hoveredBackgroundColor);
                }
                int textColor = itemIndex == this.selectedIndex ? -1 : -3355444;
                int textWidth = font.m_92895_(text);
                if (textWidth > availableWidth) {
                    if (itemHovered) {
                        if (this.startTextScrolling == -1L || this.elementScrollingText != (long)i) {
                            this.elementScrollingText = i;
                            this.startTextScrolling = System.currentTimeMillis();
                        }
                        int msPerPixel = 50;
                        int holdTimeStart = 1000;
                        int holdTimeEnd = 1000;
                        int extra = textWidth - availableWidth;
                        int scrollTime = extra * msPerPixel;
                        int cycleTime = holdTimeStart + scrollTime + holdTimeEnd;
                        long timePassed = System.currentTimeMillis() - this.startTextScrolling;
                        long t = timePassed % (long)cycleTime;
                        int offset = t < (long)holdTimeStart ? 0 : (t < (long)(holdTimeStart + scrollTime) ? (int)((float)(t - (long)holdTimeStart) / (float)msPerPixel) : extra);
                        guiGraphics.m_280588_(dropdownX + padding, itemY, dropdownX + padding + availableWidth, itemY + 12);
                        guiGraphics.m_280488_(font, text, dropdownX + padding - offset, itemY + 2, textColor);
                        guiGraphics.m_280618_();
                        continue;
                    }
                    if (this.elementScrollingText == (long)i) {
                        this.startTextScrolling = -1L;
                    }
                    String truncatedText = font.m_92834_(text, availableWidth);
                    guiGraphics.m_280488_(font, truncatedText, dropdownX + padding, itemY + 2, textColor);
                    continue;
                }
                guiGraphics.m_280137_(font, text, dropdownX + this.m_5711_() / 2, itemY + 2, textColor);
            }
            if (this.items.size() > this.visibleItems) {
                int scrollbarWidth = 8;
                int scrollbarX = dropdownX + this.m_5711_() - scrollbarWidth;
                int scrollbarHeight = dropdownHeight;
                guiGraphics.m_280509_(scrollbarX, dropdownY, scrollbarX + scrollbarWidth, dropdownY + scrollbarHeight, -12303292);
                int thumbHeight = Math.max(10, scrollbarHeight * this.visibleItems / this.items.size());
                int maxScroll = this.items.size() - this.visibleItems;
                int thumbY = dropdownY + (maxScroll == 0 ? 0 : this.scrollOffset * (scrollbarHeight - thumbHeight) / maxScroll);
                int thumbColor = this.draggingScrollbar ? -3355444 : -7829368;
                guiGraphics.m_280509_(scrollbarX, thumbY, scrollbarX + scrollbarWidth, thumbY + thumbHeight, thumbColor);
            }
        }
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingScrollbar) {
            int scrollbarHeight = this.visibleItems * 12;
            int thumbHeight = Math.max(10, scrollbarHeight * this.visibleItems / this.items.size());
            int maxScroll = this.items.size() - this.visibleItems;
            int availableTrack = scrollbarHeight - thumbHeight;
            int deltaY = (int)(mouseY - (double)this.dragStartY);
            int initialThumbPos = (int)((float)(this.initialScrollOffset * availableTrack) / (float)maxScroll);
            int newThumbPos = initialThumbPos + deltaY;
            int newScrollOffset = (int)((float)(newThumbPos * maxScroll) / (float)availableTrack);
            this.scrollOffset = Mth.m_14045_((int)newScrollOffset, (int)0, (int)maxScroll);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.draggingScrollbar) {
            this.draggingScrollbar = false;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean dropdownClicked;
        if (!this.f_93623_ || !this.f_93624_) {
            return false;
        }
        int dropdownX = this.m_252754_();
        int dropdownY = this.m_252907_() + this.m_93694_();
        int dropdownWidth = this.m_5711_();
        int dropdownHeight = this.visibleItems * 12;
        if (this.expanded && this.items.size() > this.visibleItems) {
            int scrollbarWidth = 8;
            int scrollbarX = dropdownX + this.m_5711_() - scrollbarWidth - 2;
            int thumbHeight = Math.max(10, dropdownHeight * this.visibleItems / this.items.size());
            int maxScroll = this.items.size() - this.visibleItems;
            int thumbY = dropdownY + (maxScroll == 0 ? 0 : this.scrollOffset * (dropdownHeight - thumbHeight) / maxScroll);
            if (mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + scrollbarWidth) && mouseY >= (double)thumbY && mouseY <= (double)(thumbY + thumbHeight)) {
                this.draggingScrollbar = true;
                this.dragStartY = (int)mouseY;
                this.initialScrollOffset = this.scrollOffset;
                return true;
            }
        }
        boolean buttonClicked = this.m_93680_(mouseX, mouseY);
        boolean bl = dropdownClicked = this.expanded && mouseX >= (double)dropdownX && mouseX <= (double)(dropdownX + dropdownWidth) && mouseY >= (double)dropdownY && mouseY <= (double)(dropdownY + dropdownHeight);
        if (buttonClicked) {
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            this.expanded = !this.expanded;
            return true;
        }
        if (dropdownClicked) {
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            int clickedIndex = (int)((mouseY - (double)dropdownY) / 12.0) + this.scrollOffset;
            if (clickedIndex < this.items.size()) {
                this.setSelectedIndex(clickedIndex, true);
            }
            this.expanded = false;
            return true;
        }
        if (this.expanded) {
            this.expanded = false;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        if (this.expanded && this.items.size() > this.visibleItems) {
            this.scrollOffset = (int)Mth.m_14008_((double)((double)this.scrollOffset - scrollDelta), (double)0.0, (double)(this.items.size() - this.visibleItems));
            return true;
        }
        return false;
    }

    public void setSelectedIndex(int selectedIndex, boolean useResponder) {
        this.selectedIndex = selectedIndex;
        this.m_93666_(this.getSelectedItem());
        if (selectedIndex >= 0) {
            this.m_257544_(Tooltip.m_257550_((Component)this.defaultMessage));
            if (this.responder != null && useResponder) {
                this.responder.accept(selectedIndex);
            }
        } else {
            this.m_257544_(null);
        }
    }

    public Component getSelectedItem() {
        return this.selectedIndex >= 0 && this.selectedIndex < this.items.size() ? this.items.get(this.selectedIndex) : this.defaultMessage;
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237110_((String)"narration.dropdown.title", (Object[])new Object[]{this.m_6035_()}));
    }

    public static Builder builder(@NotNull List<Component> items) {
        return new Builder(items);
    }

    public void setVisibleItems(int visibleItems) {
        this.visibleItems = visibleItems;
    }

    public List<Component> getItems() {
        return this.items;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public boolean isDraggingScrollbar() {
        return this.draggingScrollbar;
    }

    public static class Builder {
        private int x = 0;
        private int y = 0;
        private int width = 50;
        private int height = 15;
        private List<Component> items;
        private int visibleItems = 5;
        private int startIndex = -1;
        private Component message = Component.m_237113_((String)"Select");
        private Consumer<Integer> responder = null;

        public Builder(@NotNull List<Component> items) {
            this.items = items;
        }

        public Builder pos(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public DropDownListWidget build() {
            DropDownListWidget out = new DropDownListWidget(this.x, this.y, this.width, this.height, this.message, this.items, this.startIndex, this.responder);
            out.setVisibleItems(this.visibleItems);
            return out;
        }

        public Builder setVisibleItems(int visibleItems) {
            this.visibleItems = visibleItems;
            return this;
        }

        public Builder setStartIndex(int startIndex) {
            this.startIndex = startIndex;
            return this;
        }

        public Builder setMessage(Component message) {
            this.message = message;
            return this;
        }

        public Builder setResponder(Consumer<Integer> responder) {
            this.responder = responder;
            return this;
        }
    }
}

