/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.widgets.lists;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.client.gui.GuiTexture;
import me.phoenixra.visor.api.client.gui.helpers.GuiHelper;
import me.phoenixra.visor.api.client.gui.overlays.framework.VROverlayScreen;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoButtonImaged;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoSelectionList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TexturedSelectionList
extends AbstractSelectionList<TexturedEntry> {
    private final WidgetInfoSelectionList widgetInfo;
    private final int paddingTop;
    private final int paddingLeft;
    private final int scrollBarWidth;
    private final Consumer<TexturedEntry> onSelected;
    private final Map<String, TexturedEntry> entriesMap = new HashMap<String, TexturedEntry>();
    private Map<String, String> rawEntries;
    private long lastDragCall = -1L;
    @Nullable
    private Tooltip tooltip;
    private int tooltipMsDelay = 0;
    private long hoverOrFocusedStartTime;
    private boolean wasHoveredOrFocused;
    @Nullable
    private String tooltipEntryIdForTimer;
    private Screen visor$attachedTo;

    public TexturedSelectionList(@NotNull WidgetInfoSelectionList widgetInfo, @NotNull Map<String, String> rawEntries, @NotNull Consumer<TexturedEntry> onSelected) {
        super(Minecraft.m_91087_(), widgetInfo.getWidth(), widgetInfo.getHeight(), widgetInfo.getY(), widgetInfo.getY() + widgetInfo.getHeight(), widgetInfo.getEntryHeight());
        this.widgetInfo = widgetInfo;
        this.paddingTop = widgetInfo.getPaddingTop();
        this.paddingLeft = widgetInfo.getPaddingLeft();
        this.scrollBarWidth = widgetInfo.getScrollBarWidth();
        this.onSelected = onSelected;
        this.m_93507_(widgetInfo.getX());
        this.m_93496_(false);
        this.m_93488_(false);
        this.m_93471_(false);
        this.resetEntries(rawEntries);
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        TexturedEntry texturedEntry = this.f_168789_ = this.m_5953_(mouseX, mouseY) ? (TexturedEntry)this.m_93412_(mouseX, mouseY) : null;
        if (this.f_93399_ && this.lastDragCall + 200L < System.currentTimeMillis()) {
            this.f_93399_ = false;
            this.lastDragCall = -1L;
        }
        this.m_280310_(guiGraphics);
        this.m_239227_(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280618_();
        int scrollX = this.m_5756_();
        int maxScroll = this.m_93518_();
        if (maxScroll > 0) {
            int trackTop = this.f_93390_ + this.paddingTop;
            int trackBottom = this.f_93391_ - this.paddingTop;
            int viewH = trackBottom - trackTop;
            int thumbH = (int)((float)viewH * (float)viewH / ((float)viewH + (float)maxScroll));
            thumbH = Mth.m_14045_((int)thumbH, (int)32, (int)(viewH - 8));
            int thumbY = trackTop + (int)(this.m_93517_() * (double)(viewH - thumbH) / (double)maxScroll);
            GuiTexture scrollBarTex = this.f_93399_ ? this.widgetInfo.getTextureScrollBarActive() : this.widgetInfo.getTextureScrollBar();
            scrollBarTex.blit(guiGraphics, scrollX, thumbY, this.scrollBarWidth, thumbH);
        }
        this.updateTooltip();
        RenderSystem.disableBlend();
    }

    protected void m_239227_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int i = this.m_5747_();
        int j = this.m_5759_();
        int k = this.f_93387_ - this.paddingTop;
        int l = this.m_5773_();
        for (int m = 0; m < l; ++m) {
            int n = this.m_7610_(m);
            int o = this.m_93485_(m);
            if (o < this.f_93390_ || n > this.f_93391_) continue;
            this.m_238964_(guiGraphics, mouseX, mouseY, partialTick, m, i, n, j, k);
        }
    }

    private void updateTooltip() {
        boolean stateChanged;
        Function<String, Component> factory = this.widgetInfo.getTooltip();
        if (factory == null) {
            return;
        }
        TexturedEntry entryForTooltip = (TexturedEntry)this.f_168789_;
        boolean hasTarget = entryForTooltip != null;
        String newId = hasTarget ? entryForTooltip.getId() : null;
        boolean bl = stateChanged = hasTarget != this.wasHoveredOrFocused || !Objects.equals(this.tooltipEntryIdForTimer, newId);
        if (stateChanged) {
            if (hasTarget) {
                this.hoverOrFocusedStartTime = Util.m_137550_();
            }
            this.wasHoveredOrFocused = hasTarget;
            this.tooltipEntryIdForTimer = newId;
        }
        if (!hasTarget) {
            return;
        }
        if (Util.m_137550_() - this.hoverOrFocusedStartTime <= (long)this.tooltipMsDelay) {
            return;
        }
        Component tipText = factory.apply(newId);
        if (tipText == null) {
            return;
        }
        this.tooltip = Tooltip.m_257550_((Component)tipText);
        Screen screen = this.getAttachedTo();
        if (screen != null) {
            screen.m_262791_(this.tooltip, DefaultTooltipPositioner.f_262752_, false);
        }
    }

    private Screen getAttachedTo() {
        if (this.visor$attachedTo == null) {
            if (VisorAPI.clientState().stateMode().isNotActive()) {
                this.visor$attachedTo = Minecraft.m_91087_().f_91080_;
                return this.visor$attachedTo;
            }
            VROverlayScreen overlay = VisorAPI.client().getGuiManager().getCursorHandler().getFocusedOverlayScreen();
            this.visor$attachedTo = overlay != null ? overlay : Minecraft.m_91087_().f_91080_;
            return this.visor$attachedTo;
        }
        return this.visor$attachedTo;
    }

    public void filterEntries(@NotNull Function<Map.Entry<String, String>, Boolean> filter) {
        this.m_93516_();
        this.entriesMap.clear();
        this.m_93410_(0.0);
        for (Map.Entry<String, String> entry : this.rawEntries.entrySet()) {
            if (!filter.apply(entry).booleanValue()) continue;
            TexturedEntry texturedEntry = new TexturedEntry(entry.getKey(), (Component)Component.m_237113_((String)entry.getValue()));
            this.m_7085_(texturedEntry);
            this.entriesMap.put(texturedEntry.id, texturedEntry);
        }
    }

    public void resetEntries(@NotNull Map<String, String> rawEntries) {
        this.m_93516_();
        this.entriesMap.clear();
        this.m_93410_(0.0);
        for (Map.Entry<String, String> entry : rawEntries.entrySet()) {
            TexturedEntry texturedEntry = new TexturedEntry(entry.getKey(), (Component)Component.m_237113_((String)entry.getValue()));
            this.m_7085_(texturedEntry);
            this.entriesMap.put(texturedEntry.id, texturedEntry);
        }
        this.rawEntries = rawEntries;
    }

    public void renameEntry(String id, Component newLabel) {
        TexturedEntry entry;
        if (this.rawEntries != null && this.rawEntries.containsKey(id)) {
            this.rawEntries.put(id, newLabel.getString());
        }
        if ((entry = this.entriesMap.get(id)) == null) {
            return;
        }
        entry.label = newLabel;
    }

    @Nullable
    public TexturedEntry getEntry(@NotNull String id) {
        return this.entriesMap.get(id);
    }

    public void scrollTo(@NotNull TexturedEntry entry) {
        int maxScroll = this.m_93518_();
        if (maxScroll <= 0) {
            return;
        }
        int idx = this.m_6702_().indexOf((Object)entry);
        if (idx < 0) {
            return;
        }
        double desired = (double)idx * (double)this.f_93387_;
        this.m_93410_(desired);
    }

    protected void m_93481_(double mouseX, double mouseY, int button) {
        super.m_93481_(mouseX, mouseY, button);
        if (this.f_93399_) {
            this.lastDragCall = System.currentTimeMillis();
        }
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.f_93399_) {
            this.lastDragCall = System.currentTimeMillis();
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.f_93399_ = false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    protected int m_5756_() {
        return this.f_93393_ + this.f_93388_ - (this.scrollBarWidth + 2);
    }

    public int m_5759_() {
        return this.f_93388_ - this.scrollBarWidth - this.paddingLeft * 2;
    }

    public int m_5747_() {
        return this.f_93393_ + this.paddingLeft;
    }

    protected int m_7610_(int index) {
        return this.f_93390_ + this.paddingTop - (int)this.m_93517_() + index * this.f_93387_ + this.f_93395_;
    }

    protected int m_93485_(int index) {
        return super.m_93485_(index) - this.paddingTop;
    }

    public void m_142291_(@NotNull NarrationElementOutput narrationElementOutput) {
    }

    public void setSelected(@Nullable TexturedEntry selected) {
        if (selected != this.m_93511_()) {
            this.onSelected.accept(selected);
        } else if (this.widgetInfo.isSupportDeselection() && selected != null) {
            this.playSelectedSound(Minecraft.m_91087_().m_91106_());
            this.onSelected.accept(null);
            super.m_6987_(null);
            return;
        }
        super.m_6987_((AbstractSelectionList.Entry)selected);
    }

    public void setSelected(@NotNull String id) {
        TexturedEntry entry = this.getEntry(id);
        if (entry == null) {
            return;
        }
        this.setSelected(entry);
    }

    public void playSelectedSound(SoundManager handler) {
        handler.m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    public WidgetInfoSelectionList getWidgetInfo() {
        return this.widgetInfo;
    }

    @Environment(value=EnvType.CLIENT)
    public class TexturedEntry
    extends AbstractSelectionList.Entry<TexturedEntry> {
        private final String id;
        private Component label;

        public TexturedEntry(String id, Component label) {
            this.id = id;
            this.label = label;
        }

        public void m_274437_(@NotNull GuiGraphics guiGraphics, int index, int top, int left, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovering, float fractionalTick) {
            GuiTexture texture;
            WidgetInfoButtonImaged entryInfo = TexturedSelectionList.this.widgetInfo.getEntryButton();
            entryInfo.pos(TexturedSelectionList.this.m_5747_(), top).size(TexturedSelectionList.this.m_5759_(), rowHeight);
            boolean selected = Objects.equals(TexturedSelectionList.this.m_93511_(), (Object)this);
            if (selected) {
                texture = entryInfo.getTextureHoveredSelected();
                if (!hovering || texture == null) {
                    texture = entryInfo.getTextureSelected();
                }
            } else {
                texture = hovering ? entryInfo.getTextureHovered() : entryInfo.getTexture();
            }
            if (texture == null) {
                texture = entryInfo.getTexture();
            }
            texture.blit(guiGraphics, TexturedSelectionList.this.m_5747_(), top, TexturedSelectionList.this.m_5759_(), rowHeight);
            entryInfo.drawHighlight(guiGraphics, true, hovering, selected);
        }

        public void m_6311_(@NotNull GuiGraphics guiGraphics, int index, int top, int left, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovering, float fractionalTick) {
            Font font = ((TexturedSelectionList)TexturedSelectionList.this).f_93386_.f_91062_;
            String text = this.label.getString();
            int startX = TexturedSelectionList.this.m_5747_() + 4;
            int textWidth = TexturedSelectionList.this.m_5759_() - 8;
            int color = TexturedSelectionList.this.widgetInfo.getTextColor().toInt();
            GuiHelper.renderScalableText(guiGraphics, font, text, color, startX, top, textWidth, rowHeight, true);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (button == 0) {
                if (this != TexturedSelectionList.this.m_93511_()) {
                    TexturedSelectionList.this.playSelectedSound(Minecraft.m_91087_().m_91106_());
                }
                return true;
            }
            return false;
        }

        public String getId() {
            return this.id;
        }
    }
}

