/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.widgets.sets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.phoenixra.atumconfig.api.tuples.PairRecord;
import me.phoenixra.visor.api.client.gui.widgets.ButtonImaged;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoButtonImaged;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoCheckboxList;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoEditBox;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoImage;
import me.phoenixra.visor.api.client.gui.widgets.lists.FilterListType;
import me.phoenixra.visor.api.client.gui.widgets.sets.DynamicWidgetSet;
import me.phoenixra.visor.api.client.gui.widgets.sets.FilterListWidgetSet;
import me.phoenixra.visor.api.client.gui.widgets.sets.FiltersListWidgetSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilterListBinaryWidgetSet<T>
extends DynamicWidgetSet
implements FilterListWidgetSet<T> {
    private final Minecraft mc = Minecraft.m_91087_();
    private final WidgetInfoEditBox searchBoxInfo;
    private final WidgetInfoButtonImaged checkboxAllInfo;
    private final WidgetInfoCheckboxList listInfo;
    private final FilterListType typeFirst;
    private final FilterListType typeSecond;
    private final WidgetInfoImage backgroundInfoFirst;
    private final WidgetInfoButtonImaged buttonInfoFirst;
    private final WidgetInfoImage backgroundInfoSecond;
    private final WidgetInfoButtonImaged buttonInfoSecond;
    private final Map<String, String> rawEntriesFirst;
    private final Supplier<List<String>> selectedSupplierFirst;
    private final Map<String, Function<T, Boolean>> filtersMapFirst;
    private final Map<String, String> rawEntriesSecond;
    private final Supplier<List<String>> selectedSupplierSecond;
    private final Map<String, Function<T, Boolean>> filtersMapSecond;
    private FiltersListWidgetSet<T> filtersWidgetFirst;
    private FiltersListWidgetSet<T> filtersWidgetSecond;
    private ButtonImaged buttonFirst;
    private ButtonImaged buttonSecond;

    private FilterListBinaryWidgetSet(Builder<T> builder) {
        super(builder.onWidgetsChanged);
        this.searchBoxInfo = builder.searchBoxInfo;
        this.checkboxAllInfo = builder.checkboxAllInfo;
        this.listInfo = builder.listInfo;
        this.typeFirst = builder.typeFirst;
        this.typeSecond = builder.typeSecond;
        this.backgroundInfoFirst = builder.backgroundInfoFirst;
        this.buttonInfoFirst = builder.buttonInfoFirst;
        this.rawEntriesFirst = builder.rawEntriesFirst;
        this.filtersMapFirst = builder.filtersMapFirst;
        this.selectedSupplierFirst = builder.selectedSupplierFirst;
        this.backgroundInfoSecond = builder.backgroundInfoSecond;
        this.buttonInfoSecond = builder.buttonInfoSecond;
        this.rawEntriesSecond = builder.rawEntriesSecond;
        this.filtersMapSecond = builder.filtersMapSecond;
        this.selectedSupplierSecond = builder.selectedSupplierSecond;
    }

    @Override
    public void onPreRender(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.buttonFirst.isSelected()) {
            this.filtersWidgetFirst.onPreRender(guiGraphics, mouseX, mouseY, partialTicks);
        } else {
            this.filtersWidgetSecond.onPreRender(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void onTick() {
        if (this.buttonFirst.isSelected()) {
            this.filtersWidgetFirst.onTick();
        } else {
            this.filtersWidgetSecond.onTick();
        }
    }

    public <W extends GuiEventListener & Renderable> List<W> initWidgets() {
        this.filtersWidgetFirst = new FiltersListWidgetSet.Builder<T>(this.typeFirst, this.listInfo, this.rawEntriesFirst, this.filtersMapFirst, this.selectedSupplierFirst).background(this.backgroundInfoFirst).checkboxAll(this.checkboxAllInfo).searchBox(this.searchBoxInfo).build();
        this.buttonFirst = new ButtonImaged(this.buttonInfoFirst, it -> this.changeActiveFilterList(true));
        this.filtersWidgetSecond = new FiltersListWidgetSet.Builder<T>(this.typeSecond, this.listInfo, this.rawEntriesSecond, this.filtersMapSecond, this.selectedSupplierSecond).background(this.backgroundInfoSecond).checkboxAll(this.checkboxAllInfo).searchBox(this.searchBoxInfo).build();
        this.buttonSecond = new ButtonImaged(this.buttonInfoSecond, it -> this.changeActiveFilterList(false));
        this.buttonFirst.setSelected(true);
        this.filtersWidgetFirst.initWidgets();
        this.filtersWidgetSecond.initWidgets();
        return this.getWidgets();
    }

    public <W extends GuiEventListener & Renderable> List<W> getWidgets() {
        ArrayList<Object> widgets = new ArrayList<Object>();
        widgets.addAll(this.getActiveFiltersWidget().getWidgets());
        widgets.add((Object)this.buttonFirst);
        widgets.add((Object)this.buttonSecond);
        return widgets;
    }

    public void changeActiveFilterList(boolean useFirst) {
        if (useFirst && this.buttonFirst.isSelected()) {
            return;
        }
        if (useFirst) {
            this.buttonFirst.setSelected(true);
            this.buttonSecond.setSelected(false);
        } else {
            this.buttonFirst.setSelected(false);
            this.buttonSecond.setSelected(true);
        }
        this.widgetsChanged();
    }

    public FiltersListWidgetSet<T> getActiveFiltersWidget() {
        return this.buttonFirst.isSelected() ? this.filtersWidgetFirst : this.filtersWidgetSecond;
    }

    @Override
    public void setOnFilterChanged(@NotNull Consumer<PairRecord<String, Boolean>> consumer) {
        this.filtersWidgetFirst.setOnFilterChanged(consumer);
        this.filtersWidgetSecond.setOnFilterChanged(consumer);
    }

    @Override
    @NotNull
    public Collection<String> getFilterIds() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.filtersWidgetFirst.getFilterIds());
        list.addAll(this.filtersWidgetSecond.getFilterIds());
        return list;
    }

    @Override
    @NotNull
    public Collection<String> getActiveFilterIds() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.filtersWidgetFirst.getActiveFilterIds());
        list.addAll(this.filtersWidgetSecond.getActiveFilterIds());
        return list;
    }

    @Override
    @NotNull
    public Collection<Function<T, Boolean>> getActiveFilters() {
        ArrayList<Function<T, Boolean>> list = new ArrayList<Function<T, Boolean>>();
        list.addAll(this.filtersWidgetFirst.getActiveFilters());
        list.addAll(this.filtersWidgetSecond.getActiveFilters());
        return list;
    }

    @Override
    @NotNull
    public Collection<Function<T, Boolean>> getAllFilters() {
        ArrayList<Function<T, Boolean>> list = new ArrayList<Function<T, Boolean>>();
        list.addAll(this.filtersWidgetFirst.getAllFilters());
        list.addAll(this.filtersWidgetSecond.getAllFilters());
        return list;
    }

    @Override
    public boolean filter(@NotNull T item) {
        if (!this.filtersWidgetFirst.filter(item)) {
            return false;
        }
        return this.filtersWidgetSecond.filter(item);
    }

    @Override
    @NotNull
    public FilterListType getType() {
        return this.buttonFirst.isSelected() ? this.typeFirst : this.typeSecond;
    }

    public FilterListType getTypeFirst() {
        return this.typeFirst;
    }

    public FilterListType getTypeSecond() {
        return this.typeSecond;
    }

    public FiltersListWidgetSet<T> getFiltersWidgetFirst() {
        return this.filtersWidgetFirst;
    }

    public FiltersListWidgetSet<T> getFiltersWidgetSecond() {
        return this.filtersWidgetSecond;
    }

    public static class Builder<T> {
        private WidgetInfoEditBox searchBoxInfo;
        private WidgetInfoButtonImaged checkboxAllInfo;
        private final WidgetInfoCheckboxList listInfo;
        private final Runnable onWidgetsChanged;
        private FilterListType typeFirst;
        private WidgetInfoImage backgroundInfoFirst;
        private WidgetInfoButtonImaged buttonInfoFirst;
        private Map<String, String> rawEntriesFirst;
        private Map<String, Function<T, Boolean>> filtersMapFirst;
        private Supplier<List<String>> selectedSupplierFirst;
        private FilterListType typeSecond;
        private WidgetInfoImage backgroundInfoSecond;
        private WidgetInfoButtonImaged buttonInfoSecond;
        private Map<String, String> rawEntriesSecond;
        private Map<String, Function<T, Boolean>> filtersMapSecond;
        private Supplier<List<String>> selectedSupplierSecond;

        public Builder(@NotNull WidgetInfoCheckboxList listInfo, @NotNull Runnable onWidgetsChanged) {
            this.listInfo = listInfo;
            this.onWidgetsChanged = onWidgetsChanged;
        }

        public Builder<T> first(@NotNull FilterListType type, @Nullable WidgetInfoImage backgroundInfo, @NotNull WidgetInfoButtonImaged buttonInfo, @NotNull Map<String, String> rawEntries, @NotNull Map<String, Function<T, Boolean>> filtersMap, @NotNull Supplier<List<String>> selectedSupplier) {
            this.typeFirst = type;
            this.backgroundInfoFirst = backgroundInfo;
            this.buttonInfoFirst = buttonInfo;
            this.rawEntriesFirst = rawEntries;
            this.filtersMapFirst = filtersMap;
            this.selectedSupplierFirst = selectedSupplier;
            return this;
        }

        public Builder<T> second(@NotNull FilterListType type, @Nullable WidgetInfoImage backgroundInfo, @NotNull WidgetInfoButtonImaged buttonInfo, @NotNull Map<String, String> rawEntries, @NotNull Map<String, Function<T, Boolean>> filtersMap, @NotNull Supplier<List<String>> selectedSupplier) {
            this.typeSecond = type;
            this.backgroundInfoSecond = backgroundInfo;
            this.buttonInfoSecond = buttonInfo;
            this.rawEntriesSecond = rawEntries;
            this.filtersMapSecond = filtersMap;
            this.selectedSupplierSecond = selectedSupplier;
            return this;
        }

        public Builder<T> searchBox(@Nullable WidgetInfoEditBox searchBoxInfo) {
            this.searchBoxInfo = searchBoxInfo;
            return this;
        }

        public Builder<T> checkboxAll(@Nullable WidgetInfoButtonImaged checkboxAllInfo) {
            this.checkboxAllInfo = checkboxAllInfo;
            return this;
        }

        public FilterListBinaryWidgetSet<T> build() {
            if (this.buttonInfoFirst == null) {
                throw new IllegalArgumentException("first() filter widget set not specified");
            }
            if (this.buttonInfoSecond == null) {
                throw new IllegalArgumentException("second() filter widget set not specified");
            }
            return new FilterListBinaryWidgetSet(this);
        }
    }
}

