/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.widgets.sets;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.phoenixra.atumconfig.api.tuples.PairRecord;
import me.phoenixra.visor.api.client.gui.GuiTexture;
import me.phoenixra.visor.api.client.gui.widgets.ButtonImaged;
import me.phoenixra.visor.api.client.gui.widgets.EditBoxImage;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoButtonImaged;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoCheckboxList;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoEditBox;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoImage;
import me.phoenixra.visor.api.client.gui.widgets.lists.CheckboxList;
import me.phoenixra.visor.api.client.gui.widgets.lists.FilterListType;
import me.phoenixra.visor.api.client.gui.widgets.sets.FilterListWidgetSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FiltersListWidgetSet<T>
implements FilterListWidgetSet<T> {
    private final Minecraft mc = Minecraft.m_91087_();
    private final FilterListType type;
    private final WidgetInfoImage backgroundInfo;
    private final WidgetInfoEditBox searchBoxInfo;
    private final WidgetInfoButtonImaged checkboxAllInfo;
    private final WidgetInfoCheckboxList listInfo;
    private final Map<String, String> rawEntries;
    private final Map<String, Function<T, Boolean>> filtersMap;
    private final Supplier<List<String>> selectedSupplier;
    private Consumer<PairRecord<String, Boolean>> onFilterChanged;
    private EditBoxImage searchBox;
    private ButtonImaged checkboxAll;
    private CheckboxList list;
    private boolean updateCheckBox;

    private FiltersListWidgetSet(Builder<T> builder) {
        this.type = builder.type;
        this.backgroundInfo = builder.backgroundInfo;
        this.searchBoxInfo = builder.searchBoxInfo;
        this.checkboxAllInfo = builder.checkboxAllInfo;
        this.listInfo = builder.listInfo;
        this.rawEntries = builder.rawEntries;
        this.selectedSupplier = builder.selectedSupplier;
        this.filtersMap = builder.filtersMap;
    }

    @Override
    public void onPreRender(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.backgroundInfo != null) {
            GuiTexture texture = this.backgroundInfo.getTexture();
            texture.blit(guiGraphics, this.backgroundInfo.getX(), this.backgroundInfo.getY(), this.backgroundInfo.getWidth(), this.backgroundInfo.getHeight());
        }
        if (this.checkboxAll != null && this.updateCheckBox) {
            this.updateCheckBox = false;
            if (this.list.isAllSelected()) {
                this.checkboxAll.setSelected(true);
            } else if (this.list.isAllNotSelected()) {
                this.checkboxAll.setSelected(false);
            }
        }
    }

    @Override
    public void onTick() {
        if (this.searchBox != null) {
            this.searchBox.m_94120_();
        }
    }

    public <W extends GuiEventListener & Renderable> List<W> initWidgets() {
        if (this.checkboxAllInfo != null) {
            this.checkboxAll = new ButtonImaged(this.checkboxAllInfo, button -> {
                button.setSelected(!button.isSelected());
                this.list.changeSelectedAll(button.isSelected());
            });
        }
        if (this.searchBoxInfo != null) {
            this.searchBox = new EditBoxImage(this.searchBoxInfo);
            this.searchBox.m_94151_(this::applySearchFilter);
        }
        this.list = new CheckboxList(this.listInfo, this.rawEntries, this.selectedSupplier.get(), it -> {
            this.updateCheckBox = true;
            if (this.onFilterChanged != null) {
                this.onFilterChanged.accept(new PairRecord<String, Boolean>(it.getId(), it.isSelected()));
            }
        });
        if (this.checkboxAll != null) {
            if (this.list.isAllSelected()) {
                this.checkboxAll.setSelected(true);
            } else if (this.list.isAllNotSelected()) {
                this.checkboxAll.setSelected(false);
            }
        }
        return this.getWidgets();
    }

    public <W extends GuiEventListener & Renderable> List<W> getWidgets() {
        ArrayList<Object> widgets = new ArrayList<Object>();
        widgets.add((Object)this.list);
        if (this.searchBox != null) {
            widgets.add((Object)this.searchBox);
        }
        if (this.checkboxAll != null) {
            widgets.add((Object)this.checkboxAll);
        }
        return widgets;
    }

    private void applySearchFilter(String filterText) {
        String normalizedFilter = this.normalizeText(filterText);
        if (normalizedFilter.isEmpty()) {
            this.list.filterEntries(it -> true);
        } else {
            this.list.filterEntries(entry -> {
                String value = (String)entry.getValue();
                return value != null && this.normalizeText(value).contains(normalizedFilter);
            });
        }
    }

    private String normalizeText(String input) {
        if (input == null) {
            return "";
        }
        String noAccents = Normalizer.normalize(input, Normalizer.Form.NFD).replaceAll("\\p{M}", "");
        return noAccents.toLowerCase(Locale.ROOT).trim();
    }

    @Override
    public boolean filter(@NotNull T item) {
        if (this.type == FilterListType.ALL) {
            for (Function<T, Boolean> entry : this.getActiveFilters()) {
                if (entry.apply(item).booleanValue()) continue;
                return false;
            }
            return true;
        }
        for (Function<T, Boolean> entry : this.getActiveFilters()) {
            if (!entry.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Collection<String> getFilterIds() {
        return this.filtersMap.keySet();
    }

    @Override
    @NotNull
    public Collection<String> getActiveFilterIds() {
        return this.list.getSelectedEntriesId();
    }

    @Override
    @NotNull
    public Collection<Function<T, Boolean>> getActiveFilters() {
        List<String> selected = this.list.getSelectedEntriesId();
        return this.filtersMap.entrySet().stream().filter(it -> selected.contains(it.getKey())).map(Map.Entry::getValue).toList();
    }

    @Override
    @NotNull
    public Collection<Function<T, Boolean>> getAllFilters() {
        return this.filtersMap.values();
    }

    @Override
    public FilterListType getType() {
        return this.type;
    }

    @Override
    public void setOnFilterChanged(Consumer<PairRecord<String, Boolean>> onFilterChanged) {
        this.onFilterChanged = onFilterChanged;
    }

    public CheckboxList getList() {
        return this.list;
    }

    public static class Builder<T> {
        private final FilterListType type;
        private WidgetInfoImage backgroundInfo;
        private WidgetInfoEditBox searchBoxInfo;
        private WidgetInfoButtonImaged checkboxAllInfo;
        private WidgetInfoCheckboxList listInfo;
        private final Map<String, String> rawEntries;
        private final Map<String, Function<T, Boolean>> filtersMap;
        private final Supplier<List<String>> selectedSupplier;

        public Builder(@NotNull FilterListType type, @NotNull WidgetInfoCheckboxList listInfo, @NotNull Map<String, String> rawEntries, @NotNull Map<String, Function<T, Boolean>> filtersMap, @NotNull Supplier<List<String>> selectedSupplier) {
            this.type = type;
            this.listInfo = listInfo;
            this.rawEntries = rawEntries;
            this.selectedSupplier = selectedSupplier;
            this.filtersMap = filtersMap;
        }

        public Builder<T> background(@Nullable WidgetInfoImage backgroundInfo) {
            this.backgroundInfo = backgroundInfo;
            return this;
        }

        public Builder<T> searchBox(@Nullable WidgetInfoEditBox searchBoxInfo) {
            this.searchBoxInfo = searchBoxInfo;
            return this;
        }

        public Builder<T> checkboxAll(@Nullable WidgetInfoButtonImaged checkboxAllInfo) {
            this.checkboxAllInfo = checkboxAllInfo;
            return this;
        }

        public FiltersListWidgetSet<T> build() {
            return new FiltersListWidgetSet(this);
        }
    }
}

