/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.widgets.sets;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import me.phoenixra.visor.api.client.gui.widgets.ButtonImaged;
import me.phoenixra.visor.api.client.gui.widgets.EditBoxImage;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoButtonImaged;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoEditBox;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoSelectionList;
import me.phoenixra.visor.api.client.gui.widgets.lists.TexturedSelectionList;
import me.phoenixra.visor.api.client.gui.widgets.sets.DynamicWidgetSet;
import me.phoenixra.visor.api.client.gui.widgets.sets.FilterListWidgetSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import org.jetbrains.annotations.NotNull;

public class SearchableListWidgetSet
extends DynamicWidgetSet {
    private final Minecraft mc = Minecraft.m_91087_();
    private final WidgetInfoSelectionList listInfo;
    private final WidgetInfoButtonImaged filterInfo;
    private final WidgetInfoEditBox searchBoxInfo;
    private final FilterListWidgetSet<String> filterWidgetSet;
    private final Map<String, String> rawEntries;
    private final Consumer<TexturedSelectionList.TexturedEntry> onSelected;
    private ButtonImaged filterButton;
    private EditBoxImage searchBox;
    private TexturedSelectionList list;

    private SearchableListWidgetSet(Builder builder) {
        super(builder.onWidgetsChanged);
        this.listInfo = builder.listInfo;
        this.filterInfo = builder.filterInfo;
        this.searchBoxInfo = builder.searchBoxInfo;
        this.rawEntries = builder.rawEntries;
        this.onSelected = builder.onSelected;
        this.filterWidgetSet = builder.filterWidgetSet;
    }

    @Override
    public void onPreRender(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.filterButton != null && this.filterWidgetSet != null && this.filterButton.isSelected()) {
            this.filterWidgetSet.onPreRender(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void onTick() {
        if (this.searchBox != null) {
            this.searchBox.m_94120_();
        }
        if (this.filterButton != null && this.filterWidgetSet != null && this.filterButton.isSelected()) {
            this.filterWidgetSet.onTick();
        }
    }

    @Override
    public <T extends GuiEventListener & Renderable> List<T> initWidgets() {
        if (this.filterInfo != null) {
            this.filterButton = new ButtonImaged(this.filterInfo, it -> {
                it.setSelected(!it.isSelected());
                this.widgetsChanged();
            });
            if (this.filterWidgetSet != null) {
                this.filterWidgetSet.initWidgets();
                this.filterWidgetSet.setOnFilterChanged(it -> {
                    String searchText = "";
                    if (this.searchBox != null) {
                        searchText = this.searchBox.m_94155_();
                    }
                    this.applyFilter(searchText);
                });
            }
        }
        if (this.searchBoxInfo != null) {
            this.searchBox = new EditBoxImage(this.searchBoxInfo);
            this.searchBox.m_94151_(this::applyFilter);
        }
        this.list = new TexturedSelectionList(this.listInfo, this.rawEntries, this.onSelected);
        this.applyFilter("");
        return this.getWidgets();
    }

    @Override
    public <T extends GuiEventListener & Renderable> List<T> getWidgets() {
        ArrayList<Object> widgets = new ArrayList<Object>();
        widgets.add((Object)this.list);
        if (this.filterButton != null) {
            widgets.add((Object)this.filterButton);
            if (this.filterWidgetSet != null && this.filterButton.isSelected()) {
                widgets.addAll(this.filterWidgetSet.getWidgets());
            }
        }
        if (this.searchBox != null) {
            widgets.add((Object)this.searchBox);
        }
        return widgets;
    }

    private void applyFilter(String filterText) {
        String normalizedFilter = this.normalizeText(filterText);
        this.list.filterEntries(entry -> {
            String id = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!normalizedFilter.isEmpty() && !this.normalizeText(value).contains(normalizedFilter)) {
                return false;
            }
            if (this.filterWidgetSet == null) {
                return true;
            }
            return this.filterWidgetSet.filter(id);
        });
    }

    private String normalizeText(String input) {
        if (input == null) {
            return "";
        }
        String noAccents = Normalizer.normalize(input, Normalizer.Form.NFD).replaceAll("\\p{M}", "");
        return noAccents.toLowerCase(Locale.ROOT).trim();
    }

    public FilterListWidgetSet<String> getFilterWidgetSet() {
        return this.filterWidgetSet;
    }

    public ButtonImaged getFilterButton() {
        return this.filterButton;
    }

    public EditBoxImage getSearchBox() {
        return this.searchBox;
    }

    public TexturedSelectionList getList() {
        return this.list;
    }

    public static class Builder {
        private final Runnable onWidgetsChanged;
        private WidgetInfoSelectionList listInfo;
        private final Map<String, String> rawEntries;
        private final Consumer<TexturedSelectionList.TexturedEntry> onSelected;
        private WidgetInfoButtonImaged filterInfo;
        private FilterListWidgetSet<String> filterWidgetSet;
        private WidgetInfoEditBox searchBoxInfo;

        public Builder(@NotNull WidgetInfoSelectionList listInfo, @NotNull Map<String, String> rawEntries, @NotNull Consumer<TexturedSelectionList.TexturedEntry> onSelected, @NotNull Runnable onWidgetsChanged) {
            this.listInfo = listInfo;
            this.rawEntries = rawEntries;
            this.onSelected = onSelected;
            this.onWidgetsChanged = onWidgetsChanged;
        }

        public Builder filterButton(@NotNull WidgetInfoButtonImaged filterInfo, FilterListWidgetSet<String> filterWidgetSet) {
            this.filterInfo = filterInfo;
            this.filterWidgetSet = filterWidgetSet;
            return this;
        }

        public Builder searchBox(WidgetInfoEditBox searchBoxInfo) {
            this.searchBoxInfo = searchBoxInfo;
            return this;
        }

        public SearchableListWidgetSet build() {
            return new SearchableListWidgetSet(this);
        }
    }
}

