/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.widgets.sets;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import me.phoenixra.visor.api.client.gui.widgets.EditBoxImage;
import me.phoenixra.visor.api.client.gui.widgets.ValueDragWidget;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoEditBox;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoValueDrag;
import me.phoenixra.visor.api.client.gui.widgets.sets.WidgetSet;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class ValueEditorFloat
implements WidgetSet {
    private int x;
    private int y;
    private int width;
    private int height;
    private WidgetInfoEditBox editBoxInfo;
    private WidgetInfoValueDrag leftArrowInfo;
    private WidgetInfoValueDrag rightArrowInfo;
    private EditBoxImage editBox;
    private ValueDragWidget leftArrow;
    private ValueDragWidget rightArrow;
    private float value;
    private float minValue;
    private float maxValue;
    private Consumer<Float> responder;

    public ValueEditorFloat(@NotNull Builder builder) {
        this.x = builder.x;
        this.y = builder.y;
        this.width = builder.width;
        this.height = builder.height;
        this.editBoxInfo = builder.widgetInfoEditBox;
        this.leftArrowInfo = builder.widgetInfoLeftArrow;
        this.rightArrowInfo = builder.widgetInfoRightArrow;
        this.leftArrowInfo.pos(this.x, this.y).size(this.height, this.height).setDirection(WidgetInfoValueDrag.Direction.LEFT).setAdapter(WidgetInfoValueDrag.NumericAdapter.of(() -> this.value, v -> this.setValue((float)v, true)));
        this.editBoxInfo.pos(this.x + this.height + builder.gap, this.y).size(this.width - (this.height + builder.gap) * 2, this.height);
        this.rightArrowInfo.pos(this.editBoxInfo.getX() + this.editBoxInfo.getWidth() + builder.gap, this.y).size(this.height, this.height).setDirection(WidgetInfoValueDrag.Direction.RIGHT).setAdapter(WidgetInfoValueDrag.NumericAdapter.of(() -> this.value, v -> this.setValue((float)v, true)));
        this.value = builder.initialValue;
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
        this.responder = builder.responder;
    }

    public void setValue(float value, boolean updateEditBox) {
        this.value = Mth.m_14036_((float)value, (float)this.minValue, (float)this.maxValue);
        if (updateEditBox && this.editBox != null) {
            this.editBox.m_94144_(ValueEditorFloat.formatFloat(this.value));
        }
        if (this.responder != null) {
            this.responder.accept(Float.valueOf(this.value));
        }
    }

    @Override
    public <T extends GuiEventListener & Renderable> List<T> initWidgets() {
        this.editBox = new EditBoxImage(this.editBoxInfo);
        this.editBox.m_94144_(ValueEditorFloat.formatFloat(this.getValue()));
        this.editBox.m_94153_(s -> {
            if (s.isEmpty()) {
                return true;
            }
            if (this.minValue < 0.0f && (s.equals("-") || s.equals("-."))) {
                return true;
            }
            if (s.equals(".")) {
                return true;
            }
            try {
                float v = Float.parseFloat(s);
                return Float.isFinite(v) && v >= this.minValue && v <= this.maxValue;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
        this.editBox.m_94151_(s -> {
            try {
                float v = Float.parseFloat(s);
                if (Float.isFinite(v) && v >= this.minValue && v <= this.maxValue) {
                    this.setValue(v, false);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        int intPartWidth = Math.max(Integer.toString((int)Math.floor(Math.abs(this.minValue))).length(), Integer.toString((int)Math.floor(Math.abs(this.maxValue))).length());
        int maxLen = intPartWidth + 1 + 8 + (this.minValue < 0.0f ? 1 : 0);
        this.editBox.m_94199_(Math.max(maxLen, 6));
        this.editBox.m_94198_();
        this.leftArrow = new ValueDragWidget(this.leftArrowInfo);
        this.rightArrow = new ValueDragWidget(this.rightArrowInfo);
        return this.getWidgets();
    }

    @Override
    public <T extends GuiEventListener & Renderable> List<T> getWidgets() {
        ArrayList<Object> widgets = new ArrayList<Object>();
        widgets.add((Object)this.editBox);
        widgets.add((Object)this.leftArrow);
        widgets.add((Object)this.rightArrow);
        return widgets;
    }

    @Override
    public void onPreRender(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void onTick() {
        this.editBox.m_94120_();
    }

    private static String formatFloat(float v) {
        String s = String.format(Locale.ROOT, "%.6f", Float.valueOf(v));
        int dot = s.indexOf(46);
        if (dot >= 0) {
            int end;
            for (end = s.length(); end > dot + 1 && s.charAt(end - 1) == '0'; --end) {
            }
            if (end == dot + 1) {
                end = dot;
            }
            s = s.substring(0, end);
        }
        return s;
    }

    public float getValue() {
        return this.value;
    }

    public static class Builder {
        private int x;
        private int y;
        private int width;
        private int height;
        private int gap = 4;
        private WidgetInfoEditBox widgetInfoEditBox;
        private WidgetInfoValueDrag widgetInfoLeftArrow;
        private WidgetInfoValueDrag widgetInfoRightArrow;
        private float initialValue;
        private float minValue = -3.4028235E38f;
        private float maxValue = Float.MAX_VALUE;
        private Consumer<Float> responder;

        public Builder(float initialValue, int x, int y, int width, int height) {
            this.initialValue = initialValue;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public Builder range(float min, float max) {
            this.minValue = min;
            this.maxValue = max;
            return this;
        }

        public Builder editBox(WidgetInfoEditBox widgetInfo) {
            this.widgetInfoEditBox = widgetInfo;
            return this;
        }

        public Builder leftArrow(WidgetInfoValueDrag widgetInfo) {
            this.widgetInfoLeftArrow = widgetInfo;
            return this;
        }

        public Builder rightArrow(WidgetInfoValueDrag widgetInfo) {
            this.widgetInfoRightArrow = widgetInfo;
            return this;
        }

        public ValueEditorFloat build() {
            return new ValueEditorFloat(this);
        }

        public Builder setGap(int gap) {
            this.gap = gap;
            return this;
        }

        public Builder setResponder(Consumer<Float> responder) {
            this.responder = responder;
            return this;
        }
    }
}

