/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.input.action;

import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.phoenixra.atumconfig.api.config.ConfigFile;
import me.phoenixra.atumconfig.api.config.ConfigType;
import me.phoenixra.atumvr.core.enums.XRInteractionProfile;
import me.phoenixra.atumvr.core.input.action.profileset.OpenXRProfileSet;
import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.client.input.action.BindingPath;
import me.phoenixra.visor.api.client.input.action.VisorAction;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.addon.element.ElementPriority;
import me.phoenixra.visor.api.common.addon.element.PrioritySupporter;
import me.phoenixra.visor.api.common.addon.element.VisorElement;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public abstract class VisorActionSet
implements VisorElement,
PrioritySupporter {
    private final VisorAddon owner;
    private boolean enabled = true;
    protected Map<String, VisorAction> actionsMap;
    protected ConfigFile configRight;
    protected ConfigFile configLeft;

    public VisorActionSet(VisorAddon owner) {
        this.owner = owner;
        this.actionsMap = new LinkedHashMap<String, VisorAction>();
        try {
            this.configRight = VisorAPI.client().getConfigManager().createConfigFile(ConfigType.JSON, "right_action_set_" + this.getId(), Path.of("input/rightHanded/" + this.getId() + ".json", new String[0]));
            this.configLeft = VisorAPI.client().getConfigManager().createConfigFile(ConfigType.JSON, "left_action_set_" + this.getId(), Path.of("input/leftHanded/" + this.getId() + ".json", new String[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (VisorAction action : this.loadActions()) {
            this.actionsMap.put(action.getId(), action);
        }
        if (this.configLeft.getAllSubsections().isEmpty()) {
            this.saveBindings(true);
        }
        if (this.configRight.getAllSubsections().isEmpty()) {
            this.saveBindings(false);
        }
        this.loadBindings();
    }

    protected abstract List<VisorAction> loadActions();

    public abstract boolean canActivate();

    public boolean isEnabledAndCanActivate() {
        return this.enabled && this.canActivate();
    }

    public Component getName() {
        return Component.m_237115_((String)("visor.action_sets." + this.getId()));
    }

    public void preTick() {
        this.getActions().forEach(VisorAction::preTick);
    }

    public void updateState(OpenXRProfileSet currentProfile, boolean leftHanded) {
        this.getActions().forEach(it -> it.updateState(currentProfile, leftHanded));
    }

    public void clear() {
        this.getActions().forEach(VisorAction::clear);
    }

    public void loadBindings() {
        for (VisorAction action : this.actionsMap.values()) {
            for (XRInteractionProfile profile : XRInteractionProfile.values()) {
                String path = profile.name() + "." + action.getId();
                String leftHandedPath = this.configLeft.getStringOrDefault(path, "null");
                String rightHandedPath = this.configRight.getStringOrDefault(path, "null");
                action.setBinding(profile, new BindingPath(rightHandedPath, leftHandedPath));
            }
        }
    }

    public void loadDefaults(XRInteractionProfile profile) {
        this.getActions().forEach(it -> {
            BindingPath def = it.getDefaultBinding(profile);
            if (def == null) {
                def = BindingPath.EMPTY;
            }
            it.setBinding(profile, def);
        });
    }

    public void saveBindings() {
        for (VisorAction action : this.actionsMap.values()) {
            for (XRInteractionProfile profile : XRInteractionProfile.values()) {
                BindingPath binding = action.getBindingOrEmpty(profile);
                String path = profile.name() + "." + action.getId();
                this.configLeft.set(path, binding.getLeftHandedPath());
                this.configRight.set(path, binding.getRightHandedPath());
            }
        }
        try {
            this.configLeft.save();
            this.configRight.save();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void saveBindings(boolean leftHanded) {
        for (VisorAction action : this.actionsMap.values()) {
            for (XRInteractionProfile profile : XRInteractionProfile.values()) {
                BindingPath binding = action.getBindingOrEmpty(profile);
                String path = profile.name() + "." + action.getId();
                if (leftHanded) {
                    this.configLeft.set(path, binding.getLeftHandedPath());
                    continue;
                }
                this.configRight.set(path, binding.getRightHandedPath());
            }
        }
        try {
            if (leftHanded) {
                this.configLeft.save();
            } else {
                this.configRight.save();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public VisorAction getAction(String id) {
        return this.actionsMap.get(id);
    }

    public Collection<VisorAction> getActions() {
        return this.actionsMap.values();
    }

    @Override
    @NotNull
    public ElementPriority getPriority() {
        return ElementPriority.NORMAL;
    }

    @Override
    public VisorAddon getOwner() {
        return this.owner;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public ConfigFile getConfigRight() {
        return this.configRight;
    }

    public ConfigFile getConfigLeft() {
        return this.configLeft;
    }
}

