/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.input.action.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import me.phoenixra.atumvr.api.input.action.VRActionDataVec2;
import me.phoenixra.atumvr.core.enums.XRInteractionProfile;
import me.phoenixra.atumvr.core.input.action.profileset.OpenXRProfileSet;
import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.client.input.action.BindingPath;
import me.phoenixra.visor.api.client.input.action.VisorAction;
import me.phoenixra.visor.api.client.input.action.VisorActionSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;

public abstract class VisorActionVec2
implements VisorAction {
    private final VisorActionSet actionSet;
    private final String id;
    private boolean active;
    private boolean changed;
    private Vector2f state = new Vector2f();
    private final Map<XRInteractionProfile, BindingPath> defaultBindings;
    private final Map<XRInteractionProfile, BindingPath> bindings;

    public VisorActionVec2(VisorActionSet actionSet, String id) {
        this.actionSet = actionSet;
        this.id = id;
        this.defaultBindings = new EnumMap<XRInteractionProfile, BindingPath>(this.loadDefaults());
        this.bindings = new EnumMap<XRInteractionProfile, BindingPath>(this.defaultBindings);
    }

    protected abstract Map<XRInteractionProfile, BindingPath> loadDefaults();

    protected abstract void onStateChanged(Vector2f var1);

    protected void onClear() {
    }

    @Nullable
    protected VRActionDataVec2 getVec2Data(@NotNull BindingPath bindingPath, @NotNull OpenXRProfileSet currentProfile, boolean leftHanded) {
        return bindingPath.getVec2(currentProfile, leftHanded);
    }

    @Override
    public void preTick() {
        if (this.changed) {
            this.onStateChanged(this.state);
            this.changed = false;
        }
    }

    @Override
    public void updateState(@NotNull OpenXRProfileSet currentProfile, boolean leftHanded) {
        BindingPath bindingPath = this.bindings.get((Object)currentProfile.getType());
        if (bindingPath == null) {
            this.active = false;
            this.changed = true;
            this.state.set(0.0f, 0.0f);
            return;
        }
        VRActionDataVec2 vec2Data = this.getVec2Data(bindingPath, currentProfile, leftHanded);
        if (vec2Data == null) {
            if (this.active) {
                this.clear();
            }
            return;
        }
        this.active = vec2Data.isActive();
        if (!this.active) {
            return;
        }
        if (!vec2Data.isChanged()) {
            return;
        }
        this.changed = true;
        this.state = vec2Data.getCurrentState();
    }

    @Override
    public void clear() {
        this.changed = true;
        this.state.set(0.0f, 0.0f);
        this.onStateChanged(this.state);
        this.active = false;
        this.changed = false;
        this.onClear();
    }

    @Override
    public void setBinding(@NotNull XRInteractionProfile profile, @NotNull BindingPath path) {
        this.bindings.put(profile, path);
    }

    @Override
    @Nullable
    public BindingPath getBinding(@NotNull XRInteractionProfile profile) {
        return this.bindings.get((Object)profile);
    }

    @Override
    @Nullable
    public BindingPath getDefaultBinding(@NotNull XRInteractionProfile profile) {
        return this.defaultBindings.get((Object)profile);
    }

    @Override
    @NotNull
    public Collection<String> getSelectableBindings(@NotNull XRInteractionProfile profile) {
        OpenXRProfileSet profileSet = VisorAPI.client().getInputManager().getProfileSetHolder().getProfileSet(profile);
        ArrayList<String> out = new ArrayList<String>();
        out.add("null");
        if (profileSet != null) {
            out.addAll(profileSet.getVec2Ids());
        }
        return out;
    }

    @Override
    public VisorActionSet getActionSet() {
        return this.actionSet;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    public Vector2f getState() {
        return this.state;
    }
}

