/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.tasks;

import java.util.Objects;
import me.phoenixra.visor.api.client.tasks.TaskType;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.addon.element.ElementPriority;
import me.phoenixra.visor.api.common.addon.element.PrioritySupporter;
import me.phoenixra.visor.api.common.addon.element.VisorElement;
import net.minecraft.client.player.LocalPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VisorTask
implements VisorElement,
PrioritySupporter {
    @NotNull
    private final VisorAddon owner;
    private boolean enabled = true;
    private boolean cleared;

    public VisorTask(@NotNull VisorAddon owner) {
        Objects.requireNonNull(owner);
        this.owner = owner;
    }

    protected abstract void onRun(@Nullable LocalPlayer var1);

    protected abstract void onClear(@Nullable LocalPlayer var1);

    public abstract boolean isActive(@Nullable LocalPlayer var1);

    public final void run(@Nullable LocalPlayer player) {
        this.cleared = false;
        this.onRun(player);
    }

    public final void clear(@Nullable LocalPlayer player) {
        if (!this.alwaysClear() && this.cleared) {
            return;
        }
        this.onClear(player);
        this.cleared = true;
    }

    public boolean isEnabledAndActive(@Nullable LocalPlayer player) {
        return this.enabled && this.isActive(player);
    }

    protected boolean alwaysClear() {
        return false;
    }

    @Override
    @NotNull
    public ElementPriority getPriority() {
        return ElementPriority.NORMAL;
    }

    @NotNull
    public TaskType getType() {
        return TaskType.VR_PRE_TICK;
    }

    @Override
    @NotNull
    public VisorAddon getOwner() {
        return this.owner;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isCleared() {
        return this.cleared;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

