/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.common.eventbus;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.phoenixra.visor.api.common.eventbus.event.VREvent;
import me.phoenixra.visor.api.common.eventbus.event.VREventCancelable;
import me.phoenixra.visor.api.common.eventbus.event.VREventHasResult;

public class VREventHelper {
    private static final Map<Class<?>, Boolean> resultCache = new ConcurrentHashMap();
    private static final Map<Class<?>, Boolean> cancelableCache = new ConcurrentHashMap();

    public static boolean isCancelable(Class<?> eventClass) {
        return VREventHelper.hasAnnotation(eventClass, VREventCancelable.class, cancelableCache);
    }

    public static boolean hasResult(Class<?> eventClass) {
        return VREventHelper.hasAnnotation(eventClass, VREventHasResult.class, resultCache);
    }

    private static boolean hasAnnotation(Class<?> eventClass, Class<? extends Annotation> annotation, Map<Class<?>, Boolean> cacheMap) {
        if (eventClass == VREvent.class) {
            return false;
        }
        return cacheMap.computeIfAbsent(eventClass, it -> {
            Class parent = eventClass.getSuperclass();
            return eventClass.isAnnotationPresent(annotation) || parent != null && VREventHelper.hasAnnotation(parent, annotation, cacheMap);
        });
    }
}

