/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.common.eventbus.event;

import java.util.Objects;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.eventbus.VREventHelper;
import me.phoenixra.visor.api.common.eventbus.event.VREventPriority;
import org.jetbrains.annotations.NotNull;

public abstract class VREvent {
    private final VisorAddon owner;
    private boolean canceled;
    private VREventPriority phase = null;
    private Result result = Result.DEFAULT;

    public VREvent(@NotNull VisorAddon owner) {
        Objects.requireNonNull(owner);
        this.owner = owner;
    }

    public void requireModifiable() {
        if (this.phase == VREventPriority.MONITOR) {
            throw new UnsupportedOperationException("Attempted to modify event during phase: " + String.valueOf((Object)this.phase) + " Event Type: " + this.getClass().getCanonicalName());
        }
    }

    public final void setCanceled(boolean flag) {
        if (!this.isCancelable()) {
            throw new UnsupportedOperationException("Called VREvent#setCanceled() on a non-cancelable event: " + this.getClass().getCanonicalName());
        }
        this.canceled = flag;
    }

    public boolean isCancelable() {
        return VREventHelper.isCancelable(this.getClass());
    }

    public boolean hasResult() {
        return VREventHelper.hasResult(this.getClass());
    }

    public void setResult(Result flag) {
        if (!this.hasResult()) {
            throw new UnsupportedOperationException("Called VREvent#setResult() on a non-result event: " + this.getClass().getCanonicalName());
        }
        this.result = flag;
    }

    public boolean nextPhase() {
        if (this.phase == null) {
            this.phase = VREventPriority.LOWEST;
            return true;
        }
        if (this.phase == VREventPriority.MONITOR) {
            return false;
        }
        this.phase = this.phase.next();
        return true;
    }

    public VisorAddon getOwner() {
        return this.owner;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public VREventPriority getPhase() {
        return this.phase;
    }

    public Result getResult() {
        return this.result;
    }

    public static enum Result {
        DENY,
        DEFAULT,
        ALLOW;

    }
}

