/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.common.network.buffer;

import me.phoenixra.visor.api.client.VRClientPlayer;
import me.phoenixra.visor.api.client.data.PoseData;
import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.api.common.network.buffer.BufferSerializable;
import me.phoenixra.visor.api.common.network.buffer.DevicePoseBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record PlayerPoseBuffer(DevicePoseBuffer hmd, DevicePoseBuffer mainHand, DevicePoseBuffer offhand, boolean leftHanded) implements BufferSerializable
{
    @Override
    public void serialize(FriendlyByteBuf buffer) {
        this.hmd.serialize(buffer);
        this.mainHand.serialize(buffer);
        this.offhand.serialize(buffer);
        buffer.writeBoolean(this.leftHanded);
    }

    public static PlayerPoseBuffer deserialize(FriendlyByteBuf byteBuf) {
        return new PlayerPoseBuffer(DevicePoseBuffer.deserialize(byteBuf), DevicePoseBuffer.deserialize(byteBuf), DevicePoseBuffer.deserialize(byteBuf), byteBuf.readBoolean());
    }

    public static PlayerPoseBuffer create(VRClientPlayer clientPlayer, boolean leftHanded) {
        return new PlayerPoseBuffer(PlayerPoseBuffer.getHmdPose(clientPlayer), PlayerPoseBuffer.getControllerPose(clientPlayer, ControllerHand.MAIN), PlayerPoseBuffer.getControllerPose(clientPlayer, ControllerHand.OFFHAND), leftHanded);
    }

    private static DevicePoseBuffer getHmdPose(VRClientPlayer clientPlayer) {
        PoseData postTickPose = clientPlayer.getPoseData(PoseDataType.POST_TICK);
        Vector3f position = postTickPose.getHmd().getPosition().sub((Vector3fc)Minecraft.m_91087_().f_91074_.m_20182_().m_252839_(), new Vector3f());
        Quaternionf orientation = postTickPose.getHmd().getRotation().getNormalizedRotation(new Quaternionf());
        return new DevicePoseBuffer((Vector3fc)position, (Quaternionfc)orientation);
    }

    private static DevicePoseBuffer getControllerPose(VRClientPlayer clientPlayer, ControllerHand controller) {
        PoseData postTickPose = clientPlayer.getPoseData(PoseDataType.POST_TICK);
        Vector3f position = postTickPose.getController(controller).getPosition().sub((Vector3fc)Minecraft.m_91087_().f_91074_.m_20182_().m_252839_(), new Vector3f());
        Quaternionf orientation = postTickPose.getController(controller).getRotation().getNormalizedRotation(new Quaternionf());
        return new DevicePoseBuffer((Vector3fc)position, (Quaternionfc)orientation);
    }
}

