/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.common.utils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class QuaternionFloatHistory {
    private final Deque<Entry> history;
    private final int capacity;

    public QuaternionFloatHistory(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("Capacity must be > 0");
        }
        this.capacity = capacity;
        this.history = new ArrayDeque<Entry>(capacity);
    }

    public synchronized void add(Quaternionf quat) {
        this.history.addLast(new Entry(new Quaternionf((Quaternionfc)quat), System.currentTimeMillis()));
        if (this.history.size() > this.capacity) {
            this.history.removeFirst();
        }
    }

    public synchronized void clear() {
        this.history.clear();
    }

    public synchronized Quaternionf latest() {
        Entry last = this.history.peekLast();
        if (last == null) {
            throw new NoSuchElementException("No rotations in history");
        }
        return new Quaternionf((Quaternionfc)last.data);
    }

    public synchronized Quaternionf averageRotation(double seconds) {
        long now = System.currentTimeMillis();
        ArrayList<Quaternionf> recent = new ArrayList<Quaternionf>();
        Iterator<Entry> it = this.history.descendingIterator();
        while (it.hasNext()) {
            Entry e = it.next();
            if (now - e.timestamp > (long)(seconds * 1000.0)) break;
            recent.add(e.data);
        }
        if (recent.isEmpty()) {
            return this.latest();
        }
        int n = recent.size();
        float[] weights = new float[n];
        float w = 1.0f / (float)n;
        Arrays.fill(weights, w);
        Quaternionf result = new Quaternionf();
        Quaternionf.slerp((Quaternionf[])recent.toArray(new Quaternionf[0]), (float[])weights, (Quaternionf)result);
        return result;
    }

    private record Entry(Quaternionf data, long timestamp) {
    }
}

