/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.compatibility;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.StemBlock;

public enum BlockClassifier {
    FARMABLE_BLOCK(block -> block instanceof CropBlock || block instanceof StemBlock || block instanceof AttachedStemBlock);

    private final List<Predicate<Block>> recognizers = new ArrayList<Predicate<Block>>();
    private final List<Predicate<Block>> filters = new ArrayList<Predicate<Block>>();

    private BlockClassifier(Predicate<Block> defRecognizer) {
        this.recognizers.add(defRecognizer);
    }

    public boolean is(Block block) {
        boolean recognized = false;
        for (Predicate<Block> entry : this.recognizers) {
            if (!entry.test(block)) continue;
            recognized = true;
            break;
        }
        for (Predicate<Block> entry : this.filters) {
            if (entry.test(block)) continue;
            recognized = false;
            break;
        }
        return recognized;
    }

    public List<Predicate<Block>> getRecognizers() {
        return this.recognizers;
    }

    public List<Predicate<Block>> getFilters() {
        return this.filters;
    }
}

