/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.compatibility;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.item.EggItem;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FoodOnAStickItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SnowballItem;
import net.minecraft.world.item.SplashPotionItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;

public enum ItemClassifier {
    FARMING_TOOL(itemStack -> itemStack.m_41720_() instanceof HoeItem),
    SHIELD(itemStack -> itemStack.m_41720_() instanceof ShieldItem),
    SWORD(itemStack -> itemStack.m_41720_() instanceof SwordItem),
    SPEAR(itemStack -> itemStack.m_41720_() instanceof TridentItem),
    FOOD_STICK(itemStack -> itemStack.m_41720_() instanceof FoodOnAStickItem),
    THROWABLE(itemStack -> {
        Item item = itemStack.m_41720_();
        return item instanceof SnowballItem || item instanceof EggItem || item instanceof SplashPotionItem || item instanceof LingeringPotionItem || item instanceof FireChargeItem;
    });

    private final List<Predicate<ItemStack>> recognizers = new ArrayList<Predicate<ItemStack>>();
    private final List<Predicate<ItemStack>> filters = new ArrayList<Predicate<ItemStack>>();

    private ItemClassifier(Predicate<ItemStack> defRecognizer) {
        this.recognizers.add(defRecognizer);
    }

    public boolean is(ItemStack itemStack) {
        boolean recognized = false;
        for (Predicate<ItemStack> entry : this.recognizers) {
            if (!entry.test(itemStack)) continue;
            recognized = true;
            break;
        }
        for (Predicate<ItemStack> entry : this.filters) {
            if (entry.test(itemStack)) continue;
            recognized = false;
            break;
        }
        return recognized;
    }

    public boolean is(Item item) {
        return this.is(item.m_7968_());
    }

    public List<Predicate<ItemStack>> getRecognizers() {
        return this.recognizers;
    }

    public List<Predicate<ItemStack>> getFilters() {
        return this.filters;
    }
}

