/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client;

import java.util.EnumMap;
import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.client.ClientFeature;
import me.phoenixra.visor.api.client.events.AllowClientFeatureVREvent;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import org.jetbrains.annotations.NotNull;

public class ClientFeaturesToggle {
    private final EnumMap<ClientFeature, Boolean> features = new EnumMap(ClientFeature.class);

    public boolean isAllowed(@NotNull ClientFeature feature) {
        return this.features.getOrDefault((Object)feature, false);
    }

    protected void preTick() {
        this.updateAllFeatures(false);
    }

    protected void preRender() {
        this.updateAllFeatures(true);
    }

    private void updateAllFeatures(boolean preRender) {
        for (ClientFeature feature : ClientFeature.values()) {
            if (feature.isRenderFeature() != preRender) continue;
            if (!this.checkFeature(feature)) {
                this.features.put(feature, false);
                continue;
            }
            AllowClientFeatureVREvent event = new AllowClientFeatureVREvent(feature);
            VisorAPI.eventBus().callEvent(event);
            this.features.put(feature, !event.isCanceled());
        }
    }

    private boolean checkFeature(ClientFeature feature) {
        return switch (feature) {
            case ClientFeature.AIM_EFFECTS -> this.checkAimEffects();
            case ClientFeature.VR_HANDS -> this.checkVRHands();
            default -> true;
        };
    }

    private boolean checkAimEffects() {
        if (VisorClientImpl.MC.f_91073_ == null) {
            return false;
        }
        if (VisorClientImpl.MC.f_91080_ != null) {
            return false;
        }
        return !ClientContext.cursorHandler.isCursorHandFocused();
    }

    private boolean checkVRHands() {
        return true;
    }

    public EnumMap<ClientFeature, Boolean> getFeatures() {
        return this.features;
    }
}

