/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client;

import com.mojang.blaze3d.platform.InputConstants;
import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.VisorClientState;
import me.phoenixra.visor.api.client.VRPlayMode;
import me.phoenixra.visor.api.client.VRStateMode;
import me.phoenixra.visor.api.client.render.RenderPhase;
import me.phoenixra.visor.api.client.render.VRDisplay;
import me.phoenixra.visor.api.common.network.toserver.vrstate.VRActivePayloadToServer;
import me.phoenixra.visor.api.common.utils.LoggerUtils;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.gui.screens.GameMenuScreen;
import me.phoenixra.visor.core.client.gui.screens.VRErrorReportScreen;
import me.phoenixra.visor.core.client.network.ClientNetworking;
import me.phoenixra.visor.core.client.network.players.VRRemotePlayers;
import me.phoenixra.visor.core.client.render.VRRenderState;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class VisorState
implements VisorClientState {
    private static VRStateMode state = VRStateMode.OFF;
    public static int TICK_COUNT;
    public static long FRAME_COUNT;
    private static boolean minecraftLoaded;
    private static Runnable delayedErrorHandling;

    public static void updateState() {
        boolean canInit;
        if (ClientContext.visor == null) {
            if (!minecraftLoaded) {
                return;
            }
            VisorState.startClient();
        }
        if (delayedErrorHandling != null && (VisorClientImpl.MC.f_91080_ instanceof DisconnectedScreen || VisorClientImpl.MC.f_91080_ instanceof TitleScreen)) {
            delayedErrorHandling.run();
            delayedErrorHandling = null;
        }
        if (canInit = VRClientSettings.getVrPlayMode().canInitVR()) {
            if (state.isNotInitialized()) {
                VisorState.initVR();
                return;
            }
        } else if (state.isInitialized()) {
            VisorState.destroyVR();
            return;
        }
        if (state.isNotInitialized()) {
            return;
        }
        ClientContext.visor.syncVRState();
        VRPlayMode playMode = VRClientSettings.getVrPlayMode();
        boolean vrActive = playMode.canPlayVR() && (ClientContext.visor.isActive() || playMode == VRPlayMode.ALWAYS_ACTIVE);
        boolean changed = VisorState.updateActive(vrActive);
        if (changed) {
            return;
        }
        if (state.isActive()) {
            if (ClientContext.visor.isFocused()) {
                state = VRStateMode.FOCUSED;
            } else {
                if (state != VRStateMode.ACTIVE && VisorClientImpl.MC.f_91073_ != null) {
                    VisorClientImpl.MC.m_91152_((Screen)new GameMenuScreen());
                }
                state = VRStateMode.ACTIVE;
            }
        }
    }

    private static void startClient() {
        try {
            if (ClientContext.visor != null) {
                return;
            }
            VisorClientImpl.LOGGER.info("Starting Visor client...");
            VisorAPI.Instance.setClientState(new VisorState());
            ClientContext.visor = new VisorClientImpl();
            VisorAPI.Instance.setClient(ClientContext.visor);
            ClientContext.visor.prepare();
            VisorClientImpl.LOGGER.info("Current VR Play Mode: {}", (Object)VRClientSettings.getVrPlayMode());
        }
        catch (Throwable e) {
            VisorState.destroyVRWithErrorScreen(e);
        }
    }

    private static void initVR() {
        try {
            VisorClientImpl.LOGGER.info("Initializing VR session...");
            ClientContext.visor.initializeVR();
            VRRenderState.startVanillaPhase();
            state = VRStateMode.INITIALIZED;
            VisorClientImpl.LOGGER.info("VR session INIT SUCCESS");
            LoggerUtils.sendPcInfo();
        }
        catch (Throwable e) {
            VisorState.destroyVRWithErrorScreen(e);
        }
    }

    private static boolean updateActive(boolean active) {
        if (state.isActive() == active) {
            return false;
        }
        if (active) {
            VisorState.activate();
        } else {
            VisorState.deactivate();
        }
        ClientNetworking.sendVRPacket(new VRActivePayloadToServer(state.isActive()));
        if (!VisorClientImpl.MC.m_91106_().m_120354_().isEmpty()) {
            VisorClientImpl.MC.m_91106_().m_194526_();
        }
        VisorClientImpl.MC.m_5741_();
        VisorClientImpl.MC.m_91268_().m_85409_(((Boolean)VisorClientImpl.MC.f_91066_.m_231817_().m_231551_()).booleanValue());
        ClientContext.renderer.prepareReinit("Switched state");
        return true;
    }

    private static void activate() {
        state = VRStateMode.ACTIVE;
        if (VisorClientImpl.MC.f_91074_ != null) {
            ClientContext.player.recenterOrigin((Entity)VisorClientImpl.MC.f_91074_, false);
        }
        InputConstants.m_84833_((long)VisorClientImpl.MC.m_91268_().m_85439_(), (int)212993, (double)VisorClientImpl.MC.f_91067_.m_91589_(), (double)VisorClientImpl.MC.f_91067_.m_91594_());
    }

    private static void deactivate() {
        state = VRStateMode.INITIALIZED;
        if (VisorClientImpl.MC.f_91074_ != null) {
            VRRemotePlayers.getInstance().removePlayer(VisorClientImpl.MC.f_91074_.m_20148_());
        }
        if (VisorClientImpl.MC.f_91063_ != null) {
            VisorClientImpl.MC.f_91063_.m_109106_(VisorClientImpl.MC.f_91066_.m_92176_().m_90612_() ? VisorClientImpl.MC.m_91288_() : null);
        }
        if (VisorClientImpl.MC.f_91080_ != null || VisorClientImpl.MC.f_91073_ == null) {
            VisorClientImpl.MC.f_91067_.m_91602_();
            InputConstants.m_84833_((long)VisorClientImpl.MC.m_91268_().m_85439_(), (int)212993, (double)VisorClientImpl.MC.f_91067_.m_91589_(), (double)VisorClientImpl.MC.f_91067_.m_91594_());
        } else {
            VisorClientImpl.MC.f_91067_.m_91601_();
            InputConstants.m_84833_((long)VisorClientImpl.MC.m_91268_().m_85439_(), (int)212995, (double)VisorClientImpl.MC.f_91067_.m_91589_(), (double)VisorClientImpl.MC.f_91067_.m_91594_());
        }
    }

    public static void destroyVRWithErrorScreen(Throwable throwable) {
        VisorState.destroyVR();
        VRClientSettings.setVrPlayMode(VRPlayMode.DISABLED);
        if (VisorClientImpl.MC.f_91073_ != null) {
            VisorClientImpl.MC.f_91073_.m_7462_();
            delayedErrorHandling = () -> VRErrorReportScreen.catchError(throwable, true);
        } else {
            VRErrorReportScreen.catchError(throwable, true);
        }
    }

    public static void destroyVR() {
        if (ClientContext.visor != null) {
            VisorState.updateActive(false);
            state = VRStateMode.OFF;
            ClientContext.visor.destroy();
        } else {
            state = VRStateMode.OFF;
        }
    }

    @Override
    @NotNull
    public VRStateMode stateMode() {
        return state;
    }

    @Override
    @NotNull
    public VRPlayMode playMode() {
        return VRClientSettings.getVrPlayMode();
    }

    @Override
    @NotNull
    public RenderPhase renderPhase() {
        return VRRenderState.getCurrentPhase();
    }

    @Override
    public VRDisplay renderingDisplay() {
        return VRRenderState.getCurrentVRDisplay();
    }

    public static VRStateMode getState() {
        return state;
    }

    public static void setMinecraftLoaded(boolean minecraftLoaded) {
        VisorState.minecraftLoaded = minecraftLoaded;
    }

    static {
        minecraftLoaded = false;
        delayedErrorHandling = null;
    }
}

