/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.data;

import me.phoenixra.visor.api.client.data.PoseElement;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PoseElementImpl
implements PoseElement {
    private Vector3fc position;
    private Vector3fc direction;
    private Matrix4fc rotation;
    private Matrix4fc invertedRotation;
    private float yaw;
    private float pitch;
    private float roll;
    private Vector3fc originCached;

    public PoseElementImpl() {
        this.position = new Vector3f(0.0f, 0.0f, 0.0f);
        this.direction = new Vector3f(0.0f, 0.0f, 0.0f);
        this.rotation = new Matrix4f();
        this.invertedRotation = new Matrix4f();
        this.originCached = new Vector3f(0.0f, 0.0f, 0.0f);
    }

    public PoseElementImpl(Vector3fc origin, float rotationY, float worldScale, Matrix4fc rotationMatrix, Vector3fc position, Vector3fc direction) {
        this.update(origin, rotationY, worldScale, rotationMatrix, position, direction);
    }

    protected void update(Vector3fc origin, float rotationY, float worldScale, Matrix4fc rotationMatrix, Vector3fc position, Vector3fc direction) {
        this.originCached = origin;
        this.rotation = new Matrix4f().rotationY(rotationY).mul(rotationMatrix, new Matrix4f());
        this.invertedRotation = this.rotation.invert(new Matrix4f());
        this.position = position.mul(worldScale, new Vector3f()).rotateY(rotationY).add(origin);
        this.direction = direction.rotateY(rotationY, new Vector3f());
        this.yaw = (float)Math.toDegrees(Mth.m_14136_((double)(-this.direction.x()), (double)this.direction.z()));
        this.pitch = (float)Math.toDegrees(Math.asin(this.direction.y() / this.direction.length()));
        this.roll = (float)(-Math.toDegrees(Mth.m_14136_((double)rotationMatrix.m10(), (double)rotationMatrix.m11())));
    }

    protected void onOriginChanged(Vector3fc newOrigin) {
        this.position = this.position.add(newOrigin.x() - this.originCached.x(), newOrigin.y() - this.originCached.y(), newOrigin.z() - this.originCached.z(), new Vector3f());
        this.originCached = newOrigin;
    }

    @Override
    @NotNull
    public Vector3f getCustomVector(@NotNull Vector3fc vec) {
        return this.rotation.transformDirection(vec.x(), vec.y(), vec.z(), new Vector3f());
    }

    @Override
    @NotNull
    public Vector3f reverseCustomVector(@NotNull Vector3fc vec) {
        return this.invertedRotation.transformDirection(vec.x(), vec.y(), vec.z(), new Vector3f());
    }

    public Vector3f getScalePosOffset(float rotaionY, float oldWorldScale, float newWorldScale) {
        Vector3f oldPos = this.position.mul(oldWorldScale, new Vector3f()).rotateY(rotaionY);
        Vector3f newPos = this.position.mul(newWorldScale, new Vector3f()).rotateY(rotaionY);
        return newPos.sub((Vector3fc)oldPos);
    }

    public String toString() {
        return String.format("VRPoseElement [position=%s, direction=%s,  yaw=%.2f\u00b0, pitch=%.2f\u00b0, roll=%.2f\u00b0]", this.getPosition(), this.getDirection(), Float.valueOf(this.yaw), Float.valueOf(this.pitch), Float.valueOf(this.roll));
    }

    @Override
    public Vector3fc getPosition() {
        return this.position;
    }

    @Override
    public Vector3fc getDirection() {
        return this.direction;
    }

    @Override
    public Matrix4fc getRotation() {
        return this.rotation;
    }

    public Matrix4fc getInvertedRotation() {
        return this.invertedRotation;
    }

    @Override
    public float getYaw() {
        return this.yaw;
    }

    @Override
    public float getPitch() {
        return this.pitch;
    }

    @Override
    public float getRoll() {
        return this.roll;
    }

    public Vector3fc getOriginCached() {
        return this.originCached;
    }
}

