/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.data;

import java.util.List;
import me.phoenixra.visor.api.client.VRClientPlayer;
import me.phoenixra.visor.api.client.data.ControllerRaw;
import me.phoenixra.visor.api.client.data.HmdRaw;
import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.data.PoseElement;
import me.phoenixra.visor.api.client.tasks.VisorTask;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.api.common.utils.VRMathUtils;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.VisorState;
import me.phoenixra.visor.core.client.data.PoseDataImpl;
import me.phoenixra.visor.core.client.network.ClientNetworking;
import me.phoenixra.visor.core.client.render.VRRenderState;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import me.phoenixra.visor.core.client.settings.options.enums.RotationMode;
import me.phoenixra.visor.core.client.tasks.movement.vehicle.TaskRoomVehicle;
import me.phoenixra.visor.modified.client.entity.LocalPlayerModified;
import me.phoenixra.visor.modified.client.render.GameRendererModified;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VRClientPlayerImpl
implements VRClientPlayer {
    private final PoseDataImpl roomPose;
    private final PoseDataImpl preTickPose;
    private final PoseDataImpl postTickPose;
    private final PoseDataImpl renderPose;
    private Vector3fc origin = new Vector3f(0.0f, 0.0f, 0.0f);
    private float worldScale = 1.0f;
    private float rotationY = 0.0f;
    private ControllerHand activeHand = ControllerHand.MAIN;
    private Vector2f movement = new Vector2f();
    private boolean moving;

    public VRClientPlayerImpl() {
        this.roomPose = new PoseDataImpl(PoseDataType.ROOM, this.origin, VRClientSettings.getWalkMultiplier(), 1.0f, 0.0f);
        this.preTickPose = new PoseDataImpl(PoseDataType.PRE_TICK, this.origin, VRClientSettings.getWalkMultiplier(), 1.0f, 0.0f);
        this.postTickPose = new PoseDataImpl(PoseDataType.POST_TICK, this.origin, VRClientSettings.getWalkMultiplier(), 1.0f, 0.0f);
        this.renderPose = new PoseDataImpl(PoseDataType.RENDER, this.origin, VRClientSettings.getWalkMultiplier(), 1.0f, 0.0f);
    }

    public void preTick() {
        float preWorldScale;
        this.preTickPose.update(this.origin, VRClientSettings.getWalkMultiplier(), this.worldScale, this.rotationY);
        this.worldScale = preWorldScale = VRRenderState.isInMainMenu() ? 1.0f : VRClientSettings.getWorldScale();
    }

    public void tickPlayer(LocalPlayer player) {
        try {
            List<VisorTask> tasks = ClientContext.visor.getTaskRegistry().getPlayerTick();
            for (VisorTask task : tasks) {
                if (task.isEnabledAndActive(player)) {
                    task.run(player);
                    continue;
                }
                task.clear(player);
            }
        }
        catch (Throwable e) {
            VisorState.destroyVRWithErrorScreen(e);
        }
    }

    public void postTick() {
        Vector3f scaleOffset = this.preTickPose.hmd.getScalePosOffset(this.preTickPose.getRotationY(), this.preTickPose.getWorldScale(), this.worldScale);
        this.origin = this.origin.sub((Vector3fc)scaleOffset, new Vector3f());
        Vector3f headPivot = this.preTickPose.createNewHeadPivot(this.origin, this.worldScale);
        float currentRotation = this.rotationY;
        float oldRotation = this.preTickPose.getRotationY();
        this.rotateOriginAround((Vector3fc)headPivot, oldRotation - currentRotation);
        this.postTickPose.update(this.origin, VRClientSettings.getWalkMultiplier(), this.worldScale, currentRotation);
        this.updatePlayerLook(VisorClientImpl.MC.f_91074_, PoseDataType.POST_TICK);
        ClientNetworking.sendVRPlayerPose();
    }

    public void earlyPreRender() {
        this.roomPose.update(VRMathUtils.ZERO_VECTOR, VRClientSettings.getWalkMultiplier(), 1.0f, 0.0f);
    }

    public void preRender(float partialTicks) {
        float rotationPre = this.preTickPose.getRotationY();
        float rotationPost = this.postTickPose.getRotationY();
        float rotationDelta = Math.abs(rotationPost - rotationPre);
        if ((double)rotationDelta > Math.PI) {
            if (rotationPost > rotationPre) {
                rotationPre = (float)((double)rotationPre + Math.PI * 2);
            } else {
                rotationPost = (float)((double)rotationPost + Math.PI * 2);
            }
        }
        float renderRotation = rotationPost * partialTicks + rotationPre * (1.0f - partialTicks);
        Vector3fc preTickOrigin = this.preTickPose.getOrigin();
        Vector3fc postTickOrigin = this.postTickPose.getOrigin();
        Vector3f renderOrigin = new Vector3f(preTickOrigin.x() + (postTickOrigin.x() - preTickOrigin.x()) * partialTicks, preTickOrigin.y() + (postTickOrigin.y() - preTickOrigin.y()) * partialTicks, preTickOrigin.z() + (postTickOrigin.z() - preTickOrigin.z()) * partialTicks);
        float preTickWorld = this.preTickPose.getWorldScale();
        float postTickWorld = this.postTickPose.getWorldScale();
        float renderWorldScale = postTickWorld * partialTicks + preTickWorld * (1.0f - partialTicks);
        this.renderPose.update((Vector3fc)renderOrigin, VRClientSettings.getWalkMultiplier(), renderWorldScale, renderRotation);
    }

    public void updatePlayerLook(LocalPlayer player, PoseDataType stage) {
        if (player == null) {
            return;
        }
        PoseDataImpl data = this.getPoseData(stage);
        if (player.m_20159_()) {
            Vector3fc vehicleLookDir = TaskRoomVehicle.getVehicleLookDirection(player);
            if (vehicleLookDir != null) {
                player.m_146926_((float)Math.toDegrees(Math.asin(-vehicleLookDir.y() / vehicleLookDir.length())));
                player.m_146922_((float)Math.toDegrees(Mth.m_14136_((double)(-vehicleLookDir.x()), (double)vehicleLookDir.z())));
                player.m_5616_(player.m_146908_());
            }
            return;
        }
        if (player.m_21254_()) {
            if (ClientContext.player.getActiveHand() == ControllerHand.MAIN) {
                player.m_146922_(data.getController(ControllerHand.MAIN).getYaw());
                player.m_5616_(player.m_146908_());
                player.m_146926_(-data.getController(ControllerHand.MAIN).getPitch());
            } else {
                player.m_146922_(data.getController(ControllerHand.OFFHAND).getYaw());
                player.m_5616_(player.m_146908_());
                player.m_146926_(-data.getController(ControllerHand.OFFHAND).getPitch());
            }
            return;
        }
        if (player.m_20142_() && (player.f_108618_.f_108572_ || VisorClientImpl.MC.f_91066_.f_92089_.m_90857_()) || player.m_21255_() || player.m_6069_() && player.f_20902_ > 0.0f) {
            PoseElement rotationElement = this.getRotationElement(data.getType());
            player.m_146922_(rotationElement.getYaw());
            player.m_5616_(player.m_146908_());
            player.m_146926_(-rotationElement.getPitch());
            return;
        }
        if (((GameRendererModified)VisorClientImpl.MC.f_91063_).visor$getCrossVec() != null) {
            Vec3 playerToCrosshair = player.m_20299_(1.0f).m_82546_(((GameRendererModified)VisorClientImpl.MC.f_91063_).visor$getCrossVec());
            double what = playerToCrosshair.f_82480_ / playerToCrosshair.m_82553_();
            if (what > 1.0) {
                what = 1.0;
            }
            if (what < -1.0) {
                what = -1.0;
            }
            float pitch = (float)Math.toDegrees(Math.asin(what));
            float yaw = (float)Math.toDegrees(Mth.m_14136_((double)playerToCrosshair.f_82479_, (double)(-playerToCrosshair.f_82481_)));
            player.m_146926_(pitch);
            player.m_146922_(yaw);
            player.m_5616_(yaw);
            return;
        }
        player.m_146922_(data.hmd.getYaw());
        player.m_5616_(player.m_146908_());
        player.m_146926_(-data.hmd.getPitch());
    }

    public void recenterOrigin(@NotNull Entity cameraEntity, boolean reset) {
        Vector3fc headPivot = this.preTickPose.getHeadPivot();
        Vector3f headOffset = headPivot.sub(this.preTickPose.getOrigin(), new Vector3f());
        float x = (float)(cameraEntity.m_20185_() - (double)headOffset.x);
        float z = (float)(cameraEntity.m_20189_() - (double)headOffset.z);
        float y = (float)cameraEntity.m_20186_();
        if (cameraEntity instanceof LocalPlayerModified) {
            LocalPlayerModified p = (LocalPlayerModified)cameraEntity;
            y += (float)p.visor$getRoomYOffset();
        }
        this.setOrigin(x, y, z, reset);
    }

    public void rotateOriginAround(Vector3fc anchor, float radians) {
        float radSin = Mth.m_14031_((float)radians);
        float radCos = Mth.m_14089_((float)radians);
        this.setOrigin(radCos * (this.origin.x() - anchor.x()) - radSin * (this.origin.z() - anchor.z()) + anchor.x(), this.origin.y(), radSin * (this.origin.x() - anchor.x()) + radCos * (this.origin.z() - anchor.z()) + anchor.z(), false);
    }

    public void setOrigin(float x, float y, float z, boolean reset) {
        Vector3f newOrigin = new Vector3f(x, y, z);
        if (reset) {
            this.preTickPose.resetOrigin((Vector3fc)newOrigin);
        }
        this.origin = newOrigin;
    }

    public void setRotationY(float rotationY) {
        this.rotationY = rotationY % ((float)Math.PI * 2);
    }

    @Override
    @Nullable
    public Player getMcPlayer() {
        return VisorClientImpl.MC.f_91074_;
    }

    public InteractionHand getActiveInteractHand() {
        return this.activeHand == ControllerHand.MAIN ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    @Override
    @NotNull
    public PoseElement getRotationElement(@NotNull PoseDataType stage) {
        PoseDataImpl playerPose = this.getPoseData(stage);
        return switch (VRClientSettings.getRotationMode()) {
            case RotationMode.MAIN_HAND -> playerPose.getController(ControllerHand.MAIN);
            case RotationMode.HMD -> playerPose.getHmd();
            default -> playerPose.getController(ControllerHand.OFFHAND);
        };
    }

    @Override
    @NotNull
    public PoseDataImpl getPoseData(@NotNull PoseDataType stage) {
        return switch (stage) {
            case PoseDataType.PRE_TICK -> this.preTickPose;
            case PoseDataType.POST_TICK -> this.postTickPose;
            case PoseDataType.RENDER -> this.renderPose;
            default -> this.roomPose;
        };
    }

    @Override
    @NotNull
    public ControllerRaw getControllerRaw(@NotNull ControllerHand hand) {
        return ClientContext.rawPoseHandler.getControllerData(hand);
    }

    @Override
    @NotNull
    public HmdRaw getHmdRaw() {
        return ClientContext.rawPoseHandler.getHmdData();
    }

    public String toString() {
        return "VRClientPlayer:\n    origin: %s\n    rotation: %.3f\n    scale: %.3f\n    room pose: %s\n    preTick pose: %s\n    postTick pose: %s\n    render pose: %s".formatted(this.origin, Float.valueOf(this.rotationY), Float.valueOf(this.worldScale), this.roomPose, this.preTickPose, this.postTickPose, this.renderPose);
    }

    public Vector3fc getOrigin() {
        return this.origin;
    }

    @Override
    public float getWorldScale() {
        return this.worldScale;
    }

    public float getRotationY() {
        return this.rotationY;
    }

    @Override
    public ControllerHand getActiveHand() {
        return this.activeHand;
    }

    public Vector2f getMovement() {
        return this.movement;
    }

    public boolean isMoving() {
        return this.moving;
    }

    public void setMoving(boolean moving) {
        this.moving = moving;
    }
}

