/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.gui;

import java.util.function.Function;
import me.phoenixra.visor.api.client.ClientFeature;
import me.phoenixra.visor.api.client.data.PoseData;
import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.data.PoseElement;
import me.phoenixra.visor.api.client.gui.VRCursorHandler;
import me.phoenixra.visor.api.client.gui.overlays.VROverlay;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.api.common.utils.VRMathUtils;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorState;
import me.phoenixra.visor.core.client.data.PoseDataImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VRCursorHandlerImpl
implements VRCursorHandler {
    private ControllerHand cursorHand = ControllerHand.MAIN;
    private VROverlay forceFocused;
    private boolean twoHandedCursor;
    private final CursorState mainHandState = new CursorState();
    private final CursorState offhandState = new CursorState();

    public void process() {
        PoseDataImpl renderPose = ClientContext.player.getPoseData(PoseDataType.RENDER);
        this.updateCursorState(ControllerHand.MAIN, this.mainHandState, renderPose);
        this.updateCursorState(ControllerHand.OFFHAND, this.offhandState, renderPose);
        this.updateOverlays();
    }

    private void updateCursorState(@NotNull ControllerHand hand, @NotNull CursorState state, @NotNull PoseData renderPose) {
        VRCursorHandler.CursorResult result;
        VROverlay previouslyFocused = state.focusedOverlay;
        if (ClientContext.visor.isFeatureEnabled(ClientFeature.GUI_CURSOR)) {
            result = this.getCursorResult(hand, renderPose, null, true);
            if (hand == this.cursorHand && this.forceFocused != null && result.focusedOverlay() != this.forceFocused) {
                this.forceFocused = null;
            }
        } else {
            result = new VRCursorHandler.CursorResult((Vector3fc)new Vector3f(-1.0f, -1.0f, -1.0f), null);
            this.forceFocused = null;
        }
        state.update(result.cursorPos(), result.focusedOverlay());
        if (previouslyFocused != null) {
            previouslyFocused.updateCursorData(true, -1.0f, -1.0f);
            previouslyFocused.updateCursorData(false, -1.0f, -1.0f);
        }
    }

    private void updateOverlays() {
        CursorState inactiveState;
        this.twoHandedCursor = this.offhandState.supportsTwoCursors() || this.mainHandState.supportsTwoCursors();
        CursorState activeState = this.cursorHand == ControllerHand.MAIN ? this.mainHandState : this.offhandState;
        CursorState cursorState = inactiveState = this.cursorHand == ControllerHand.MAIN ? this.offhandState : this.mainHandState;
        if (activeState.isFocused()) {
            activeState.focusedOverlay.updateCursorData(true, activeState.cursorPos.x(), activeState.cursorPos.y());
        }
        if (inactiveState.isFocused()) {
            inactiveState.focusedOverlay.updateCursorData(false, inactiveState.cursorPos.x(), inactiveState.cursorPos.y());
        }
    }

    @Override
    @NotNull
    public VRCursorHandler.CursorResult getCursorResult(@NotNull ControllerHand hand, @NotNull PoseData poseData, @Nullable Function<VROverlay, Boolean> overlayFilter, boolean checkForceFocused) {
        VROverlay collidingOverlay = null;
        Vector3f finalCursorPos = new Vector3f(0.0f, 0.0f, -1.0f);
        if (VisorState.getState().isNotFocused()) {
            return new VRCursorHandler.CursorResult((Vector3fc)finalCursorPos, collidingOverlay);
        }
        double closestDistance = Double.MAX_VALUE;
        PoseElement cursorElement = poseData.getController(hand);
        for (VROverlay overlay : ClientContext.overlayManager.getOverlaysRegistry().getSortedElements()) {
            boolean withinBounds;
            Vector3f cursorPos;
            boolean forcedFocus;
            if (!overlay.supportsCursor() || overlay.supportsCursorIgnoreVisible() && !overlay.isEnabled() || !overlay.supportsCursorIgnoreVisible() && !overlay.isVisible() || overlayFilter != null && !overlayFilter.apply(overlay).booleanValue()) continue;
            boolean bl = forcedFocus = checkForceFocused && hand == this.cursorHand && this.forceFocused == overlay;
            boolean facingGui = this.isFacingOverlay(cursorElement, overlay, false);
            if (!facingGui || (cursorPos = this.findCursorPosition3D(cursorElement, overlay.getPose().getPosition(), overlay.getPose().getRotation(), overlay.getPose().getScale(), overlay.getAspectRatio())).z() < 0.0f || cursorPos.z() > 5.0f || !forcedFocus && (double)cursorPos.z() > closestDistance || !(withinBounds = overlay.isWithinCursorBounds(cursorPos.x(), cursorPos.y()))) continue;
            finalCursorPos = cursorPos;
            collidingOverlay = overlay;
            closestDistance = cursorPos.z();
            if (!forcedFocus) continue;
            break;
        }
        return new VRCursorHandler.CursorResult((Vector3fc)finalCursorPos, collidingOverlay);
    }

    @Override
    public double getCursorLineLength(@NotNull ControllerHand hand) {
        return hand == ControllerHand.MAIN ? this.mainHandState.getCursorLength() : this.offhandState.getCursorLength();
    }

    @Override
    @Nullable
    public VROverlay getFocusedOverlay(@NotNull ControllerHand hand) {
        return hand == ControllerHand.MAIN ? this.mainHandState.focusedOverlay : this.offhandState.focusedOverlay;
    }

    @Override
    public boolean isFacingOverlay(@NotNull PoseElement element, @NotNull VROverlay overlay, boolean checkUpsideDown) {
        Matrix4fc overlayRot = overlay.getPose().getRotation();
        Vector3f elementForward = VRMathUtils.extractForwardDir(element.getRotation(), true);
        Vector3f overlayForward = VRMathUtils.extractForwardDir(overlayRot, true);
        Vector3f overlayUp = VRMathUtils.extractUpDir(overlayRot, true);
        Vector3f overlayRight = VRMathUtils.extractRightDir(overlayRot, true);
        Vector3fc elementPos = element.getPosition();
        Vector3fc overlayCenter = overlay.getPose().getPosition();
        float halfWidth = overlay.getPose().getHalfWidth();
        float halfHeight = overlay.getPose().getHalfHeight();
        Vector3f dir = new Vector3f(elementPos).sub(overlayCenter);
        float x = dir.dot((Vector3fc)overlayRight);
        float y = dir.dot((Vector3fc)overlayUp);
        float px = Math.max(-halfWidth, Math.min(halfWidth, x));
        float py = Math.max(-halfHeight, Math.min(halfHeight, y));
        Vector3f closest = new Vector3f(overlayCenter).fma(px, (Vector3fc)overlayRight).fma(py, (Vector3fc)overlayUp);
        Vector3f toOverlayDir = new Vector3f((Vector3fc)closest).sub(elementPos);
        float len = toOverlayDir.length();
        if (len < 1.0E-6f) {
            return false;
        }
        toOverlayDir.div(len);
        float elementDot = elementForward.dot((Vector3fc)toOverlayDir);
        float overlayDot = overlayForward.dot((Vector3fc)new Vector3f((Vector3fc)toOverlayDir).negate());
        if (elementDot <= 0.2f || overlayDot >= -0.2f) {
            return false;
        }
        if (!checkUpsideDown) {
            return true;
        }
        float upDot = overlayUp.dot(VRMathUtils.UP_VECTOR);
        return upDot > 0.2f;
    }

    @Override
    @NotNull
    public Vector3f findCursorPosition3D(@NotNull PoseElement element, @NotNull Vector3fc guiPosition, @NotNull Matrix4fc guiRotation, float guiScale, float guiAspectRatio) {
        PoseDataImpl renderPose = ClientContext.player.getPoseData(PoseDataType.RENDER);
        float worldScale = renderPose.getWorldScale();
        float effectiveScale = 1.5f * guiScale * worldScale;
        Vector3fc rayOrigin = element.getPosition();
        Vector3f rayDirection = element.getDirection().normalize(new Vector3f());
        Vector3f planeRight = VRMathUtils.extractRightDir(guiRotation, false);
        Vector3f planeUp = VRMathUtils.extractUpDir(guiRotation, false);
        Vector3f planeNormal = VRMathUtils.extractForwardDir(guiRotation, true);
        float denom = planeNormal.dot((Vector3fc)rayDirection);
        if (Math.abs(denom) < 1.0E-5f) {
            return new Vector3f(-1.0f, -1.0f, -1.0f);
        }
        float numerator = planeNormal.dot((Vector3fc)guiPosition.sub(rayOrigin, new Vector3f()));
        float t = numerator / denom;
        if (t <= 0.0f) {
            return new Vector3f(-1.0f, -1.0f, -1.0f);
        }
        Vector3f hitPoint = rayOrigin.add((Vector3fc)rayDirection.mul(t, new Vector3f()), new Vector3f());
        Vector3f local = hitPoint.sub((Vector3fc)guiPosition.sub((Vector3fc)planeRight.mul(0.5f, new Vector3f()), new Vector3f()).sub((Vector3fc)planeUp.mul(0.5f, new Vector3f())));
        float rawU = local.dot((Vector3fc)planeRight);
        float rawV = local.dot((Vector3fc)planeUp);
        float xPos = (rawU - 0.5f) / effectiveScale + 0.5f;
        float yPos = 1.0f - ((rawV - 0.5f) / (effectiveScale * guiAspectRatio) + 0.5f);
        return new Vector3f(xPos, yPos, t / worldScale);
    }

    @Override
    public ControllerHand getCursorHand() {
        return this.cursorHand;
    }

    @Override
    public void setCursorHand(ControllerHand cursorHand) {
        this.cursorHand = cursorHand;
    }

    @Override
    public VROverlay getForceFocused() {
        return this.forceFocused;
    }

    @Override
    public void setForceFocused(VROverlay forceFocused) {
        this.forceFocused = forceFocused;
    }

    @Override
    public boolean isTwoHandedCursor() {
        return this.twoHandedCursor;
    }

    private static class CursorState {
        private VROverlay focusedOverlay;
        private Vector3fc cursorPos = new Vector3f(-1.0f, -1.0f, -1.0f);

        private CursorState() {
        }

        void update(@NotNull Vector3fc newCursorPos, @Nullable VROverlay newFocusedOverlay) {
            this.cursorPos = newCursorPos;
            this.focusedOverlay = newFocusedOverlay;
        }

        boolean isFocused() {
            return this.focusedOverlay != null;
        }

        boolean supportsTwoCursors() {
            return this.focusedOverlay != null && this.focusedOverlay.supportsTwoCursors();
        }

        double getCursorLength() {
            return this.isFocused() ? (double)this.cursorPos.z() : -1.0;
        }
    }
}

