/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import me.phoenixra.visor.api.client.gui.VRGuiManager;
import me.phoenixra.visor.api.common.addon.element.VisorRegistry;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.gui.VRCursorHandlerImpl;
import me.phoenixra.visor.core.client.gui.VROverlayManagerImpl;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class VRGuiManagerImpl
implements VRGuiManager {
    private final int guiWidth = 1920;
    private final int guiHeight = 1080;
    private int scaleFactor = this.calculateScale(0, 1920, 1080);
    private int guiScaledWidth = Mth.m_14167_((float)(1920.0f / (float)this.scaleFactor));
    private int guiScaledHeight = Mth.m_14167_((float)(1080.0f / (float)this.scaleFactor));

    public VRGuiManagerImpl() {
        ClientContext.overlayManager = new VROverlayManagerImpl();
        ClientContext.cursorHandler = new VRCursorHandlerImpl();
    }

    public void renderGUI(PoseStack poseStack, float partialTicks) {
        ClientContext.overlayManager.renderOverlays(partialTicks, poseStack);
    }

    @Override
    public int calculateScale(int scaleIn, int guiWidth, int guiHeight) {
        int scale = 1;
        for (int i = 1; i < guiWidth && i < guiHeight && guiWidth / (i + 1) >= 320 && guiHeight / (i + 1) >= 240; ++i) {
            if (scale >= scaleIn && scaleIn != 0) continue;
            ++scale;
        }
        return scale;
    }

    public boolean updateResolution() {
        int oldWidth = 1920;
        int oldGuiScale = this.scaleFactor;
        this.scaleFactor = this.calculateScale((int)Math.ceil((float)((int)VRClientSettings.getGuiScale()) * 0.5f), 1920, 1080);
        this.guiScaledWidth = Mth.m_14167_((float)(1920.0f / (float)this.scaleFactor));
        this.guiScaledHeight = Mth.m_14167_((float)(1080.0f / (float)this.scaleFactor));
        if (oldWidth != 1920) {
            return true;
        }
        return oldGuiScale != this.scaleFactor;
    }

    public List<VisorRegistry<?>> getElementRegistries() {
        return List.of(ClientContext.overlayManager.getOverlaysRegistry(), ClientContext.overlayManager.getOverlayTemplatesRegistry());
    }

    @Override
    @NotNull
    public VROverlayManagerImpl getOverlayManager() {
        return ClientContext.overlayManager;
    }

    @Override
    @NotNull
    public VRCursorHandlerImpl getCursorHandler() {
        return ClientContext.cursorHandler;
    }

    @Override
    public int getGuiWidth() {
        return this.guiWidth;
    }

    @Override
    public int getGuiHeight() {
        return this.guiHeight;
    }

    @Override
    public int getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public int getGuiScaledWidth() {
        return this.guiScaledWidth;
    }

    @Override
    public int getGuiScaledHeight() {
        return this.guiScaledHeight;
    }
}

